<?php
/** Comment class
 *@author Pavel A. Savchuk
 */
class RCMS_Object_Comment_Comment extends RCMS_Core_BaseObject {

/**
 * Comment content
 *
 * @var string
 */
	private $_content;

	/**
	 * Container Id
	 *
	 * @var integer
	 */
	private $_containerId;

	/**
	 * Comment date
	 *
	 * @var date
	 */
	private $_date;

	/**
	 * Comment userID
	 *
	 * @var Integer
	 */
	private $_userId;

	/**
	 * Comment user email
	 *
	 * @var string
	 */
	private $_userEmail;

	/**
	 * Comment abuse
	 *
	 * @var integer
	 */
	private  $_abuse;

	/**
	 * Comment user name/nick
	 *
	 * @var string
	 */
	private  $_userSign;

	/**
	 * Comment user website url
	 *
	 * @var string
	 */
	private  $_userWebsite;

	/**
	 * Comment published
	 *
	 * @var integer
	 */
	private  $_publish;

	/**
	 * Comment rank
	 *
	 * @var integer
	 */
	private  $_rank;

	/**
	 * Comment keyword
	 *
	 * @var string
	 */
	private  $_keyword;

	/**
	 * Comment topic
	 *
	 * @var string
	 */
	private  $_topic;

	/**
	 * Notify user when new comment was posted
	 *
	 * @var integer
	 */
	private  $_notify;


	public function  __construct($id = null) {
		$this->_model = new RCMS_Object_Comment_CommentModel();
		if(intval($id)) {
			$comment = $this->_model->selectCommentById($id);
			if(is_object($comment)) {
				$this->setId($comment->id);
				$this->setContent($comment->content);
				$this->setConteinerId($comment->container_id);
				$this->setDate($comment->date);
				$this->setUserId($comment->user_id);
				$this->setUserEmail($comment->user_email);
				$this->setAbuse($comment->abuse);
				$this->setUserSign($comment->user_sign);
				$this->setUserWebsite($comment->user_website);
				$this->setPublish($comment->publish);
				$this->setRank($comment->rank);
				$this->setTopic($comment->topic);
				$this->setKeyword($comment->keyword);
				$this->setNotify($comment->notify);
			}
		}
	}

	/**
	 *Getter for content
	 *
	 *@return string
	 */
	public function getContent() {
		return $this->_content;
	}

	 /**
     * Setter for content
     *
     * @param string $content
     */
	public function setContent($content) {
		$this->_content = (string) $content;
	}

	/**
	 *Getter for container Id
	 *
	 *@return integer
	 */
	public function getConteinerId() {
		return $this->_containerId;
	}

	/**
     * Setter for container Id
     *
     * @param integer $containerId
     */
	public function setConteinerId($containerId) {
		$this->_containerId = (int) $containerId;
	}

	/**
	 *Getter for comment date
	 *
	 *@return date
	 */
	public function getDate() {
		return $this->_date;
	}

	/**
     * Setter for comment date
     *
     * @param string $date
     */
	public function setDate($date) {
		$this->_date =  $date;
	}

	/**
	 *Getter for comment user id
	 *
	 *@return integer
	 */
	public function getUserId() {
		return $this->_userId;
	}

	/**
     * Setter for comment user id
     *
     * @param integer $userId
     */
	public function setUserId($userId) {
		$this->_userId = $userId;
	}

	/**
	 *Getter for comment user email
	 *
	 *@return string
	 */
	public function getUserEmail() {
		return $this->_userEmail;
	}

	/**
     * Setter for comment user email
     *
     * @param string $userEmail
     */
	public function setUserEmail($userEmail) {
		$this->_userEmail = $userEmail;
	}

	/**
	 *Getter for comment abuse
	 *
	 *@return integer
	 */
	public function getAbuse() {
		return $this->_abuse;
	}

/**
     * Setter for comment abuse
     *
     * @param integer $date
     */
	public function setAbuse($abuse) {
		$this->_abuse = $abuse;
	}

/**
	 *Getter for comment user name/nick
	 *
	 *@return string
	 */
	public function getUserSign() {
		return $this->_userSign;
	}

/**
     * Setter for comment user name/nick
     *
     * @param string $userSign
     */
	public function setUserSign($userSign) {
		$this->_userSign = $userSign;
	}

/**
	 *Getter for comment user website
	 *
	 *@return string
	 */
	public function getUserWebsite() {
		return $this->_userWebsite;
	}

/**
     * Setter for comment user website
     *
     * @param string $userWebsite
     */
	public function setUserWebsite($userWebsite) {
		$this->_userWebsite = $userWebsite;
	}

/**
	 *Getter for comment publish
	 *
	 *@return integer
	 */
	public function getPublish() {
		return $this->_publish;
	}

/**
     * Setter for comment publish
     *
     * @param integer $publish
     */
	public function setPublish($publish) {
		$this->_publish = $publish;
	}

/**
	 *Getter for comment rank
	 *
	 *@return integer
	 */
	public function getRank() {
		return $this->_rank;
	}

/**
     * Setter for comment rank
     *
     * @param integer $rank
     */
	public function setRank($rank) {
		$this->_rank = $rank;
	}

/**
	 *Getter for comment keyword
	 *
	 *@return string
	 */
	public function getKeyword() {
		return $this->_keyword;
	}

/**
     * Setter for comment keyword
     *
     * @param string $keyword
     */
	public function setKeyword($keyword) {
		$this->_keyword = $keyword;
	}

/**
	 *Getter for comment topic
	 *
	 *@return string
	 */
	public function getTopic() {
		return $this->_topic;
	}

/**
     * Setter for comment topic
     *
     * @param string $topic
     */
	public function setTopic($topic) {
		$this->_topic = $topic;
	}

/**
	 *Getter for comment user notify flag
	 *
	 *@return integer
	 */
	public function getNotify() {
		return $this->_notify;
	}

/**
     * Setter for comment user notify flag
     *
     * @param integer $notify
     */
	public function setNotify($notify) {
		$this->_notify = $notify;
	}

	/**
	 * Delete comment
	 *
	 */
	public function delete() {
		return $this->_model->deleteComment($this->getId());
	}

	/**
	 * Insert container
	 *
	 */
	protected function _insert() {
		$id = (integer) $this->_model->insertComment($this);
		if($id > 0) {
			$this->setId($id);
			return $id;
		}
	}
	/**
	 * Update comment
	 *
	 */
	protected function _update() {
		return $this->_model->updateComment($this);
	}
}
