<?php
/**
 * Class for hosted seotoaster
 *
 * Provides additional functionality needed for hosted version of seotoaster
 * 
 */

class HostedSeoToasterTools {

	const HOSTED_STUFF_PATH = '/home/mondovis/hostedtoaster/';

	const APPINI_PATH = '../application/configs/application.ini';

	const SYMLINK_PATH = '/home/seotoast/toasters/';

	private static $_instance = null;

	private $_dbConnection = null;

	private $_realDomain = '';

	private $_websiteUrl = '';

	public static function getInstance() {
		if(null === self::$_instance) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function init(array $dbConfig, $websiteUrl) {
		$this->_connect($dbConfig);
		$this->_realDomain = $this->_getRealDomain();
		$this->_websiteUrl = $websiteUrl;
	}

	public function indexCheck() {
		$host = $_SERVER['HTTP_HOST'];
		if(('http://' . $host . '/' != $this->_websiteUrl) && (str_replace('www.', '', $host) == $this->_realDomain)) {
			$realSrvCode = $this->_makeSrvMoveCode();
			header('Location: ' . $this->_websiteUrl . 'go?tomove=' . $realSrvCode);
			exit;
		}
	}

	public function loginCheck() {
		$srvMoveCode = (isset($_GET['tomove'])) ? $_GET['tomove'] : '';
		if($srvMoveCode) {
			return $this->_validate($srvMoveCode);
		}
		return false;
	}

	public function move() {
		$newWebsiteUrl = 'http://www.'. $this->_realDomain . '/';
		$this->_processDb($newWebsiteUrl);
		$this->_processHtaccess();
		$this->_proccessApplicationIni($newWebsiteUrl);
		header('Location: ' . $newWebsiteUrl);
		exit;
	}

	private function _proccessApplicationIni($newUrl) {
		$appIni = file_get_contents(self::APPINI_PATH);
		$appIni = str_replace($this->_websiteUrl, $newUrl, $appIni);
		file_put_contents(self::APPINI_PATH, $appIni);
	}

	private function _processHtaccess() {
		$liveHtaccessContent = file_get_contents(self::HOSTED_STUFF_PATH . 'htaccesslive');
		file_put_contents('../.htaccess', $liveHtaccessContent);
	}

	private function _processDb($newUrl) {
		$contentQuery = sprintf("UPDATE `content` SET `content`.`value` = REPLACE(`content`.`value`, '%s', '%s');", $this->_websiteUrl, $newUrl);
		$renamedQuery = sprintf("UPDATE `renamed_pages` SET `renamed_pages`.`original_old_url` = REPLACE(`renamed_pages`.`original_old_url`, '%s', '%s');", $this->_websiteUrl, $newUrl);
		$deeplinkQuery = sprintf("UPDATE `deeplink` SET `deeplink`.`url` = REPLACE(`deeplink`.`url`, '%s', '%s');", $this->_websiteUrl, $newUrl);
		$templateQuery = sprintf("UPDATE `template` SET `template`.`content` = REPLACE(`template`.`content`, '%s', '%s');", $this->_websiteUrl, $newUrl);
		
		$this->_query($contentQuery);
		$this->_query($renamedQuery);
		$this->_query($deeplinkQuery);
		$this->_query($templateQuery);
	}

	private function _validate($moveCode) {
		return (boolean)($moveCode == $this->_makeSrvMoveCode());
	}

	private function _makeSrvMoveCode() {
		return substr(md5($this->_realDomain), 5, 8);
	}

	private function _getRealDomain() {
		$data = $this->_fetch($this->_query('SELECT `config`.`value` FROM `config` WHERE `config`.`name` = \'realdomain\''));
		return $data['value'];
	}

	private function _connect(array $dbConfig) {
		@mysql_close($this->_dbConnection);
		$this->_dbConnection = @mysql_connect($dbConfig['host'], $dbConfig['user'], $dbConfig['password']);
		@mysql_query('SET NAMES utf8;', $this->_dbConnection);
		@mysql_select_db($dbConfig['dbName'], $this->_dbConnection);
	}

	private function _query($query) {
		return mysql_query($query, $this->_dbConnection);
	}

	private function _fetch($result) {
		$fetched = array();
		while ($row = mysql_fetch_assoc($result)) {
			$fetched = $row;
		}
		return $fetched;
	}

}