<?php
/**
* User form object
*/
class RCMS_Form_UserForm extends RCMS_Core_BaseForm {

    /**
     * Initialization UserForm
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('post');

        $this->addElement('text', 'nickname', array(
            'id'            =>  'nickname',
            'required'      =>  'true',
            'validators'    =>  array(array('regex', false, array('/^[a-zA-Z0-9_\s-]{2,255}$/'))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );
        $this->nickname->removeDecorator('label');
        $this->nickname->removeDecorator('tag');
        $this->nickname->removeDecorator('Errors');

        $this->addElement('text', 'login', array(
            'id'            =>  'login',
            'required'      =>  'true',
            'validators'    =>  array(array('regex', false, array('/^[a-zA-Z0-9_-]{2,255}$/'))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );
        $this->login->removeDecorator('label');
        $this->login->removeDecorator('tag');
        $this->login->removeDecorator('Errors');

        $this->addElement('password', 'password', array(
            'id'            =>  'password',
            'required'      =>  'true',
            'validators'    =>  array(array('stringLength', false, array(5, 255))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
        $this->password->removeDecorator('label');
        $this->password->removeDecorator('tag');
        $this->password->removeDecorator('Errors');

        $this->addElement('text', 'email', array(
            'id'            =>  'email',
            'required'      =>  'true',
            'validators'    =>  array(array('regex', false, array('/^([a-zA-Z0-9_.-])+@(([a-zA-Z0-9-])+.)+([a-zA-Z0-9]{2,4})$/'))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );
        $this->email->removeDecorator('label');
        $this->email->removeDecorator('tag');
        $this->email->removeDecorator('Errors');

        $this->addElement('select', 'role', array(
            'id'	=>  'role',
            'required'  =>  'true'
            )
        );
        $this->role->removeDecorator('label');
        $this->role->removeDecorator('tag');
        $this->role->removeDecorator('Errors');

        $this->addElement('hidden', 'id', array('value' => '0'));
        $this->id->removeDecorator('label');
        $this->id->removeDecorator('tag');

        $this->addElement('submit', 'submit', array(
            'id'	=>  'submituser',
            'class'	=>  'formsubmit',
            'label'	=>  '{%Add%}',
            'required'  =>  'true'
            )
        );
        $this->submit->removeDecorator('tag');
        $this->submit->removeDecorator('DtDdWrapper');
    }
}
