<?php

class RCMS_Form_TemplateForm extends RCMS_Core_BaseForm {

    /**
     * Initialization of TemplateForm
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('post');
        $this->setName('templateForm');

        $this->addElement('text', 'name', array(
				'id'            =>  'templatename',
				'required'      =>  'true',
				'validators'    =>  array(array('stringLength', false, array(3, 255)), new Zend_Validate_Alnum(true)),
				'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
				'prefixPath' => $this->elementPrefixPaths,
				'filters'    => $this->elementFilters
            )
        );
        $this->name->removeDecorator('label');
        $this->name->removeDecorator('tag');
        $this->name->removeDecorator('Errors');

        $this->addElement('textarea', 'content', array (
            'id'	=>  'templatecode',
            'required'	=>  'true',
            'attribs'   =>  array('rows' => '20', 'cols' => '60'),
            'filters'   =>  array(new Zend_Filter_StringTrim()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );
        $this->content->removeDecorator('label');
        $this->content->removeDecorator('tag');
        $this->content->removeDecorator('Errors');

        $this->addElement('submit', 'submit', array(
            'class'		=>  'formsubmit',
            'id'		=>  'createtemplatesubmit',
            'ignore'            =>  'true',
            'label'		=>  '{%CREATE TEMPLATE%}'
            )
        );
        $this->submit->removeDecorator('label');
        $this->submit->removeDecorator('tag');
        $this->submit->removeDecorator('DtDdWrapper');

        $this->addElement('button', 'templateuploadpic', array(
            'class'     => 'templateuploadpic',
            'id'        => 'templateuploadpic',
            'label'     => '{%Chose Image%}'
            )
        );
        $this->templateuploadpic->removeDecorator('label');
        $this->templateuploadpic->removeDecorator('tag');
        $this->templateuploadpic->removeDecorator('Errors');

        $this->addElement('hidden', 'id', array());
        $this->id->removeDecorator('label');
        $this->id->removeDecorator('tag');
        $this->id->removeDecorator('Errors');

        $this->addElement('hidden', 'image_name', array());
        $this->image_name->removeDecorator('label');
        $this->image_name->removeDecorator('tag');
        $this->image_name->removeDecorator('Errors');

        $this->addElement('hidden', 'website_url', array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));
        $this->website_url->removeDecorator('label');
        $this->website_url->removeDecorator('tag');
        $this->website_url->removeDecorator('Errors');

        $this->_removeDecoratorErrors();
    }

    /**
     * This function returns array of themes.
     * @return <array>
     */
    private function getThemes()
    {
        $dirs = @scandir( unserialize(Zend_Registry::get('config'))->website->website->path . 'public/themes');
        $themes = array();
        foreach ($dirs as $dir) {
            if ($dir !== '.' && $dir !== '..' && $dir !== '.svn')
                    $themes[$dir] = $dir;
        }
        return $themes;
    }

    /**
     * This function sets  values for form.
     * @param (object)$template
     * @return <void>
     */
    public function setValues(RCMS_Object_Template_Template $template)
    {
        if ($elementText = $this->getElement('name')) {
            if ($elementText instanceof Zend_Form_Element_Text) {
                $name = $template->getName();
                $name = strtolower(str_replace("-"," ",RCMS_Tools_FilesystemTools::trimInternalSpaces($name)));
                $elementText->setValue($name);
            }
        }
        if ($elementTextarea = $this->getElement('content')) {
            if ($elementTextarea instanceof Zend_Form_Element_Textarea)
                $elementTextarea->setValue($template->getContent());
        }
        if ($elementHidden = $this->getElement('id')) {
            if ($elementHidden instanceof Zend_Form_Element_Hidden)
                $elementHidden->setValue($template->getId());
        }
        if ($elementHidden2 = $this->getElement('image_name')) {
            if ($elementHidden2 instanceof Zend_Form_Element_Hidden)
                $elementHidden2->setValue($template->getPreviewImage());
        }
    }

    /**
     * This function deletes Zend decorators.
     * @return <void>
     */
    private function _removeDecoratorErrors()
    {
       $this->getElement('name')->removeDecorator('Errors');
       $this->getElement('content')->removeDecorator('Errors');
    }
}
