<?php

/**
 * Redirect form for manage 301 redirects screen.
 * @author Pavel Savchuk
 */
class RCMS_Form_RedirectForm extends RCMS_Core_BaseForm
{
    /**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('POST');
        $this->setName('configForm');

        $this->addElement('text', 'oldurl', array(
           'id'         =>  'oldurl',
           'style'      =>  'width:330px;/*margin-right:20px;*/',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Zа-яА-Я0-9-\s\.\:]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			 'filters'    => $this->elementFilters
            )
        );

	$this->addElement('select', 'pages', array(
			'id'         =>  'pages',
			'style'      =>  'width:150px;margin-right:20px;',
			'validators' =>  array(array('regex', false, array('/^[a-zA-Zа-яА-Я0-9-\s]+$/'))),
			'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
            )
        );


		  $this->addElement('text', 'manualurl', array(
           'id'         =>  'manualurl',
           'style'      =>  'width:435px;/*margin-right:20px;*/',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Zа-яА-Я0-9-\s\.\:]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
		   'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

			  $this->addElement('checkbox', 'isexternal', array(
           'id'         =>  'isexternal',
            )
        );

		$this->addElement('button', 'rediractions', array(
            'id'        =>  'rediractions',
            'class'     =>  'formsubmit',
            'label'     =>  '{%Delete selected%}',
			'style'  => 'font-size:10px;position:absolute;left:10px;bottom:10px;'
            )
        );

       $this->addElement('button', 'addurl', array(
            'id'        =>  'add-redirect',
            'class'     =>  'formsubmit',
            'onclick'   =>  'addRedirect();',
            'label'	=>  '{%Add%}'
            )
        );

        $this->addElement('hidden', 'website_url', array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));
        $this->_removeDecoratorErrors();
        $this->setElementDecorators(array('ViewHelper', ));
    }
    
    /**
     * This function deletes Zend decorators.
     * @return <void>
     */
    private function _removeDecoratorErrors()
    {
        $this->getElement('oldurl')->removeDecorator('Errors');
        $this->getElement('pages')->removeDecorator('Errors');
    }
}
