<?php

/**
 * Page form for add/edit page.
 * @author Pavel Savchuk
 */
class RCMS_Form_PageForm extends RCMS_Core_BaseForm
{
    /**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('POST');
        $this->setName('pageForm');
		

        $this->addElement('text', 'h1', array(
                'id'            =>  'pageh1',
                'validators'    =>  array(array('regex', false, array('/^[^\/]+$/'))),
                'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
                'required'      =>  'true',
				'prefixPath' => $this->elementPrefixPaths,
			    'filters'    => $this->elementFilters
            )
        );


        $this->addElement('text', 'header_title', array(
                'id'        =>  'pagetitle',
                'filters'   =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
                'required'  => 'true',
				'prefixPath' => $this->elementPrefixPaths,
			    'filters'    => $this->elementFilters
            )
        );
        $this->addElement('text', 'url', array (
               'id'         =>  'pageurl',
			   //'validators' =>  array(array('regex', false, array('/^[\w0-9-\s_\x{30A0}-\x{30FF}\x{3040}-\x{309F}\x{4E00}-\x{9FBF}[:ascii:]]+$/u'))),
			   //'validators' =>  array(array('regex', false, array('/^[\w0-9-\s\'\`àâçéèêëîïôûùüÿñæœ]+$/i'))),
			   //'validators' =>  array(array('regex', false, array('/^[\w0-9-\s\'\`àâçéèêëîïôûùüÿñæœ]+$/u'))),
			   'validators' =>  array(array('regex', false, array('/^[\w0-9-\s\p{L}\p{M}\p{P}]+$/u'))),
               'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
               'required'   =>  'true',
			   'prefixPath' => $this->elementPrefixPaths,
			   'filters'    => $this->elementFilters
            )
        );
        //http://www.tractorexport.com/economie-et-%C3%A9cologie.html
        $this->addElement('text', 'nav_name', array (
               'id'         =>  'pagenavname',
               'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
               'required'   =>  'true',
			   'prefixPath' => $this->elementPrefixPaths,
			   'filters'    => $this->elementFilters
            )
        );

        $this->addElement('textarea', 'meta_description', array (
               'id'         =>  'pagemetadesc',
               'rows'       =>  6,
               'cols'       =>  35,
               'filters'    =>  array(new Zend_Filter_StringTrim()),
               'validators' =>  array(array('stringLength', false, array(3, 500))),
				'prefixPath' => $this->elementPrefixPaths,
				'filters'    => $this->elementFilters
            )
        );
        
        $this->addElement('textarea', 'meta_keywords', array (
               'id'         =>  'pagemetakeywords',
               'rows'       =>  6,
               'cols'       =>  35,
               'filters'    =>  array(new Zend_Filter_StringTrim()),
               'validators' =>  array(array('stringLength', false, array(3, 300))),
			   'prefixPath' => $this->elementPrefixPaths,
			   'filters'    => $this->elementFilters
            )
        );
        
        $this->addElement('textarea', 'short_description', array (
               'id'         =>  'pagecatshortdesc',
               'rows'       =>  6,
               'cols'       =>  35,
               'filters'    =>  array(new Zend_Filter_StringTrim()),
               'validators' =>  array(array('stringLength', false, array(3, 1000))),
			   'prefixPath' => $this->elementPrefixPaths,
			   'filters'    => $this->elementFilters
            )
        );

        $this->addElement('checkbox', 'is_404page', array (
                'id' =>  'pageis404'
            )
        );

        $this->addElement('checkbox', 'iscategory', array (
                'id'=>'pageiscategory'
            )
        );

        $this->addElement('radio', 'selectmenu', array(
                'disableLoadDefaultDecorators' => true
        ));

        $this->addElement('select', 'pageselectcategory', array (
                'id'    =>  'pageselectcategory'
            )
        );

        $this->addElement('submit', 'submit', array(
                'id'    =>  'createpagesubmit',
                'class' =>  'formsubmit',
                'label' =>  '{%CREATE PAGE%}'
            )
        );

		$this->addElement('hidden', 'h1image', array());
		$this->addElement('hidden', 'targetedKeyPhrase', array());
        $this->addElement('hidden', 'template_name', array());
        $this->addElement('hidden', 'featured_ids', array());
        $this->addElement('hidden', 'image_name', array());
        $this->addElement('hidden', 'image_path', array());
        $this->addElement('hidden', 'old_image_name', array());
        $this->addElement('hidden', 'isFLoad', array("value"=>0));
        $this->addElement('hidden', 'isTLoad', array("value"=>0));
        $this->addElement('hidden', 'template_id', array('value'=>0));
        $this->addElement('hidden', 'template_name', array());
        $this->addElement('hidden', 'website_url', array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));
        $this->addElement('hidden', 'page_id', array());
        $this->_removeDecoratorErrors();
        $this->setElementDecorators(array('ViewHelper',	));
    }
	
    /**
     * This function deletes Zend decorators.
     * @return <void>
     */
    private function _removeDecoratorErrors()
    {
        $this->getElement('h1')->removeDecorator('Errors');
        $this->getElement('header_title')->removeDecorator('Errors');
        $this->getElement('url')->removeDecorator('Errors');
        $this->getElement('nav_name')->removeDecorator('Errors');
        $this->getElement('meta_description')->removeDecorator('Errors');
        $this->getElement('meta_keywords')->removeDecorator('Errors');
        $this->getElement('short_description')->removeDecorator('Errors');
    }
}
