<?php

/**
 * LoginForm for user login page
 * @author eugene
 */
class RCMS_Form_LoginServiceForm extends Zend_Form
{
    /**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        parent::init();
        $this->setMethod('post');
        $this->setName('loginServiceForm');

        $this->addElement('select', 'service', array(
            'required'      =>  'true',
            'multioptions'  =>  array('picasa' => 'Picasa'),
            'value'         =>  'picasa',
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
        $this->service->removeDecorator('label');
        $this->service->removeDecorator('tag');
        $this->service->removeDecorator('Errors');

        $this->addElement('text', 'login', array(
            'id'            =>  'login',
            'required'      =>  'true',            
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
        $this->login->removeDecorator('label');
        $this->login->removeDecorator('tag');
        $this->login->removeDecorator('Errors');

        $this->addElement('password', 'password', array(
            'id'        =>  'password',
            'required'  =>  'true',
            'filters'   =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
        $this->password->removeDecorator('label');
        $this->password->removeDecorator('tag');
        $this->password->removeDecorator('Errors');

        $this->addElement('submit', 'submit', array(
            'ignore'    =>  'true',
            'required'  =>  'true',
            'class'     =>  'formsubmit',
            'label'     =>  '{%Sign in%}'
            )
        );
        $this->submit->removeDecorator('tag');
        $this->submit->removeDecorator('DtDdWrapper');
    }
}
