<?php

/**
 * Description of ImporterForm
 *
 * @author NE
 */
class RCMS_Form_ImporterForm extends RCMS_Core_BaseForm {

	/**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('post');
        $this->setName('importerForm');

        $this->addElement('text', 'siteUrl', array(
            'id'            =>  'former-site-url',
            'validators'    =>  array (array('stringLength', false, array(3, 255)), new Zend_Validate_Alnum(true)),
            'filters'       =>  array ( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'value'         => 'http://',
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('submit', 'import', array(
            'id'        => 'import-button',
            'class'     => 'formsubmit',
            'required'  => 'true',
            'label'     => '{%Import%}',
			'onclick'   => '$("#importer-importing").show();'
            )
        );
        $this->addElement('hidden', 'websiteUrl', array());
        $this->setElementDecorators(array('ViewHelper',	'Errors'));
    }
}

