<?php

/**
 * LoginForm for user login page
 *
 * @author eugene
 */
class RCMS_Form_FormsForm extends RCMS_Core_BaseForm
{
    /**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('POST');
        $this->setName('formScreenForm');

        $this->addElement('textarea', 'code', array (
           'id'         =>  'code',
           'rows'       =>  4,
           'cols'       =>  36,
           'style'      =>  'width:330px;height:80px;',
           'required'   =>  'true',
           'filters'    =>  array(new Zend_Filter_StringTrim()),
           'validators' =>  array(array('stringLength', false, array(3))),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );
        
        $this->addElement('text', 'email', array(
            'id'            =>  'email',
            'required'      =>  'true',
            'style'         =>  'width:150px;',
            'validators'    =>  array(array('regex', false, array('/^[A-z0-9_\-\.]+[@][A-z0-9_\-]+([.][A-z0-9_\-]+)+[A-z]{2,4}$/')),array('stringLength', false, array(3, 255))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('textarea', 'successMessage', array (
           'id'         =>  'successMessage',
           'required'   =>  'true',
           'rows'       =>  2,
           'cols'       =>  36,
           'style'      =>  'width:330px;height:40px;',
           'filters'    =>  array(new Zend_Filter_StringTrim()),
           'validators' =>  array(array('stringLength', false, array(3, 1800))),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('textarea', 'errorMessage', array (
           'id'         =>  'errorMessage',
           'rows'       =>  2,
           'cols'       =>  36,
           'style'      =>  'width:330px;height:40px;',
           'filters'    =>  array(new Zend_Filter_StringTrim()),
           'validators' =>  array(array('stringLength', false, array(3, 1800)))
            )
        );
        
        $this->addElement('text', 'emailFrom', array(
            'id'            =>  'emailFrom',
            'required'      =>  'true',
            'style'         =>  'width:150px;',
            'validators'    =>  array(array('regex', false, array('/^[A-z0-9_\-\.]+[@][A-z0-9_\-]+([.][A-z0-9_\-]+)+[A-z]{2,4}$/')),array('stringLength', false, array(3, 255))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );

        $this->addElement('textarea', 'emailMessage', array (
           'id'         =>  'emailMessage',
           'rows'       =>  2,
           'cols'       =>  36,
           'style'      =>  'width:330px;height:40px;',
           'filters'    =>  array(new Zend_Filter_StringTrim()),
           'validators' =>  array(array('stringLength', false, array(3, 255)))
            )
        );

        $this->addElement('checkbox', 'useSmtp', array ('id'=>'useSmtp','class'=>'input-checkbox','onclick'=>'changeState();'));
        $this->addElement('submit', 'formsubmit', array(
            'id'    =>  'form-screen-submit',
            'class' =>  'formsubmit',
            'label' =>  '{%Done%}'
            )
        );

        $this->addElement('hidden', 'websiteUrl', array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));
        $this->addElement('hidden', 'name', array());
        $this->addElement('hidden', 'id', array());
        $this->addElement('hidden','pageUrl', array());

        $this->_removeDecoratorErrors();
        $this->setElementDecorators(array('ViewHelper', ));
    }
	
    /**
     * This function deletes Zend decorators.
     * @return <void>
     */
    private function _removeDecoratorErrors()
    {
        $this->getElement('name')->removeDecorator('Errors');
        $this->getElement('code')->removeDecorator('Errors');
        $this->getElement('email')->removeDecorator('Errors');
        $this->getElement('emailFrom')->removeDecorator('Errors');
        $this->getElement('emailMessage')->removeDecorator('Errors');
        $this->getElement('successMessage')->removeDecorator('Errors');
        $this->getElement('errorMessage')->removeDecorator('Errors');
    }
}
