<?php
/**
 * FeaturedArea form.
 * @author Pavel Savchuk
 */
class RCMS_Form_FeaturedAreaForm extends RCMS_Core_BaseForm {
	
    /**
     * Initialization of FeaturedAreaForm
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('post');
        $this->setName('manageFeaturedArea');

        $this->addElement('text', 'featured_name', array(
            'id'            =>  'featured_name',
            'validators'    =>  array(array('stringLength', false, array(3, 255)), new Zend_Validate_Alnum(true)),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('button', 'add', array(
            'id'        =>  'addbutton',
            'class'     =>  'formsubmit',
            'required'  =>  'true',
            'label'     =>  '{%ADD%}',
            'onclick'   =>  'addf();'
            )
        );

        $this->addElement('button', 'done', array(
            'id'        =>  '{%done%}',
            'class'     =>  'formsubmit',
            'required'  =>  'true',
            'label'     =>  '{%Done%}',
            'onclick'   =>  'backToPage();'
            )
        );

        $this->addElement('hidden', 'website_url', array());
        $this->addElement('hidden', 'exists_flag', array());
        $this->setElementDecorators(array('ViewHelper', 'Errors'));
    }
}
