<?php
/**
 * Deeplink form for manage deeplinks screen
 *
 * @author Pavel Savchuk
 */
class RCMS_Form_DeeplinkForm extends RCMS_Core_BaseForm {

    /**
     * Initialization of DeeplinkForm
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('post');
        $this->setName('create_deeplink');

        $this->addElement('text', 'name', array(
            'required'  =>  'true',
            'style'     =>  'width:200px;',
            'id'        =>  'textanchor',
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('select', 'type', array(
            'id'            =>  'typelink',
            'required'      =>  'true',
            'style'         =>  'width:100px;',
            'multioptions'  =>  array('int' => 'Internal', 'ext' => 'External'),
            'value'         =>  'int',
            'onchange'      =>  'changeTypeDeeplink(this.value);'
            )
        );

        $this->addElement('select', 'selectpage', array(
            'id'            =>  'selectpage',
            'style'         =>  'width:120px;',
            'multioptions'  =>  array('' => 'select page')/*,
            'onchange'      =>  'document.getElementById(\'urldeeplink\').value=this.value;'*/
            )
        );
        
        $this->addElement('text', 'url', array(
            'id'        =>  'urldeeplink',
            'style'     =>  'width:530px;',
            'required'  =>  'true',
            'value'     =>  'http://',
            'readonly'  =>  'readonly',
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('checkbox', 'nofollow', array(
            'id'    =>  'nofollow',
            'value' =>  0
            )
        );

        $this->addElement('button', 'adddeeplink', array(
            'id'        =>  'add-deeplink',
            'class'     =>  'formsubmit',
            'onclick'   =>  'addDeeplink();',
            'required'  =>  'true',
            'label'     =>  '{%ADD%}'
            )
        );

         $this->addElement('button', 'editdeeplink', array(
            'id'        =>  'edit-deeplink',
            'class'     =>  'formsubmit',
            'required'  =>  'true',
            'label'     =>  '{%UPDATE%}',
            'style'     =>  "display:none;"
            )
        );
        
        $this->addElement('hidden', 'id', array());
        $this->addElement('hidden', 'action', array('value'=>''));
        $this->addElement('hidden', 'website_url',array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));        
        $this->setElementDecorators(array('ViewHelper', 'Errors'));
    }
}
