<?php

/**
 * Config Form for config page
 *
 * @author Pavel Savchuk
 */
class RCMS_Form_ConfigForm extends RCMS_Core_BaseForm
{
    /**
     * Form initialization
     * @see Zend_Form#init()
     */
    public function init()
    {
        $this->setMethod('POST');
        $this->setName('configForm');

        $this->addElement('text', 'currentTheme', array(
            'id'        =>  'currentTheme',
            'style'     =>  'width:200px;background-color:#CCCCCC;',
            'readonly'  =>  'readonly',
            'filters'   =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'defaultPage', array(
            'id'            =>  'defaultPage',
            'style'         =>  'width:80px;',
            'validators'    =>  array(array('regex', false, array('/^[a-zA-Zа-яА-Я0-9-\s]+$/'))),
            'filters'       =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'zfp', array (
           'id'         =>  'zfp',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Z0-9-.@]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'adminEmail', array (
           'id'         =>  'adminEmail',
           'required'   =>  'true',
           'style'      =>  'width:200px;',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Z0-9-.@]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'imgSmall', array (
           'id'         =>  'imgSmall',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
           )
        );

        $this->addElement('text', 'imgMedium', array (
           'id'         =>  'imgMedium',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'imgLarge', array (
           'id'         =>  'imgLarge',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
           )
        );

        $this->addElement('text', 'imgPageDescriptionSmall', array (
           'id'         =>  'imgPageDescriptionSmall',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'imgPageDescriptionLarge', array (
           'id'         =>  'imgPageDescriptionLarge',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'smtpHost', array (
           'id'         =>  'smtpHost',
           'style'      =>  'width:200px;',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Z0-9-.@]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'smtpPassword', array (
           'id'         =>  'smtpPassword',
           'style'      =>  'width:200px;',
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'smtpLogin', array (
           'id'         =>  'smtpLogin',
           'style'      =>  'width:200px;',
           'validators' =>  array(array('regex', false, array('/^[a-zA-Z0-9-.@]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('checkbox', 'useSmtp', array ('id'=>'useSmtp','class'=>'input-checkbox','onclick'=>'changeState();'));

		$this->addElement('text', 'pageImageTeaser', array (
           'id'         =>  'pageImageTeaser',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
       /*
	   $this->addElement('text', 'imgMaxWidth', array (
           'id'         =>  'imgMaxWidth',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );

        $this->addElement('text', 'videoWidth', array (
           'id'         =>  'videoWidth',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'videoHeight', array (
           'id'         =>  'videoHeight',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('text', 'videoHeight', array (
           'id'         =>  'videoHeight',
           'required'   =>  'true',
           'style'      =>  'width:80px;',
           'validators' =>  array(array('regex', false, array('/^[0-9]+$/'))),
           'filters'    =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags())
            )
        );
*/
        $this->addElement('text', 'loginUser', array (
            'required'  =>  'true',
            'style'     =>  'width:200px;',
            'filters'   =>  array( new Zend_Filter_StringTrim(), new Zend_Filter_StripTags()),
			'prefixPath' => $this->elementPrefixPaths,
			'filters'    => $this->elementFilters
            )
        );

        $this->addElement('password', 'passwordUser', array (
            'required'      =>  'true',
            'style'         =>  'width:200px;',
            'validators'    =>  array(array('stringLength', false, array(5, 255))/*,array('regex', false, array('/^[^\*]+$/'))*/),           'filters' => array(
                new Zend_Filter_StringTrim()
                )
            )
        );
        
        $this->addElement('submit', 'submit', array(
            'id'    =>  'editconfigsubmit',
            'class' =>  'formsubmit',
            'label' =>  '{%Done%}'
            )
        );

		$this->addElement('checkbox', 'pluginCache', array (
           'id'         =>  'plugin_cache'
           )
        );


        $this->addElement('hidden', 'website_url', array('value'=>unserialize(Zend_Registry::get('config'))->website->website->url));
        $this->_removeDecoratorErrors();
        $this->setElementDecorators(array('ViewHelper', ));
    }
	
    /**
     * This function deletes Zend decorators.
     * @return <void>
     */
    private function _removeDecoratorErrors()
    {
        $this->getElement('currentTheme')->removeDecorator('Errors');
        $this->getElement('defaultPage')->removeDecorator('Errors');
        $this->getElement('zfp')->removeDecorator('Errors');
        $this->getElement('adminEmail')->removeDecorator('Errors');
        $this->getElement('imgSmall')->removeDecorator('Errors');
        $this->getElement('imgMedium')->removeDecorator('Errors');
        $this->getElement('imgLarge')->removeDecorator('Errors');
        $this->getElement('imgPageDescriptionSmall')->removeDecorator('Errors');
        $this->getElement('imgPageDescriptionLarge')->removeDecorator('Errors');
        $this->getElement('smtpHost')->removeDecorator('Errors');
        $this->getElement('smtpPassword')->removeDecorator('Errors');
        $this->getElement('smtpLogin')->removeDecorator('Errors');
        $this->getElement('useSmtp')->removeDecorator('Errors');
		$this->getElement('pageImageTeaser')->removeDecorator('Errors');
     /*   $this->getElement('imgMaxWidth')->removeDecorator('Errors');
        $this->getElement('videoWidth')->removeDecorator('Errors');
        $this->getElement('videoHeight')->removeDecorator('Errors');*/
        $this->getElement('loginUser')->removeDecorator('Errors');
        $this->getElement('passwordUser')->removeDecorator('Errors');
    }
}
