<?php

/**
 * BaseController is the wrapper for Zend_Controller_Action
 *
 * We use it to extends Zend_Controller_Action with new methods that we may need
 *
 * @author eugene
 */
abstract class RCMS_Core_BaseapiController extends Zend_Controller_Action
{
    const API_FORMAT_JSON = 'json';

    const API_FORMAT_XML = 'xml';

    protected $_currApiFormat;
    /**
     * Model for current controller
     *
     * @var Model object
     */
    protected $_model = null;

    protected $_session = null;

    protected $_apiSecurity = null;

    protected $_updater = null;

    protected $_param = '';

    protected $_section = '';

    /**
     * Init method for BaseapiController.
     * @return void
     */
    public function init()
    {
        $this->_currApiFormat = self::API_FORMAT_JSON;
        $this->_session = new Zend_Session_Namespace();
        $this->_apiSecurity = new RCMS_Object_ApiSecurity_ApiSecurity();
    }

    /**
     * Index method.
     * @return void
     */
    public function indexAction()
    {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_section = $this->getRequest()->getParam('section');
        $this->_param = $this->getRequest()->getParam('param');
        $this->_currApiFormat = $this->_getApiFormatFromParam();
        $this->_cleanParam();
    }

    /**
     * This function returns format (xml or json) for api.
     * @return string
     */
    protected function _getApiFormatFromParam()
    {
        $format = '';
        if (stristr($this->_param, self::API_FORMAT_JSON)) {
            $format = self::API_FORMAT_JSON;
        } elseif (stristr($this->_param, self::API_FORMAT_XML)) {
            $format = self::API_FORMAT_XML;
        }
        return $format;
    }

    /**
     * This function clears params for api.
     * @return void
     */
    private function _cleanParam()
    {
        $this->_param = str_replace(array(self::API_FORMAT_JSON, self::API_FORMAT_XML, '.'), '', $this->_param);
    }

    /**
     * This function generates message of error for api.
     * @param string $message
     * @return void
     */
    protected function _sendErrorResponse($message)
    {
        $this->getResponse()->setBody($message);
        $this->getResponse()->setHttpResponseCode(400);
        $this->getResponse()->sendResponse();
        exit;
    }
    /**
     * This functin returns response for api.
     * @param array $data
     * @param boolean $noEncode
     * @return void
     */
    protected function _sendEncodedResponse($data, $noEncode = false)
    {
        if ($noEncode) {
            echo $data;
            exit;
        }
        if (!empty ($this->_currApiFormat)) {
            switch ($this->_currApiFormat) {
                case self::API_FORMAT_JSON :
                    $data = json_encode($data);
                    echo $data;
                    break;
                case self::API_FORMAT_XML :
                    echo "No XML.";
                    break;
            }
        }
    }
}
