<?php
/**
 * BaseObject abstract class for all our objects, that we will use in our RCMS
 *
 * @author eugene
 */
abstract class RCMS_Core_BaseObject {

    /**
     * Object id
     * @var integer
     */
    protected $_id = 0;

    /**
     * Object's Model
     * @var Model
     */
    protected $_model = null;

    /**
     * Save method for object.     
     * If object has id then update db, else insert data into db.
     */
    public function save()
    {
        if ($this->getId()) {
            return $this->_update();
        } else {
            return $this->_insert();
        }
    }

    /**
     * Getter for id.
     * @return integer
     */
    public function getId()
    {
        return $this->_id;
    }

    /**
     * Setter for object id.
     * @param integer $id
     */
    public function setId($id)
    {
        $this->_id = $id;
    }

    /**
     * Abstract update method for object. Should be redeclared in all child classes.
     */
    abstract protected function _update();

    /**    
     * Abstract delete method for object. Should be redeclared in all child classes.
     */
    abstract public function delete();

    /**
     * Abstract insert method for object. Should be redeclared in all child classes     
     */
    abstract protected function _insert();
}
