<?php

/**
 * BaseController is the wrapper for Zend_Controller_Action
 *
 * We use it to extends Zend_Controller_Action with new methods that we may need
 *
 * @author eugene
 */
abstract class RCMS_Core_BaseController extends Zend_Controller_Action
{
    /**
     * Model for current controller     
     * @var Model object
     */
    protected $_model = null;

    protected $_session = null;

    protected $_config;

    protected $_websiteUrl = '';

	protected $_translator = null;

	

	/**
	 * Cache object
	 *
	 * @var Zend_Cache
	 */
	protected $_cache = null;

    /**
     * Init method.
     * @return void
     */
    public function init() 
    {
		
		$this->getResponse()->setHeader('Content-Type', 'text/html')->sendHeaders('charset','UTF-8');
		//header("Content-Type: text/html; charset=UTF-8");
        $this->_config = unserialize(Zend_Registry::get('config'));
        $this->_session = new Zend_Session_Namespace('Default');
        $this->view->websiteUrl = unserialize(Zend_Registry::get('config'))->website->website->url;
		$langId = $this->_session->langId;
		$this->_translator = new RCMS_Object_Parser_LanguageParser($langId);
        if ($this->_session->isLogged) {
            if($this->_session->currentUser) {
                $this->view->currentUser = unserialize($this->_session->currentUser);
            }
        } else {
            $this->_session->isLogged = false;
        }
        $this->view->isLogged = $this->_session->isLogged;
        $this->view->config = $this->_config;
		$frontendOptions = array(
			'lifetime' => 7200, // cache lifetime of 2 hours
			'automatic_serialization' => true
		);
		$backendOptions = array(
			'cache_dir' => '../public/tmp/cache/' // Directory where to put the cache files
		);
		$this->_cache = Zend_Cache::factory('Core', 'File', $frontendOptions, $backendOptions);
    }

    /**
     * This function checks login of user.
     * @return void
     */
    public function checkLogin()
    {        
        if (!$this->_session->isLogged) {
            echo " <script type=\"text/javascript\">
            var tmpredirect = '".$this->view->websiteUrl."sys/login/index/';
            if(parent){
                parent.tb_remove();
                parent.window.location = tmpredirect;
             }
             window.location = tmpredirect;
            </script>";
          //$this->_redirect($this->view->websiteUrl . 'sys/login/index/');
           die();         
        }
    }

    /**
     * This function returns url of website.
     * @return string
     */
    public function getWebSiteUrl()
    {
       return unserialize(Zend_Registry::get('config'))->website->website->url;
    }

}
