<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
	/**
	 * Init DOCTYPE for views and make sure that we use XHTML DocType declaration
	 * 
	 */
	protected function _initDocType() {
		$this->bootstrap('view');
		$view = $this->getResource('view');
		$view->doctype('XHTML1_STRICT');
	}

	/**
	 * Init autoloader for our classes
	 * 
	 */
	protected function _initAutoload()
    {
		$resourceLoader = new Zend_Loader_Autoloader_Resource(array(
			'basePath'  => APPLICATION_PATH . '/app',
			'namespace' => 'RCMS',
		));
		$resourceLoader->addResourceType('form', 'forms/', 'Form');
		$resourceLoader->addResourceType('object', '/objects', 'Object');
		$resourceLoader->addResourceType('core', '/core', 'Core');
        $resourceLoader->addResourceType('tools', '/tools', 'Tools');

		$autoloader = new Zend_Application_Module_Autoloader(array(
            'namespace' => 'Default_',
            'basePath'  => dirname(__FILE__),
        ));

		$autoloader = new Zend_Application_Module_Autoloader(array(
            'namespace' => 'Backend_',
            'basePath'  => dirname(__FILE__),
        ));
	}

	protected function _initDB()
    {
		$config = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', 'database');
		$db = Zend_Db::factory($config->database);
		Zend_Db_Table_Abstract::setDefaultAdapter($db);
		Zend_Registry::set('db', serialize($db));
    }
    
    protected function _initConfig()
    {
		$xmlConfig = new Zend_Config_Xml(APPLICATION_PATH . '/configs/routesext.xml');
		$frontController = Zend_Controller_Front::getInstance();
		$router = $frontController->getRouter();
		$router->addConfig($xmlConfig, 'routes');

    	$config = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini');
    	Zend_Registry::set('config', serialize($config));
    }
}

