/*
 * Thickbox 3.1 - One Box To Rule Them All.
 * By Cody Lindley (http://www.codylindley.com)
 * Copyright (c) 2007 cody lindley
 * Licensed under the MIT License: http://www.opensource.org/licenses/mit-license.php
*/
		  
var mytuvi_pathToImage = "images/loadingAnimation.gif";

/*!!!!!!!!!!!!!!!!! edit below this line at your own risk !!!!!!!!!!!!!!!!!!!!!!!*/

//on page load call mytuvi_init
$(document).ready(function(){   
	mytuvi_init('a.thickbox, area.thickbox, input.thickbox');//pass where to apply thickbox
	imgLoader = new Image();// preload image
	imgLoader.src = mytuvi_pathToImage;
});

//add thickbox to href & area elements that have a class of .thickbox
function mytuvi_init(domChunk){
	$(domChunk).click(function(){
	var t = this.title || this.name || null;
	var a = this.href || this.alt;
	var g = this.rel || false;
	mytuvi_show(t,a,g);
	this.blur();
	return false;
	});
}

function mytuvi_show(caption, url, imageGroup) {//function called when the user clicks on a thickbox link

	try {
		if (typeof document.body.style.maxHeight === "undefined") {//if IE 6
			$("body","html").css({height: "100%", width: "100%"});
			$("html").css("overflow","hidden");
			if (document.getElementById("mytuvi_HideSelect") === null) {//iframe to hide select elements in ie6
				$("body").append("<iframe id='mytuvi_HideSelect'></iframe><div id='mytuvi_overlay'></div><div id='mytuvi_window'></div>");
				$("#mytuvi_overlay").click(mytuvi_remove);
			}
		}else{//all others
			if(document.getElementById("mytuvi_overlay") === null){
				$("body").append("<div id='mytuvi_overlay'></div><div id='mytuvi_window'></div>");
				$("#mytuvi_overlay").click(mytuvi_remove);
			}
		}
		
		if(mytuvi_detectMacXFF()){
			$("#mytuvi_overlay").addClass("mytuvi_overlayMacFFBGHack");//use png overlay so hide flash
		}else{
			$("#mytuvi_overlay").addClass("mytuvi_overlayBG");//use background and opacity
		}
		
		if(caption===null){caption="";}
		$("body").append("<div id='mytuvi_load'><img src='"+imgLoader.src+"' /></div>");//add loader to the page
		$('#mytuvi_load').show();//show loader
		
		var baseURL;
	   if(url.indexOf("?")!==-1){ //ff there is a query string involved
			baseURL = url.substr(0, url.indexOf("?"));
	   }else{ 
	   		baseURL = url;
	   }
	   
	   var urlString = /\.jpg$|\.jpeg$|\.png$|\.gif$|\.bmp$/;
	   var urlType = baseURL.toLowerCase().match(urlString);

		if(urlType == '.jpg' || urlType == '.jpeg' || urlType == '.png' || urlType == '.gif' || urlType == '.bmp'){//code to show images
				
			mytuvi_PrevCaption = "";
			mytuvi_PrevURL = "";
			mytuvi_PrevHTML = "";
			mytuvi_NextCaption = "";
			mytuvi_NextURL = "";
			mytuvi_NextHTML = "";
			mytuvi_imageCount = "";
			mytuvi_FoundURL = false;
			if(imageGroup){
				mytuvi_TempArray = $("a[@rel="+imageGroup+"]").get();
				for (mytuvi_Counter = 0; ((mytuvi_Counter < mytuvi_TempArray.length) && (mytuvi_NextHTML === "")); mytuvi_Counter++) {
					var urlTypeTemp = mytuvi_TempArray[mytuvi_Counter].href.toLowerCase().match(urlString);
						if (!(mytuvi_TempArray[mytuvi_Counter].href == url)) {						
							if (mytuvi_FoundURL) {
								mytuvi_NextCaption = mytuvi_TempArray[mytuvi_Counter].title;
								mytuvi_NextURL = mytuvi_TempArray[mytuvi_Counter].href;
								mytuvi_NextHTML = "<span id='mytuvi_next'>&nbsp;&nbsp;<a href='#'>Next &gt;</a></span>";
							} else {
								mytuvi_PrevCaption = mytuvi_TempArray[mytuvi_Counter].title;
								mytuvi_PrevURL = mytuvi_TempArray[mytuvi_Counter].href;
								mytuvi_PrevHTML = "<span id='mytuvi_prev'>&nbsp;&nbsp;<a href='#'>&lt; Prev</a></span>";
							}
						} else {
							mytuvi_FoundURL = true;
							mytuvi_imageCount = "Image " + (mytuvi_Counter + 1) +" of "+ (mytuvi_TempArray.length);											
						}
				}
			}

			imgPreloader = new Image();
			imgPreloader.onload = function(){		
			imgPreloader.onload = null;
				
			// Resizing large images - orginal by Christian Montoya edited by me.
			var pagesize = mytuvi_getPageSize();
			var x = pagesize[0] - 150;
			var y = pagesize[1] - 150;
			var imageWidth = imgPreloader.width;
			var imageHeight = imgPreloader.height;
			if (imageWidth > x) {
				imageHeight = imageHeight * (x / imageWidth); 
				imageWidth = x; 
				if (imageHeight > y) { 
					imageWidth = imageWidth * (y / imageHeight); 
					imageHeight = y; 
				}
			} else if (imageHeight > y) { 
				imageWidth = imageWidth * (y / imageHeight); 
				imageHeight = y; 
				if (imageWidth > x) { 
					imageHeight = imageHeight * (x / imageWidth); 
					imageWidth = x;
				}
			}
			// End Resizing
			
			mytuvi_WIDTH = imageWidth + 30;
			mytuvi_HEIGHT = imageHeight + 60;
			$("#mytuvi_window").append("<a href='' id='mytuvi_ImageOff' title='Close'><img id='mytuvi_Image' src='"+url+"' width='"+imageWidth+"' height='"+imageHeight+"' alt='"+caption+"'/></a>" + "<div id='mytuvi_caption'>"+caption+"<div id='mytuvi_secondLine'>" + mytuvi_imageCount + mytuvi_PrevHTML + mytuvi_NextHTML + "</div></div><div id='mytuvi_closeWindow'><a href='#' id='mytuvi_closeWindowButton' title='Close'>close</a> or Esc Key</div>"); 		
			
			$("#mytuvi_closeWindowButton").click(mytuvi_remove);
			
			if (!(mytuvi_PrevHTML === "")) {
				function goPrev(){
					if($(document).unbind("click",goPrev)){$(document).unbind("click",goPrev);}
					$("#mytuvi_window").remove();
					$("body").append("<div id='mytuvi_window'></div>");
					mytuvi_show(mytuvi_PrevCaption, mytuvi_PrevURL, imageGroup);
					return false;	
				}
				$("#mytuvi_prev").click(goPrev);
			}
			
			if (!(mytuvi_NextHTML === "")) {		
				function goNext(){
					$("#mytuvi_window").remove();
					$("body").append("<div id='mytuvi_window'></div>");
					mytuvi_show(mytuvi_NextCaption, mytuvi_NextURL, imageGroup);				
					return false;	
				}
				$("#mytuvi_next").click(goNext);
				
			}

			document.onkeydown = function(e){ 	
				if (e == null) { // ie
					keycode = event.keyCode;
				} else { // mozilla
					keycode = e.which;
				}
				if(keycode == 27){ // close
					mytuvi_remove();
				} else if(keycode == 190){ // display previous image
					if(!(mytuvi_NextHTML == "")){
						document.onkeydown = "";
						goNext();
					}
				} else if(keycode == 188){ // display next image
					if(!(mytuvi_PrevHTML == "")){
						document.onkeydown = "";
						goPrev();
					}
				}	
			};
			
			mytuvi_position();
			$("#mytuvi_load").remove();
			$("#mytuvi_ImageOff").click(mytuvi_remove);
			$("#mytuvi_window").css({display:"block"}); //for safari using css instead of show
			};
			
			imgPreloader.src = url;
		}else{//code to show html
			
			var queryString = url.replace(/^[^\?]+\??/,'');
			var params = mytuvi_parseQuery( queryString );

			mytuvi_WIDTH = (params['width']*1) || 630; //defaults to 630 if no paramaters were added to URL
			mytuvi_HEIGHT = (params['height']*1) || 440; //defaults to 440 if no paramaters were added to URL
			ajaxContentW = mytuvi_WIDTH;
			ajaxContentH = mytuvi_HEIGHT;
			
			if(url.indexOf('mytuvi_iframe') != -1){// either iframe or ajax window		
					urlNoQuery = url.split('mytuvi_');
					$("#mytuvi_iframeContent").remove();
					if(params['modal'] != "true"){//iframe no modal
						$("#mytuvi_window").append("<div id='mytuvi_title'><div id='mytuvi_ajaxWindowTitle'>"+caption+"</div><div id='mytuvi_closeAjaxWindow'><a href='#' id='mytuvi_closeWindowButton' title='Close'>close</a> or Esc Key</div></div><iframe frameborder='0' hspace='0' src='"+urlNoQuery[0]+"' id='mytuvi_iframeContent' name='mytuvi_iframeContent"+Math.round(Math.random()*1000)+"' onload='mytuvi_showIframe()' style='width:"+(ajaxContentW + 29)+"px;height:"+(ajaxContentH + 17)+"px;' > </iframe>");
					}else{//iframe modal
					$("#mytuvi_overlay").unbind();
						$("#mytuvi_window").append("<iframe frameborder='0' hspace='0' src='"+urlNoQuery[0]+"' id='mytuvi_iframeContent' name='mytuvi_iframeContent"+Math.round(Math.random()*1000)+"' onload='mytuvi_showIframe()' style='width:"+(ajaxContentW + 29)+"px;height:"+(ajaxContentH + 17)+"px;'> </iframe>");
					}
			}else{// not an iframe, ajax
					if($("#mytuvi_window").css("display") != "block"){
						if(params['modal'] != "true"){//ajax no modal
						$("#mytuvi_window").append("<div id='mytuvi_title'><div id='mytuvi_ajaxWindowTitle'>"+caption+"</div><div id='mytuvi_closeAjaxWindow'><a href='#' id='mytuvi_closeWindowButton'>close</a> or Esc Key</div></div><div id='mytuvi_ajaxContent' style='width:"+ajaxContentW+"px;height:"+ajaxContentH+"px'></div>");
						}else{//ajax modal
						$("#mytuvi_overlay").unbind();
						$("#mytuvi_window").append("<div id='mytuvi_ajaxContent' class='mytuvi_modal' style='width:"+ajaxContentW+"px;height:"+ajaxContentH+"px;'></div>");	
						}
					}else{//this means the window is already up, we are just loading new content via ajax
						$("#mytuvi_ajaxContent")[0].style.width = ajaxContentW +"px";
						$("#mytuvi_ajaxContent")[0].style.height = ajaxContentH +"px";
						$("#mytuvi_ajaxContent")[0].scrollTop = 0;
						$("#mytuvi_ajaxWindowTitle").html(caption);
					}
			}
					
			$("#mytuvi_closeWindowButton").click(mytuvi_remove);
			
				if(url.indexOf('mytuvi_inline') != -1){	
					$("#mytuvi_ajaxContent").append($('#' + params['inlineId']).children());
					$("#mytuvi_window").unload(function () {
						$('#' + params['inlineId']).append( $("#mytuvi_ajaxContent").children() ); // move elements back when you're finished
					});
					mytuvi_position();
					$("#mytuvi_load").remove();
					$("#mytuvi_window").css({display:"block"}); 
				}else if(url.indexOf('mytuvi_iframe') != -1){
					mytuvi_position();
					if($.browser.safari){//safari needs help because it will not fire iframe onload
						$("#mytuvi_load").remove();
						$("#mytuvi_window").css({display:"block"});
					}
				}else{
					$("#mytuvi_ajaxContent").load(url += "&random=" + (new Date().getTime()),function(){//to do a post change this load method
						mytuvi_position();
						$("#mytuvi_load").remove();
						mytuvi_init("#mytuvi_ajaxContent a.thickbox");
						$("#mytuvi_window").css({display:"block"});
					});
				}
			
		}

		if(!params['modal']){
			document.onkeyup = function(e){ 	
				if (e == null) { // ie
					keycode = event.keyCode;
				} else { // mozilla
					keycode = e.which;
				}
				if(keycode == 27){ // close
					mytuvi_remove();
				}	
			};
		}
		
	} catch(e) {
		//nothing here
	}
}

//helper functions below
function mytuvi_showIframe(){
	$("#mytuvi_load").remove();
	$("#mytuvi_window").css({display:"block"});
}

function mytuvi_remove() {
 	$("#mytuvi_imageOff").unbind("click");
	$("#mytuvi_closeWindowButton").unbind("click");
	$("#mytuvi_window").fadeOut("fast",function(){$('#mytuvi_window,#mytuvi_overlay,#mytuvi_HideSelect').trigger("unload").unbind().remove();});
	$("#mytuvi_load").remove();
	if (typeof document.body.style.maxHeight == "undefined") {//if IE 6
		$("body","html").css({height: "auto", width: "auto"});
		$("html").css("overflow","");
	}
	document.onkeydown = "";
	document.onkeyup = "";
	return false;
}

function mytuvi_position() {
$("#mytuvi_window").css({marginLeft: '-' + parseInt((mytuvi_WIDTH / 2),10) + 'px', width: mytuvi_WIDTH + 'px'});
	if ( !(jQuery.browser.msie && jQuery.browser.version < 7)) { // take away IE6
		$("#mytuvi_window").css({marginTop: '-' + parseInt((mytuvi_HEIGHT / 2),10) + 'px'});
	}
}

function mytuvi_parseQuery ( query ) {
   var Params = {};
   if ( ! query ) {return Params;}// return empty object
   var Pairs = query.split(/[;&]/);
   for ( var i = 0; i < Pairs.length; i++ ) {
      var KeyVal = Pairs[i].split('=');
      if ( ! KeyVal || KeyVal.length != 2 ) {continue;}
      var key = unescape( KeyVal[0] );
      var val = unescape( KeyVal[1] );
      val = val.replace(/\+/g, ' ');
      Params[key] = val;
   }
   return Params;
}

function mytuvi_getPageSize(){
	var de = document.documentElement;
	var w = window.innerWidth || self.innerWidth || (de&&de.clientWidth) || document.body.clientWidth;
	var h = window.innerHeight || self.innerHeight || (de&&de.clientHeight) || document.body.clientHeight;
	arrayPageSize = [w,h];
	return arrayPageSize;
}

function mytuvi_detectMacXFF() {
  var userAgent = navigator.userAgent.toLowerCase();
  if (userAgent.indexOf('mac') != -1 && userAgent.indexOf('firefox')!=-1) {
    return true;
  }
}


