
//    Allow users to select a date for use in an input field.


function load_calendar(str_target, str_datetime,str_url) {
        var arr_months = ["January", "February", "March", "April", "May", "June",
                "July", "August", "September", "October", "November", "December"];
        var week_days = ["S", "M", "T", "W", "T", "F", "S"];
        var n_weekstart = 0; // day week starts from (normally 0 or 1)

        var dt_datetime = (str_datetime == null || str_datetime =="" ?  new Date() : str2dt(str_datetime));

        var dt_prev_month = new Date(dt_datetime);
        dt_prev_month.setMonth(dt_datetime.getMonth()-1);

        var dt_next_month = new Date(dt_datetime);
        dt_next_month.setMonth(dt_datetime.getMonth()+1);
        var dt_firstday = new Date(dt_datetime);
        dt_firstday.setDate(1);

        dt_firstday.setDate(1-(7+dt_firstday.getDay()-n_weekstart)%7);
        var dt_lastday = new Date(dt_next_month);
        dt_lastday.setDate(0);
        

        // html generation (feel free to tune it for your particular application)
        // print calendar header
        var str_buffer = new String (
                "<html>\n"+
                "<head><title>Calendar</title></head>\n"+
                "<body style=\"background-color:transparent\">\n"+
                "<table class=\"clsOTable\" cellspacing=\"0\" cellspadding=\"0\" border=\"0\" width=\"100%\" style=\"position:absolute;left:0px;top:0px\">\n"+
                "<tr><td bgcolor=\"#000099\">\n"+
                "<table cellspacing=\"1\" cellpadding=\"3\" border=\"0\" width=\"100%\">\n "+
                "<tr>\n <td bgcolor=\"#000099\"><a href=\"javascript:parent.show_calendar('"+str_target+"','"+ dt2dtstr(dt_prev_month)+"','"+str_url+"');\">"+
                "<img src=\""+str_url+"auxiliary/images/left.jpg\" width=\"16\" height=\"16\" border=\"0\""+
                " alt=\"previous month\"></a></td>\n"+
                "       <td bgcolor=\"#000099\" colspan=\"5\" align=\"center\">"+
                "<font color=\"white\" face=\"arial, verdana\" size=\"1\">"
                +arr_months[dt_datetime.getMonth()]+" "+dt_datetime.getFullYear()+"</font></td>\n "+
                "       <td bgcolor=\"#000099\" align=\"right\"><a href=\"javascript:parent.show_calendar('"+str_target+"','"+dt2dtstr(dt_next_month)+"','"+str_url+"');\">"+
                "<img src=\""+str_url+"auxiliary/images/right.jpg\" width=\"16\" height=\"16\" border=\"0\""+
                " alt=\"next month\"></a></td>\n</tr>\n"
        );

        var dt_current_day = new Date(dt_firstday);
        // print weekdays titles
        str_buffer += "<tr>\n";
        for (var n=0; n<7; n++)
                str_buffer += " <td bgcolor=\"#78C0FF\">"+
                "<font color=\"white\" face=\"arial, verdana\" size=\"1\">"+
                week_days[(n_weekstart+n)%7]+"</font></td>\n";
        // print calendar table
        str_buffer += "</tr>\n";
        while (dt_current_day.getMonth() == dt_datetime.getMonth() || dt_current_day.getMonth() == dt_firstday.getMonth()) {
                // print row heder
                str_buffer += "<tr>\n";
                for (var n_current_wday=0; n_current_wday<7; n_current_wday++) {
                                if (dt_current_day.getDate() == dt_datetime.getDate() && dt_current_day.getMonth() == dt_datetime.getMonth())
                                        // print current date
                                        str_buffer += " <td bgcolor=\"#00FFFF\" align=\"center\">";
                                else if (dt_current_day.getDay() == 0 || dt_current_day.getDay() == 6)
                                        // weekend days
                                        str_buffer += " <td bgcolor=\"#99CCFF\" align=\"center\">";
                                else
                                        // print working days of current month
                                        str_buffer += " <td bgcolor=\"white\" align=\"center\">";

                                if (dt_current_day.getMonth() == dt_datetime.getMonth())
                                        // print days of current month
                                        str_buffer += "<a href=\"javascript:parent.document.getElementById('"+str_target+
                                        "').value='"+dt2dtstr(dt_current_day)+"'; parent.hide_calendar();\" style=\"text-decoration:none\">"+
                                        "<font color=\"black\" face=\"arial, verdana\" size=\"1\">";
                                else 
                                        // print days of other months
                                        str_buffer += "<a href=\"javascript:parent.document.getElementById('"+str_target+
                                        "').value='"+dt2dtstr(dt_current_day)+"'; parent.hide_calendar();\" style=\"text-decoration:none\">"+
                                        "<font color=\"gray\" face=\"arial, verdana\" size=\"1\">";
                                str_buffer += dt_current_day.getDate()+"</font></a></td>\n";
                                dt_current_day.setDate(dt_current_day.getDate()+1);
                }
                // print row footer
                str_buffer += "</tr>\n";
        }
        // print calendar footer
        

        return str_buffer;
}

function show_calendar(str_target,str_datetime,str_url){
        var str=load_calendar(str_target,str_datetime,str_url);
        var iCaldoc = iCal.document;
        iCaldoc.write(str);
        iCaldoc.close();


        el = document.getElementById(str_target);

        xPos = el.offsetLeft;
        tempEl = el.offsetParent;
        while (tempEl != null) {
                xPos += tempEl.offsetLeft;
                tempEl = tempEl.offsetParent;
        }

        yPos = el.offsetTop;
        tempEl = el.offsetParent;
        while (tempEl != null) {
                yPos += tempEl.offsetTop;
                tempEl = tempEl.offsetParent;
        }

        document.getElementById('iCal').style.top = yPos + el.offsetHeight + 2;
        document.getElementById('iCal').style.left = xPos;

}

function hide_calendar(){

        document.getElementById('iCal').style.left=-500
}

// datetime parsing and formatting routimes. modify them if you wish other datetime format
function str2dt (str_datetime) {
        var re_date = /^(\d\d)\-(\d\d)\-(\d\d\d\d)$/;
        if (!re_date.exec(str_datetime))
                return alert("Invalid Datetime format: "+ str_datetime);
        return (new Date (RegExp.$3, RegExp.$1-1, RegExp.$2));
}
function dt2dtstr (dt_datetime) {
        return (new String (
                        pd02((dt_datetime.getMonth()+1))+"-"+pd02(dt_datetime.getDate())))+"-"+dt_datetime.getFullYear();
}
function dt2tmstr (dt_datetime) {
        return (new String (
                        dt_datetime.getHours()+":"+dt_datetime.getMinutes()+":"+dt_datetime.getSeconds()));
}

function pd02(number){
        number = ""+number;

        if (number.length==0)
                return "00";
        else if (number.length==1)
                return "0" + number;
        else
                return number;
}
