/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.zeroturnaround.javarebel.Resource;

public class FileResource
implements Resource {
    private URL url;
    private File file;

    public FileResource(URL uRL) {
        this.url = uRL;
        this.file = new File(URLDecoder.decode(uRL.getPath()));
    }

    public byte[] getBytes() {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        try {
            int n2;
            long l2 = this.file.length();
            if (l2 > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] byArray = new byte[(int)l2];
            int n3 = 0;
            for (n2 = 0; n2 < byArray.length && (n3 = ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2)) >= 0; n2 += n3) {
            }
            if (n2 < byArray.length) {
                throw new IOException("Could not completely read file " + this.file.getName());
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.url.toString();
    }

    public URL toURL() {
        return this.url;
    }
}

