/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.ResourceSource;
import org.zeroturnaround.javarebel.support.FileResource;
import org.zeroturnaround.javarebel.support.URLResource;

public class ResourceUtil {
    private static final Method FIND_RESOURCE_METHOD = ResourceUtil.getClassLoaderMethod("findResource", new Class[]{String.class});
    private static final Method FIND_RESOURCES_METHOD = ResourceUtil.getClassLoaderMethod("findResources", new Class[]{String.class});

    private static Method getClassLoaderMethod(String string, Class[] classArray) {
        Method method = null;
        try {
            method = ClassLoader.class.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getInstance().errorEcho(noSuchMethodException);
        }
        return method;
    }

    public static URL findResource(ClassLoader classLoader, String string) {
        URL uRL;
        if (classLoader instanceof URLClassLoader) {
            uRL = ((URLClassLoader)classLoader).findResource(string);
        } else {
            try {
                uRL = (URL)FIND_RESOURCE_METHOD.invoke((Object)classLoader, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getTargetException());
            }
        }
        return uRL;
    }

    public static URL[] findResources(ClassLoader classLoader, String string) {
        Enumeration enumeration;
        if (classLoader instanceof URLClassLoader) {
            try {
                enumeration = ((URLClassLoader)classLoader).findResources(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            enumeration = (Enumeration)FIND_RESOURCES_METHOD.invoke((Object)classLoader, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] findResources(URLClassLoader uRLClassLoader, String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = uRLClassLoader.findResources(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] toURLs(Enumeration enumeration) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((URL)enumeration.nextElement());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static Enumeration toEnumeration(URL[] uRLArray) {
        return new Vector<URL>(Arrays.asList(uRLArray)).elements();
    }

    public static Resource getClassResource(ResourceSource resourceSource, String string) {
        if (string.startsWith("weblogic.") || string.startsWith("com.evermind.") || string.startsWith("oracle.") || string.startsWith("com.bea.") || string.startsWith("org.eclipse.osgi.") || string.startsWith("com.ibm.websphere") || string.startsWith("org.apache.jsp.")) {
            return null;
        }
        return resourceSource.getLocalResource(string.replace('.', '/') + ".class");
    }

    public static Resource[] asArray(Resource resource) {
        if (resource == null) {
            return null;
        }
        return new Resource[]{resource};
    }

    public static Resource getResource(ResourceSource resourceSource, Collection collection, String string) {
        Object object;
        if (resourceSource != null && (object = resourceSource.getLocalResource(string)) != null) {
            return object;
        }
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                ResourceSource resourceSource2 = (ResourceSource)object.next();
                Resource resource = resourceSource2.getLocalResource(string);
                if (resource == null) continue;
                return resource;
            }
        }
        return null;
    }

    public static Resource[] getResources(ResourceSource resourceSource, Collection collection, String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (resourceSource != null && (object = resourceSource.getLocalResources(string)) != null) {
            arrayList.addAll(Arrays.asList(object));
        }
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Resource[] resourceArray = ((ResourceSource)object.next()).getLocalResources(string);
                if (resourceArray == null) continue;
                arrayList.addAll(Arrays.asList(resourceArray));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    public static Resource asResource(URL uRL) {
        if (uRL.getProtocol().equals("file") || uRL.getProtocol().equals("vfsfile")) {
            return new FileResource(uRL);
        }
        return new URLResource(uRL);
    }

    public static InputStream asInputStream(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

