/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.bundled.javassist.ByteArrayClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.LoaderClassPath;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.LoggerFactory;

public abstract class JavassistClassBytecodeProcessor
implements ClassBytecodeProcessor {
    public final byte[] process(ClassLoader classLoader, String string, byte[] byArray) {
        try {
            string = string.replace('/', '.');
            ClassPool classPool = new ClassPool();
            classPool.appendClassPath(new ByteArrayClassPath(string, byArray));
            classPool.appendSystemPath();
            classPool.appendClassPath(new LoaderClassPath(classLoader));
            CtClass ctClass = classPool.get(string);
            ctClass.defrost();
            LoggerFactory.getInstance().log("Found Javassist class " + ctClass.getURL() + " for " + string);
            this.process(classPool, classLoader, ctClass);
            return ctClass.toBytecode();
        }
        catch (Throwable throwable) {
            LoggerFactory.getInstance().errorEcho(throwable);
            if (System.getProperty("rebel.fatal_plugin_loading") != null && Boolean.getBoolean("rebel.fatal_plugin_loading")) {
                throw new RuntimeException(throwable);
            }
            return byArray;
        }
    }

    public abstract void process(ClassPool var1, ClassLoader var2, CtClass var3) throws Exception;
}

