/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.streambase;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.generic.FindClassClassBytecodeProcessor;

public class StreamBaseJarClassLoaderCBP
extends FindClassClassBytecodeProcessor {
    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        super.process(classPool, classLoader, ctClass);
        this.reinitializeClassLoader(classPool, ctClass);
        this.resourceProviding(classPool, ctClass);
    }

    private void reinitializeClassLoader(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        classPool.importPackage("org.zeroturnaround.javarebel");
        try {
            ctClass.getDeclaredMethod("addJar").insertAfter("{  IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            LoggerFactory.getInstance().error(notFoundException);
        }
        try {
            ctClass.getDeclaredMethod("removeJar").insertAfter("{  IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            LoggerFactory.getInstance().error(notFoundException);
        }
    }

    private void resourceProviding(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        classPool.importPackage("java.io");
        classPool.importPackage("java.net");
        classPool.importPackage("java.util");
        classPool.importPackage("java.util.jar");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.streambase");
        classPool.importPackage("com.streambase.sb.util");
        boolean bl2 = false;
        try {
            ctClass.getDeclaredMethod("findResource");
        }
        catch (NotFoundException notFoundException) {
            bl2 = true;
        }
        if (bl2) {
            try {
                ctClass.removeMethod(ctClass.getDeclaredMethod("getResourceAsStream"));
            }
            catch (NotFoundException notFoundException) {
                LoggerFactory.getInstance().error(notFoundException);
            }
            ctClass.addMethod(CtNewMethod.make("protected URL findResource(String name) {  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResource($0, $1);  Msg.debug2(\"find findResource: {0}\", new Object[] { name });  Iterator i = this.jars.values().iterator();  if (i.hasNext()) {    JarFile jf = (JarFile)i.next();    JarEntry je = jf.getJarEntry(name);    if (je != null) {      return JarUtil.toURL(jf, je);    }  }  return null;}", ctClass));
            System.out.println("aaaaa");
        }
    }
}

