/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.sap;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.sap.SapResourceSource;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class SapResourceLoaderCBP
extends JavassistClassBytecodeProcessor {
    private Logger log = LoggerFactory.getInstance();

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.util");
        classPool.importPackage("java.net");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.support");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.util");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.sap");
        ctClass.addInterface(classPool.get(SapResourceSource.class.getName()));
        CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            CtConstructor ctConstructor = ctConstructorArray[i2];
            ctConstructor.insertAfter("IntegrationFactory.getInstance().registerClassLoader($0, new SapClassResourceSourceImpl((SapResourceSource) $0));");
        }
        CtMethod ctMethod = ctClass.getDeclaredMethod("loadLocalClass");
        ctMethod.insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       org.zeroturnaround.javarebel.IntegrationFactory.getInstance()        .findReloadableClass($0, $1);    if (result != null)      return result;}}");
        try {
            ctMethod = ctClass.getDeclaredMethod("getLocalResource", classPool.get(new String[]{String.class.getName()}));
            ctMethod.insertBefore("{  org.zeroturnaround.javarebel.Integration integration = org.zeroturnaround.javarebel.IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResource($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("getLocalResourceAsStream", classPool.get(new String[]{String.class.getName()}));
            ctMethod.insertBefore("{  org.zeroturnaround.javarebel.Integration integration = org.zeroturnaround.javarebel.IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return ResourceUtil.asInputStream(integration.findResource($0, $1));}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("findLocalResources", classPool.get(new String[]{String.class.getName()}));
            ctMethod.insertBefore("{  org.zeroturnaround.javarebel.Integration integration = org.zeroturnaround.javarebel.IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.addMethod(CtNewMethod.make("public Resource getRebelLocalResource(String resourcePath) {  URL url = getLocalResource(resourcePath);  if (url == null) return null;  return ResourceUtil.asResource(url);}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource[] getRebelLocalResources(String resourcePath) { URL[] urls = ResourceUtil.toURLs(findLocalResources(resourcePath));\n Resource[] result = new Resource[urls.length];\n    for (int i = 0; i < urls.length; i++) {\n      result[i] = ResourceUtil.asResource(urls[i]);\n    }\n    return result;}", ctClass));
    }
}

