/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.resin;

import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.resin.ResinPatchHelper;
import org.zeroturnaround.javarebel.integration.resin.WatchdogProcessCBP$1;
import org.zeroturnaround.javarebel.integration.resin.WatchdogProcessCBP$2;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.AgentUtil;

public class WatchdogProcessCBP
extends JavassistClassBytecodeProcessor {
    private static final Logger log = LoggerFactory.getInstance();
    private static final char CLASSPATH_SEPARATOR = File.pathSeparatorChar;
    private static final String NO_VERIFY = "-noverify";
    private static final String JAVA_AGENT = "-javaagent:" + AgentUtil.getRebelJarPath();
    private static final String REBEL_LOG_FILE = "rebel.log.file";
    private static final String REBEL_LOG_FILE_PREFIX = "-Drebel.log.file=";
    private static final String REBEL_LOG_FILE_SUFFIX = "-fork";

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.io");
        classPool.importPackage("java.net");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.resin");
        this.processConnectToChild(ctClass);
        this.processCreateProcess(classLoader, ctClass);
    }

    private void processConnectToChild(CtClass ctClass) throws CannotCompileException {
        try {
            ctClass.getDeclaredMethod("connectToChild").instrument(new WatchdogProcessCBP$1(this));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processCreateProcess(ClassLoader classLoader, CtClass ctClass) throws Exception {
        File file = ResinPatchHelper.createResinPatch(classLoader);
        ctClass.getDeclaredMethod("createProcess").instrument(new WatchdogProcessCBP$2(this, file));
    }

    public static void processArguments(List list) {
        try {
            list.add(1, NO_VERIFY);
            list.add(1, JAVA_AGENT);
            String string = System.getProperty(REBEL_LOG_FILE);
            if (string != null) {
                ListIterator<String> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    String string2 = (String)listIterator.next();
                    if (!string2.startsWith(REBEL_LOG_FILE_PREFIX)) continue;
                    int n2 = string2.lastIndexOf(46);
                    string2 = n2 < REBEL_LOG_FILE_PREFIX.length() ? string2 + REBEL_LOG_FILE_SUFFIX : string2.substring(0, n2) + REBEL_LOG_FILE_SUFFIX + string2.substring(n2);
                    listIterator.set(string2);
                }
            }
            if (log.isEnabled()) {
                log.log("JRebel-Resin: Exec args:" + list);
            }
        }
        catch (Throwable throwable) {
            log.error(throwable);
        }
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' || c2 == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ String access$000(String string) {
        return WatchdogProcessCBP.escape(string);
    }

    static /* synthetic */ char access$100() {
        return CLASSPATH_SEPARATOR;
    }
}

