/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.resin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.resin.ResinDynamicClassLoaderCBP;
import org.zeroturnaround.javarebel.integration.resin.ResinSystemClassLoaderCBP;
import org.zeroturnaround.javarebel.integration.resin.ResinWebAppCBP;
import org.zeroturnaround.javarebel.integration.util.ClassUtil;
import org.zeroturnaround.javarebel.integration.util.IoUtil;

public class ResinPatchHelper {
    private static boolean enabled;

    public static void setEnabled() {
        enabled = true;
    }

    public static void checkEnabled() {
        if (!ResinPatchHelper.isEnabled()) {
            ResinPatchHelper.error();
        }
    }

    private static boolean isEnabled() {
        return enabled;
    }

    private static void error() {
        System.out.println();
        System.out.println("#############################################################");
        System.out.println();
        System.out.println("              JavaRebel Resin installation problem!");
        System.out.println();
        System.out.println(" See http://www.zeroturnaround.com/resin-problem/");
        System.out.println(" or consult with the installation manual for correct");
        System.out.println(" JavaRebel installation with Resin server.");
        System.out.println();
        System.out.println("#############################################################");
        System.out.println();
    }

    public static File createResinPatch(ClassLoader classLoader) throws IOException {
        File file = File.createTempFile("javarebel-resin-patch", ".jar");
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        ResinPatchHelper.transformAndZip(jarOutputStream, classLoader, "com.caucho.loader.DynamicClassLoader", new ResinDynamicClassLoaderCBP());
        ResinPatchHelper.transformAndZip(jarOutputStream, classLoader, "com.caucho.loader.SystemClassLoader", new ResinSystemClassLoaderCBP());
        ResinPatchHelper.transformAndZip(jarOutputStream, classLoader, "com.caucho.server.webapp.WebApp", new ResinWebAppCBP());
        jarOutputStream.close();
        Logger logger = LoggerFactory.getInstance();
        if (logger.isEnabled()) {
            logger.log("Resin patch created: " + file);
        }
        return file;
    }

    private static void transformAndZip(JarOutputStream jarOutputStream, ClassLoader classLoader, String string, ClassBytecodeProcessor classBytecodeProcessor) throws IOException {
        byte[] byArray = ClassUtil.getBytecode(classLoader, string);
        byte[] byArray2 = classBytecodeProcessor.process(classLoader, string, byArray);
        Logger logger = LoggerFactory.getInstance();
        if (logger.isEnabled()) {
            logger.log("Class '" + string + "' processed by '" + classBytecodeProcessor.getClass().getName() + "' into JAR.");
        }
        jarOutputStream.putNextEntry(new ZipEntry(ClassUtil.getResourecName(string)));
        IoUtil.write(byArray2, jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

