/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.resin;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.resin.ResinDynamicClassLoaderCBP$1;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class ResinDynamicClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.io");
        classPool.importPackage("java.net");
        classPool.importPackage("java.util");
        classPool.importPackage("com.caucho.loader");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.generic");
        ctClass.getDeclaredMethod("init").insertAfter("{  if (!(this instanceof SystemClassLoader)) {    IntegrationFactory.getInstance().registerClassLoader($0, new FindResourceClassResourceSource($0));  }}");
        try {
            ctClass.getDeclaredMethod("addURL", classPool.get(new String[]{"int", "java.net.URL"})).insertAfter("{   IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.processClassLoading(ctClass);
        this.processResources(classPool, ctClass);
    }

    private void processClassLoading(CtClass ctClass) throws CannotCompileException, NotFoundException {
        String string = "findClass";
        try {
            ctClass.getDeclaredMethod("findClassImpl");
            string = "findClassImpl";
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.getDeclaredMethod(string).insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       IntegrationFactory.getInstance().findReloadableClass($0, $1);    if (result != null)      return result;}}");
    }

    private void processResources(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod;
        try {
            ctClass.getDeclaredMethod("getImportResource");
        }
        catch (NotFoundException notFoundException) {
            ctClass.addMethod(CtNewMethod.make("protected URL getImportResource(String name) {  return null;}", ctClass));
        }
        ctClass.addMethod(CtNewMethod.make("private URL __getLocalResource(String name) {  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, name))    return integration.findResource($0, name);  URL url = getImportResource(name);  if (url != null)    return url;  ArrayList loaders = getLoaders();  for (int i = 0; loaders != null && i < loaders.size(); i++) {    Loader loader = (Loader) loaders.get(i);    url = loader.getResource(name);    if (url != null)      return url;  }  return null;}", ctClass));
        ctClass.addMethod(CtNewMethod.make("private InputStream __getLocalResourceAsStream(String name) {  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, name)) {    URL url = integration.findResource($0, name);    if (url == null)      return null;    try {      return url.openStream();    } catch (IOException e) {      return null;    }  }  ArrayList loaders = getLoaders();  for (int i = 0; loaders != null && i < loaders.size(); i++) {    Loader loader = (Loader) loaders.get(i);    InputStream is = loader.getResourceAsStream(name);    if (is != null)      return is;  }  return null;}", ctClass));
        try {
            ctMethod = ctClass.getDeclaredMethod("getResource");
            ctMethod.setBody("{  if ($1.startsWith(\"/\"))    $1 = $1.substring(1);  if ($1.endsWith(\"/\"))    $1 = $1.substring(0, $1.length() - 1);  boolean isNormalJdkOrder = isNormalJdkOrder($1);  URL url;  if (isNormalJdkOrder) {    url = getParentResource($1);    if (url != null)      return url;  }  url = __getLocalResource($1);  if (url != null)    return url;  if (! isNormalJdkOrder) {    url = getParentResource($1);    if (url != null)      return url;  }  return null;}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("getResourceAsStream");
            ctMethod.setBody("{  if ($1.startsWith(\"/\"))    $1 = $1.substring(1);  if ($1.endsWith(\"/\"))    $1 = $1.substring(0, $1.length() - 1);  boolean isNormalJdkOrder = isNormalJdkOrder($1);  InputStream is;  if (isNormalJdkOrder) {    is = getParentResourceAsStream($1);    if (is != null)      return is;  }  is = __getLocalResourceAsStream($1);  if (is != null)    return is;  if (! isNormalJdkOrder) {    is = getParentResourceAsStream($1);    if (is != null)      return is;  }  return null;}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("findResources", classPool.get(new String[]{String.class.getName()}));
            ctMethod.insertBefore("{  String name = $1;  if (name.startsWith(\"/\"))    name = name.substring(1);  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, name))    return integration.findResources($0, name);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.getDeclaredMethod("getParentResource").instrument(new ResinDynamicClassLoaderCBP$1(this));
    }
}

