/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.google;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class GwtCompilingClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("org.zeroturnaround.javarebel");
        this.implementClassResourceSource(classPool, ctClass);
        CtConstructor[] ctConstructorArray = ctClass.getConstructors();
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            ctConstructorArray[i2].insertAfter("IntegrationFactory.getInstance().registerClassLoader($0, (ClassResourceSource) $0);");
        }
        ctClass.getDeclaredMethod("findClass").insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       IntegrationFactory.getInstance().findReloadableClass($0, $1);    if (result != null)      return result;}}");
    }

    private void implementClassResourceSource(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        classPool.importPackage("java.net");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.util");
        ctClass.addInterface(classPool.get("org.zeroturnaround.javarebel.ClassResourceSource"));
        ctClass.addMethod(CtNewMethod.make("public Resource getClassResource(String className) {  try {    ClassLoader cl = Thread.currentThread().getContextClassLoader();    String name = className.replace('.', '/') + \".class\";    URL url = cl.getResource(name);    if (url != null)      return ResourceUtil.asResource(url);  } catch (Throwable t) {    LoggerFactory.getInstance().error(t);  }  return null;}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource getLocalResource(String name) { return null; }", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource[] getLocalResources(String name) { return null; }", ctClass));
    }
}

