/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.rmi;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtField$Initializer;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtMethod$ConstParameter;
import org.zeroturnaround.bundled.javassist.CtNewConstructor;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.Translator;

public class StubGenerator
implements Translator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "org.zeroturnaround.bundled.javassist.tools.rmi.Sample";
    private ClassPool classPool;
    private Hashtable proxyClasses = new Hashtable();
    private CtMethod forwardMethod;
    private CtMethod forwardStaticMethod;
    private CtClass[] proxyConstructorParamTypes;
    private CtClass[] interfacesForProxy;
    private CtClass[] exceptionForProxy;
    static /* synthetic */ Class class$java$lang$Object;

    public void start(ClassPool classPool) throws NotFoundException {
        this.classPool = classPool;
        CtClass ctClass = classPool.get(sampleClass);
        this.forwardMethod = ctClass.getDeclaredMethod("forward");
        this.forwardStaticMethod = ctClass.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = classPool.get(new String[]{"org.zeroturnaround.bundled.javassist.tools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = classPool.get(new String[]{"java.io.Serializable", "org.zeroturnaround.bundled.javassist.tools.rmi.Proxy"});
        this.exceptionForProxy = new CtClass[]{classPool.get("org.zeroturnaround.bundled.javassist.tools.rmi.RemoteException")};
    }

    public void onLoad(ClassPool classPool, String string) {
    }

    public boolean isProxyClass(String string) {
        return this.proxyClasses.get(string) != null;
    }

    public synchronized boolean makeProxyClass(Class clazz) throws CannotCompileException, NotFoundException {
        String string = clazz.getName();
        if (this.proxyClasses.get(string) != null) {
            return false;
        }
        CtClass ctClass = this.produceProxyClass(this.classPool.get(string), clazz);
        this.proxyClasses.put(string, ctClass);
        this.modifySuperclass(ctClass);
        return true;
    }

    private CtClass produceProxyClass(CtClass ctClass, Class clazz) throws CannotCompileException, NotFoundException {
        int n2 = ctClass.getModifiers();
        if (Modifier.isAbstract(n2) || Modifier.isNative(n2) || !Modifier.isPublic(n2)) {
            throw new CannotCompileException(ctClass.getName() + " must be public, non-native, and non-abstract.");
        }
        CtClass ctClass2 = this.classPool.makeClass(ctClass.getName(), ctClass.getSuperclass());
        ctClass2.setInterfaces(this.interfacesForProxy);
        CtField ctField = new CtField(this.classPool.get("org.zeroturnaround.bundled.javassist.tools.rmi.ObjectImporter"), fieldImporter, ctClass2);
        ctField.setModifiers(2);
        ctClass2.addField(ctField, CtField$Initializer.byParameter(0));
        ctField = new CtField(CtClass.intType, fieldObjectId, ctClass2);
        ctField.setModifiers(2);
        ctClass2.addField(ctField, CtField$Initializer.byParameter(1));
        ctClass2.addMethod(CtNewMethod.getter(accessorObjectId, ctField));
        ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
        CtConstructor ctConstructor = CtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, ctClass2);
        ctClass2.addConstructor(ctConstructor);
        try {
            this.addMethods(ctClass2, clazz.getMethods());
            return ctClass2;
        }
        catch (SecurityException securityException) {
            throw new CannotCompileException(securityException);
        }
    }

    private CtClass toCtClass(Class clazz) throws NotFoundException {
        String string;
        if (!clazz.isArray()) {
            string = clazz.getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append("[]");
            } while ((clazz = clazz.getComponentType()).isArray());
            stringBuffer.insert(0, clazz.getName());
            string = stringBuffer.toString();
        }
        return this.classPool.get(string);
    }

    private CtClass[] toCtClass(Class[] classArray) throws NotFoundException {
        int n2 = classArray.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.toCtClass(classArray[i2]);
        }
        return ctClassArray;
    }

    private void addMethods(CtClass ctClass, Method[] methodArray) throws CannotCompileException, NotFoundException {
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            int n2 = method.getModifiers();
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? StubGenerator.class$("java.lang.Object") : class$java$lang$Object) || Modifier.isFinal(n2)) continue;
            if (Modifier.isPublic(n2)) {
                CtMethod ctMethod = Modifier.isStatic(n2) ? this.forwardStaticMethod : this.forwardMethod;
                CtMethod ctMethod2 = CtNewMethod.wrapped(this.toCtClass(method.getReturnType()), method.getName(), this.toCtClass(method.getParameterTypes()), this.exceptionForProxy, ctMethod, CtMethod$ConstParameter.integer(i2), ctClass);
                ctMethod2.setModifiers(n2);
                ctClass.addMethod(ctMethod2);
                continue;
            }
            if (Modifier.isProtected(n2) || Modifier.isPrivate(n2)) continue;
            throw new CannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtClass ctClass2;
        while ((ctClass2 = ctClass.getSuperclass()) != null) {
            try {
                ctClass2.getDeclaredConstructor(null);
                break;
            }
            catch (NotFoundException notFoundException) {
                ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
                ctClass = ctClass2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

