/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.rmi;

import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.tools.rmi.ObjectNotFoundException;
import org.zeroturnaround.bundled.javassist.tools.rmi.Proxy;
import org.zeroturnaround.bundled.javassist.tools.rmi.RemoteException;
import org.zeroturnaround.bundled.javassist.tools.rmi.RemoteRef;

public class ObjectImporter
implements Serializable {
    private final byte[] endofline = new byte[]{13, 10};
    private String servername;
    private String orgServername;
    private int port;
    private int orgPort;
    protected byte[] lookupCommand = "POST /lookup HTTP/1.0".getBytes();
    protected byte[] rmiCommand = "POST /rmi HTTP/1.0".getBytes();
    private static final Class[] proxyConstructorParamTypes = new Class[]{class$javassist$tools$rmi$ObjectImporter == null ? (class$javassist$tools$rmi$ObjectImporter = ObjectImporter.class$("org.zeroturnaround.bundled.javassist.tools.rmi.ObjectImporter")) : class$javassist$tools$rmi$ObjectImporter, Integer.TYPE};
    static /* synthetic */ Class class$javassist$tools$rmi$ObjectImporter;

    public ObjectImporter(Applet applet) {
        URL uRL = applet.getCodeBase();
        this.orgServername = this.servername = uRL.getHost();
        this.orgPort = this.port = uRL.getPort();
    }

    public ObjectImporter(String string, int n2) {
        this.orgServername = this.servername = string;
        this.orgPort = this.port = n2;
    }

    public Object getObject(String string) {
        try {
            return this.lookupObject(string);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
    }

    public void setHttpProxy(String string, int n2) {
        String string2 = "POST http://" + this.orgServername + ":" + this.orgPort;
        String string3 = string2 + "/lookup HTTP/1.0";
        this.lookupCommand = string3.getBytes();
        string3 = string2 + "/rmi HTTP/1.0";
        this.rmiCommand = string3.getBytes();
        this.servername = string;
        this.port = n2;
    }

    public Object lookupObject(String string) throws ObjectNotFoundException {
        try {
            Socket socket = new Socket(this.servername, this.port);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.lookupCommand);
            outputStream.write(this.endofline);
            outputStream.write(this.endofline);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeUTF(string);
            objectOutputStream.flush();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            this.skipHeader(bufferedInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            int n2 = objectInputStream.readInt();
            String string2 = objectInputStream.readUTF();
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
            if (n2 >= 0) {
                return this.createProxy(n2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ObjectNotFoundException(string, exception);
        }
        throw new ObjectNotFoundException(string);
    }

    private Object createProxy(int n2, String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(proxyConstructorParamTypes);
        return constructor.newInstance(this, new Integer(n2));
    }

    public Object call(int n2, int n3, Object[] objectArray) throws RemoteException {
        String string;
        Object object;
        boolean bl2;
        try {
            Socket socket = new Socket(this.servername, this.port);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(this.rmiCommand);
            ((OutputStream)bufferedOutputStream).write(this.endofline);
            ((OutputStream)bufferedOutputStream).write(this.endofline);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeInt(n2);
            objectOutputStream.writeInt(n3);
            this.writeParameters(objectOutputStream, objectArray);
            objectOutputStream.flush();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            this.skipHeader(bufferedInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            bl2 = objectInputStream.readBoolean();
            object = null;
            string = null;
            if (bl2) {
                object = objectInputStream.readObject();
            } else {
                string = objectInputStream.readUTF();
            }
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
            if (object instanceof RemoteRef) {
                RemoteRef remoteRef = (RemoteRef)object;
                object = this.createProxy(remoteRef.oid, remoteRef.classname);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException);
        }
        catch (Exception exception) {
            throw new RemoteException(exception);
        }
        if (bl2) {
            return object;
        }
        throw new RemoteException(string);
    }

    private void skipHeader(InputStream inputStream) throws IOException {
        int n2;
        do {
            int n3;
            n2 = 0;
            while ((n3 = inputStream.read()) >= 0 && n3 != 13) {
                ++n2;
            }
            inputStream.read();
        } while (n2 > 0);
    }

    private void writeParameters(ObjectOutputStream objectOutputStream, Object[] objectArray) throws IOException {
        int n2 = objectArray.length;
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] instanceof Proxy) {
                Proxy proxy = (Proxy)objectArray[i2];
                objectOutputStream.writeObject(new RemoteRef(proxy._getObjectId()));
                continue;
            }
            objectOutputStream.writeObject(objectArray[i2]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

