/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.rmi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.tools.rmi.ExportedObject;
import org.zeroturnaround.bundled.javassist.tools.rmi.RemoteRef;
import org.zeroturnaround.bundled.javassist.tools.rmi.StubGenerator;
import org.zeroturnaround.bundled.javassist.tools.web.BadHttpRequest;
import org.zeroturnaround.bundled.javassist.tools.web.Webserver;

public class AppletServer
extends Webserver {
    private StubGenerator stubGen;
    private Hashtable exportedNames = new Hashtable();
    private Vector exportedObjects = new Vector();
    private static final byte[] okHeader = "HTTP/1.0 200 OK\r\n\r\n".getBytes();

    public AppletServer(String string) throws IOException, NotFoundException, CannotCompileException {
        this(Integer.parseInt(string));
    }

    public AppletServer(int n2) throws IOException, NotFoundException, CannotCompileException {
        this(ClassPool.getDefault(), new StubGenerator(), n2);
    }

    public AppletServer(int n2, ClassPool classPool) throws IOException, NotFoundException, CannotCompileException {
        this(new ClassPool(classPool), new StubGenerator(), n2);
    }

    private AppletServer(ClassPool classPool, StubGenerator stubGenerator, int n2) throws IOException, NotFoundException, CannotCompileException {
        super(n2);
        this.stubGen = stubGenerator;
        this.addTranslator(classPool, stubGenerator);
    }

    public void run() {
        super.run();
    }

    public synchronized int exportObject(String string, Object object) throws CannotCompileException {
        Class<?> clazz = object.getClass();
        ExportedObject exportedObject = new ExportedObject();
        exportedObject.object = object;
        exportedObject.methods = clazz.getMethods();
        this.exportedObjects.addElement(exportedObject);
        exportedObject.identifier = this.exportedObjects.size() - 1;
        if (string != null) {
            this.exportedNames.put(string, exportedObject);
        }
        try {
            this.stubGen.makeProxyClass(clazz);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        return exportedObject.identifier;
    }

    public void doReply(InputStream inputStream, OutputStream outputStream, String string) throws IOException, BadHttpRequest {
        if (string.startsWith("POST /rmi ")) {
            this.processRMI(inputStream, outputStream);
        } else if (string.startsWith("POST /lookup ")) {
            this.lookupName(string, inputStream, outputStream);
        } else {
            super.doReply(inputStream, outputStream, string);
        }
    }

    private void processRMI(InputStream inputStream, OutputStream outputStream) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        Exception exception = null;
        Object object2 = null;
        try {
            object = (ExportedObject)this.exportedObjects.elementAt(n2);
            Object[] objectArray = this.readParameters(objectInputStream);
            object2 = this.convertRvalue(((ExportedObject)object).methods[n3].invoke(((ExportedObject)object).object, objectArray));
        }
        catch (Exception exception2) {
            exception = exception2;
            this.logging2(exception2.toString());
        }
        outputStream.write(okHeader);
        object = new ObjectOutputStream(outputStream);
        if (exception != null) {
            ((ObjectOutputStream)object).writeBoolean(false);
            ((ObjectOutputStream)object).writeUTF(exception.toString());
        } else {
            try {
                ((ObjectOutputStream)object).writeBoolean(true);
                ((ObjectOutputStream)object).writeObject(object2);
            }
            catch (NotSerializableException notSerializableException) {
                this.logging2(notSerializableException.toString());
            }
            catch (InvalidClassException invalidClassException) {
                this.logging2(invalidClassException.toString());
            }
        }
        ((ObjectOutputStream)object).flush();
        ((ObjectOutputStream)object).close();
        objectInputStream.close();
    }

    private Object[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = objectInputStream.readInt();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectInputStream.readObject();
            if (object instanceof RemoteRef) {
                RemoteRef remoteRef = (RemoteRef)object;
                ExportedObject exportedObject = (ExportedObject)this.exportedObjects.elementAt(remoteRef.oid);
                object = exportedObject.object;
            }
            objectArray[i2] = object;
        }
        return objectArray;
    }

    private Object convertRvalue(Object object) throws CannotCompileException {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (this.stubGen.isProxyClass(string)) {
            return new RemoteRef(this.exportObject(null, object), string);
        }
        return object;
    }

    private void lookupName(String string, InputStream inputStream, OutputStream outputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String string2 = DataInputStream.readUTF(objectInputStream);
        ExportedObject exportedObject = (ExportedObject)this.exportedNames.get(string2);
        outputStream.write(okHeader);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        if (exportedObject == null) {
            this.logging2(string2 + "not found.");
            objectOutputStream.writeInt(-1);
            objectOutputStream.writeUTF("error");
        } else {
            this.logging2(string2);
            objectOutputStream.writeInt(exportedObject.identifier);
            objectOutputStream.writeUTF(exportedObject.object.getClass().getName());
        }
        objectOutputStream.flush();
        objectOutputStream.close();
        objectInputStream.close();
    }
}

