/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.reflect;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CodeConverter;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtField$Initializer;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtMethod$ConstParameter;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.Translator;
import org.zeroturnaround.bundled.javassist.tools.reflect.CannotReflectException;

public class Reflection
implements Translator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "org.zeroturnaround.bundled.javassist.tools.reflect.Metaobject";
    static final String classMetaobjectClassName = "org.zeroturnaround.bundled.javassist.tools.reflect.ClassMetaobject";
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    private boolean isExcluded(String string) {
        return string.startsWith("_m_") || string.equals(classobjectAccessor) || string.equals(metaobjectSetter) || string.equals(metaobjectGetter) || string.startsWith(readPrefix) || string.startsWith(writePrefix);
    }

    public void start(ClassPool classPool) throws NotFoundException {
        this.classPool = classPool;
        String string = "javassist.tools.reflect.Sample is not found or broken.";
        try {
            CtClass ctClass = this.classPool.get("org.zeroturnaround.bundled.javassist.tools.reflect.Sample");
            this.trapMethod = ctClass.getDeclaredMethod("trap");
            this.trapStaticMethod = ctClass.getDeclaredMethod("trapStatic");
            this.trapRead = ctClass.getDeclaredMethod("trapRead");
            this.trapWrite = ctClass.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException("javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    public void onLoad(ClassPool classPool, String string) throws CannotCompileException, NotFoundException {
        CtClass ctClass = classPool.get(string);
        ctClass.instrument(this.converter);
    }

    public boolean makeReflective(String string, String string2, String string3) throws CannotCompileException, NotFoundException {
        return this.makeReflective(this.classPool.get(string), this.classPool.get(string2), this.classPool.get(string3));
    }

    public boolean makeReflective(Class clazz, Class clazz2, Class clazz3) throws CannotCompileException, NotFoundException {
        return this.makeReflective(clazz.getName(), clazz2.getName(), clazz3.getName());
    }

    public boolean makeReflective(CtClass ctClass, CtClass ctClass2, CtClass ctClass3) throws CannotCompileException, CannotReflectException, NotFoundException {
        if (ctClass.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + ctClass.getName());
        }
        if (ctClass.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + ctClass.getName());
        }
        if (ctClass.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + ctClass.getName());
        }
        this.registerReflectiveClass(ctClass);
        return this.modifyClassfile(ctClass, ctClass2, ctClass3);
    }

    private void registerReflectiveClass(CtClass ctClass) {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            CtField ctField = ctFieldArray[i2];
            int n2 = ctField.getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ctField.getName();
            this.converter.replaceFieldRead(ctField, ctClass, readPrefix + string);
            this.converter.replaceFieldWrite(ctField, ctClass, writePrefix + string);
        }
    }

    private boolean modifyClassfile(CtClass ctClass, CtClass ctClass2, CtClass ctClass3) throws CannotCompileException, NotFoundException {
        CtField ctField;
        boolean bl2;
        if (ctClass.getAttribute("Reflective") != null) {
            return false;
        }
        ctClass.setAttribute("Reflective", new byte[0]);
        CtClass ctClass4 = this.classPool.get("org.zeroturnaround.bundled.javassist.tools.reflect.Metalevel");
        boolean bl3 = bl2 = !ctClass.subtypeOf(ctClass4);
        if (bl2) {
            ctClass.addInterface(ctClass4);
        }
        this.processMethods(ctClass, bl2);
        this.processFields(ctClass);
        if (bl2) {
            ctField = new CtField(this.classPool.get(metaobjectClassName), metaobjectField, ctClass);
            ctField.setModifiers(4);
            ctClass.addField(ctField, CtField$Initializer.byNewWithParams(ctClass2));
            ctClass.addMethod(CtNewMethod.getter(metaobjectGetter, ctField));
            ctClass.addMethod(CtNewMethod.setter(metaobjectSetter, ctField));
        }
        ctField = new CtField(this.classPool.get(classMetaobjectClassName), classobjectField, ctClass);
        ctField.setModifiers(10);
        ctClass.addField(ctField, CtField$Initializer.byNew(ctClass3, new String[]{ctClass.getName()}));
        ctClass.addMethod(CtNewMethod.getter(classobjectAccessor, ctField));
        return true;
    }

    private void processMethods(CtClass ctClass, boolean bl2) throws CannotCompileException, NotFoundException {
        CtMethod[] ctMethodArray = ctClass.getMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            CtMethod ctMethod = ctMethodArray[i2];
            int n2 = ctMethod.getModifiers();
            if (!Modifier.isPublic(n2) || Modifier.isAbstract(n2)) continue;
            this.processMethods0(n2, ctClass, ctMethod, i2, bl2);
        }
    }

    private void processMethods0(int n2, CtClass ctClass, CtMethod ctMethod, int n3, boolean bl2) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod2;
        String string = ctMethod.getName();
        if (this.isExcluded(string)) {
            return;
        }
        if (ctMethod.getDeclaringClass() == ctClass) {
            if (Modifier.isNative(n2)) {
                return;
            }
            ctMethod2 = ctMethod;
            if (Modifier.isFinal(n2)) {
                ctMethod2.setModifiers(n2 &= 0xFFFFFFEF);
            }
        } else {
            if (Modifier.isFinal(n2)) {
                return;
            }
            ctMethod2 = CtNewMethod.delegator(this.findOriginal(ctMethod, bl2), ctClass);
            ctMethod2.setModifiers(n2 &= 0xFFFFFEFF);
            ctClass.addMethod(ctMethod2);
        }
        ctMethod2.setName("_m_" + n3 + "_" + string);
        CtMethod ctMethod3 = Modifier.isStatic(n2) ? this.trapStaticMethod : this.trapMethod;
        CtMethod ctMethod4 = CtNewMethod.wrapped(ctMethod.getReturnType(), string, ctMethod.getParameterTypes(), ctMethod.getExceptionTypes(), ctMethod3, CtMethod$ConstParameter.integer(n3), ctClass);
        ctMethod4.setModifiers(n2);
        ctClass.addMethod(ctMethod4);
    }

    private CtMethod findOriginal(CtMethod ctMethod, boolean bl2) throws NotFoundException {
        if (bl2) {
            return ctMethod;
        }
        String string = ctMethod.getName();
        CtMethod[] ctMethodArray = ctMethod.getDeclaringClass().getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            String string2 = ctMethodArray[i2].getName();
            if (!string2.endsWith(string) || !string2.startsWith("_m_") || !ctMethodArray[i2].getSignature().equals(ctMethod.getSignature())) continue;
            return ctMethodArray[i2];
        }
        return ctMethod;
    }

    private void processFields(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            CtField ctField = ctFieldArray[i2];
            int n2 = ctField.getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ctField.getName();
            CtClass ctClass2 = ctField.getType();
            CtMethod ctMethod = CtNewMethod.wrapped(ctClass2, readPrefix + string, this.readParam, null, this.trapRead, CtMethod$ConstParameter.string(string), ctClass);
            ctMethod.setModifiers(n2 |= 8);
            ctClass.addMethod(ctMethod);
            CtClass[] ctClassArray = new CtClass[]{this.classPool.get("java.lang.Object"), ctClass2};
            ctMethod = CtNewMethod.wrapped(CtClass.voidType, writePrefix + string, ctClassArray, null, this.trapWrite, CtMethod$ConstParameter.string(string), ctClass);
            ctMethod.setModifiers(n2);
            ctClass.addMethod(ctMethod);
        }
    }
}

