/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.reflect;

import java.io.PrintStream;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.tools.reflect.CompiledClass;
import org.zeroturnaround.bundled.javassist.tools.reflect.Reflection;

public class Compiler {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Compiler.help(System.err);
            return;
        }
        CompiledClass[] compiledClassArray = new CompiledClass[stringArray.length];
        int n2 = Compiler.parse(stringArray, compiledClassArray);
        if (n2 < 1) {
            System.err.println("bad parameter.");
            return;
        }
        Compiler.processClasses(compiledClassArray, n2);
    }

    private static void processClasses(CompiledClass[] compiledClassArray, int n2) throws Exception {
        int n3;
        Reflection reflection = new Reflection();
        ClassPool classPool = ClassPool.getDefault();
        reflection.start(classPool);
        for (n3 = 0; n3 < n2; ++n3) {
            CtClass ctClass = classPool.get(compiledClassArray[n3].classname);
            if (compiledClassArray[n3].metaobject != null || compiledClassArray[n3].classobject != null) {
                String string = compiledClassArray[n3].metaobject == null ? "org.zeroturnaround.bundled.javassist.tools.reflect.Metaobject" : compiledClassArray[n3].metaobject;
                String string2 = compiledClassArray[n3].classobject == null ? "org.zeroturnaround.bundled.javassist.tools.reflect.ClassMetaobject" : compiledClassArray[n3].classobject;
                if (!reflection.makeReflective(ctClass, classPool.get(string), classPool.get(string2))) {
                    System.err.println("Warning: " + ctClass.getName() + " is reflective.  It was not changed.");
                }
                System.err.println(ctClass.getName() + ": " + string + ", " + string2);
                continue;
            }
            System.err.println(ctClass.getName() + ": not reflective");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            reflection.onLoad(classPool, compiledClassArray[n3].classname);
            classPool.get(compiledClassArray[n3].classname).writeFile();
        }
    }

    private static int parse(String[] stringArray, CompiledClass[] compiledClassArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.equals("-m")) {
                if (n2 < 0 || i2 + 1 > stringArray.length) {
                    return -1;
                }
                compiledClassArray[n2].metaobject = stringArray[++i2];
                continue;
            }
            if (string.equals("-c")) {
                if (n2 < 0 || i2 + 1 > stringArray.length) {
                    return -1;
                }
                compiledClassArray[n2].classobject = stringArray[++i2];
                continue;
            }
            if (string.charAt(0) == '-') {
                return -1;
            }
            CompiledClass compiledClass = new CompiledClass();
            compiledClass.classname = string;
            compiledClass.metaobject = null;
            compiledClass.classobject = null;
            compiledClassArray[++n2] = compiledClass;
        }
        return n2 + 1;
    }

    private static void help(PrintStream printStream) {
        printStream.println("Usage: java javassist.tools.reflect.Compiler");
        printStream.println("            (<class> [-m <metaobject>] [-c <class metaobject>])+");
    }
}

