/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.tools.reflect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.zeroturnaround.bundled.javassist.tools.reflect.CannotCreateException;
import org.zeroturnaround.bundled.javassist.tools.reflect.CannotInvokeException;

public class ClassMetaobject
implements Serializable {
    static final String methodPrefix = "_m_";
    static final int methodPrefixLen = 3;
    private Class javaClass;
    private Constructor[] constructors;
    private Method[] methods;
    public static boolean useContextClassLoader = false;

    public ClassMetaobject(String[] stringArray) {
        try {
            this.javaClass = this.getClassObject(stringArray[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("not found: " + stringArray[0] + ", useContextClassLoader: " + Boolean.toString(useContextClassLoader), classNotFoundException);
        }
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.javaClass.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.javaClass = this.getClassObject(objectInputStream.readUTF());
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private Class getClassObject(String string) throws ClassNotFoundException {
        if (useContextClassLoader) {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        return Class.forName(string);
    }

    public final Class getJavaClass() {
        return this.javaClass;
    }

    public final String getName() {
        return this.javaClass.getName();
    }

    public final boolean isInstance(Object object) {
        return this.javaClass.isInstance(object);
    }

    public final Object newInstance(Object[] objectArray) throws CannotCreateException {
        int n2 = this.constructors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                return this.constructors[i2].newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new CannotCreateException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CannotCreateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CannotCreateException(invocationTargetException);
            }
        }
        throw new CannotCreateException("no constructor matches");
    }

    public Object trapFieldRead(String string) {
        Class clazz = this.getJavaClass();
        try {
            return clazz.getField(string).get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public void trapFieldWrite(String string, Object object) {
        Class clazz = this.getJavaClass();
        try {
            clazz.getField(string).set(null, object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public static Object invoke(Object object, int n2, Object[] objectArray) throws Throwable {
        Method[] methodArray = object.getClass().getMethods();
        int n3 = methodArray.length;
        String string = methodPrefix + n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!methodArray[i2].getName().startsWith(string)) continue;
            try {
                return methodArray[i2].invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CannotInvokeException(illegalAccessException);
            }
        }
        throw new CannotInvokeException("cannot find a method");
    }

    public Object trapMethodcall(int n2, Object[] objectArray) throws Throwable {
        try {
            Method[] methodArray = this.getReflectiveMethods();
            return methodArray[n2].invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CannotInvokeException(illegalAccessException);
        }
    }

    public final Method[] getReflectiveMethods() {
        int n2;
        if (this.methods != null) {
            return this.methods;
        }
        Class clazz = this.getJavaClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n3 = methodArray.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2;
            Method method = methodArray[n2];
            String string = method.getName();
            if (!string.startsWith(methodPrefix)) continue;
            int n5 = 0;
            int n6 = 3;
            while ('0' <= (c2 = string.charAt(n6)) && c2 <= '9') {
                n5 = n5 * 10 + c2 - 48;
                ++n6;
            }
            nArray[n2] = ++n5;
            if (n5 <= n4) continue;
            n4 = n5;
        }
        this.methods = new Method[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] <= 0) continue;
            this.methods[nArray[n2] - 1] = methodArray[n2];
        }
        return this.methods;
    }

    public final Method getMethod(int n2) {
        return this.getReflectiveMethods()[n2];
    }

    public final String getMethodName(int n2) {
        char c2;
        String string = this.getReflectiveMethods()[n2].getName();
        int n3 = 3;
        while ((c2 = string.charAt(n3++)) >= '0' && '9' >= c2) {
        }
        return string.substring(n3);
    }

    public final Class[] getParameterTypes(int n2) {
        return this.getReflectiveMethods()[n2].getParameterTypes();
    }

    public final Class getReturnType(int n2) {
        return this.getReflectiveMethods()[n2].getReturnType();
    }

    public final int getMethodIndex(String string, Class[] classArray) throws NoSuchMethodException {
        Method[] methodArray = this.getReflectiveMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if (methodArray[i2] == null || !this.getMethodName(i2).equals(string) || !Arrays.equals(classArray, methodArray[i2].getParameterTypes())) continue;
            return i2;
        }
        throw new NoSuchMethodException("Method " + string + " not found");
    }
}

