/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public class TransformReadField
extends Transformer {
    protected String fieldname;
    protected CtClass fieldClass;
    protected boolean isPrivate;
    protected String methodClassname;
    protected String methodName;

    public TransformReadField(Transformer transformer, CtField ctField, String string, String string2) {
        super(transformer);
        this.fieldClass = ctField.getDeclaringClass();
        this.fieldname = ctField.getName();
        this.methodClassname = string;
        this.methodName = string2;
        this.isPrivate = Modifier.isPrivate(ctField.getModifiers());
    }

    static String isField(ClassPool classPool, ConstPool constPool, CtClass ctClass, String string, boolean bl2, int n2) {
        if (!constPool.getFieldrefName(n2).equals(string)) {
            return null;
        }
        try {
            CtClass ctClass2 = classPool.get(constPool.getFieldrefClassName(n2));
            if (ctClass2 == ctClass || !bl2 && TransformReadField.isFieldInSuper(ctClass2, ctClass, string)) {
                return constPool.getFieldrefType(n2);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    static boolean isFieldInSuper(CtClass ctClass, CtClass ctClass2, String string) {
        if (!ctClass.subclassOf(ctClass2)) {
            return false;
        }
        try {
            CtField ctField = ctClass.getField(string);
            return ctField.getDeclaringClass() == ctClass2;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public int transform(CtClass ctClass, int n2, CodeIterator codeIterator, ConstPool constPool) throws BadBytecode {
        int n3 = codeIterator.byteAt(n2);
        if (n3 == 180 || n3 == 178) {
            int n4 = codeIterator.u16bitAt(n2 + 1);
            String string = TransformReadField.isField(ctClass.getClassPool(), constPool, this.fieldClass, this.fieldname, this.isPrivate, n4);
            if (string != null) {
                if (n3 == 178) {
                    codeIterator.move(n2);
                    codeIterator.insertGap(1);
                    codeIterator.writeByte(1, n2);
                    n2 = codeIterator.next();
                }
                String string2 = "(Ljava/lang/Object;)" + string;
                int n5 = constPool.addClassInfo(this.methodClassname);
                int n6 = constPool.addMethodrefInfo(n5, this.methodName, string2);
                codeIterator.writeByte(184, n2);
                codeIterator.write16bit(n6, n2 + 1);
                return n2;
            }
        }
        return n2;
    }
}

