/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public final class TransformNew
extends Transformer {
    private int nested;
    private String classname;
    private String trapClass;
    private String trapMethod;

    public TransformNew(Transformer transformer, String string, String string2, String string3) {
        super(transformer);
        this.classname = string;
        this.trapClass = string2;
        this.trapMethod = string3;
    }

    public void initialize(ConstPool constPool, CodeAttribute codeAttribute) {
        this.nested = 0;
    }

    public int transform(CtClass ctClass, int n2, CodeIterator codeIterator, ConstPool constPool) throws CannotCompileException {
        int n3;
        int n4;
        int n5 = codeIterator.byteAt(n2);
        if (n5 == 187) {
            int n6 = codeIterator.u16bitAt(n2 + 1);
            if (constPool.getClassInfo(n6).equals(this.classname)) {
                if (codeIterator.byteAt(n2 + 3) != 89) {
                    throw new CannotCompileException("NEW followed by no DUP was found");
                }
                codeIterator.writeByte(0, n2);
                codeIterator.writeByte(0, n2 + 1);
                codeIterator.writeByte(0, n2 + 2);
                codeIterator.writeByte(0, n2 + 3);
                ++this.nested;
                StackMapTable stackMapTable = (StackMapTable)codeIterator.get().getAttribute("StackMapTable");
                if (stackMapTable != null) {
                    stackMapTable.removeNew(n2);
                }
            }
        } else if (n5 == 183 && (n4 = constPool.isConstructor(this.classname, n3 = codeIterator.u16bitAt(n2 + 1))) != 0 && this.nested > 0) {
            int n7 = this.computeMethodref(n4, constPool);
            codeIterator.writeByte(184, n2);
            codeIterator.write16bit(n7, n2 + 1);
            --this.nested;
        }
        return n2;
    }

    private int computeMethodref(int n2, ConstPool constPool) {
        int n3 = constPool.addClassInfo(this.trapClass);
        int n4 = constPool.addUtf8Info(this.trapMethod);
        n2 = constPool.addUtf8Info(Descriptor.changeReturnType(this.classname, constPool.getUtf8Info(n2)));
        return constPool.addMethodrefInfo(n3, constPool.addNameAndTypeInfo(n4, n2));
    }
}

