/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CodeConverter$ArrayAccessReplacementMethodNames;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Analyzer;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Frame;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public final class TransformAccessArrayField
extends Transformer {
    private final String methodClassname;
    private final CodeConverter$ArrayAccessReplacementMethodNames names;
    private Frame[] frames;
    private int offset;

    public TransformAccessArrayField(Transformer transformer, String string, CodeConverter$ArrayAccessReplacementMethodNames codeConverter$ArrayAccessReplacementMethodNames) throws NotFoundException {
        super(transformer);
        this.methodClassname = string;
        this.names = codeConverter$ArrayAccessReplacementMethodNames;
    }

    public void initialize(ConstPool constPool, CtClass ctClass, MethodInfo methodInfo) throws CannotCompileException {
        CodeIterator codeIterator = methodInfo.getCodeAttribute().iterator();
        while (codeIterator.hasNext()) {
            try {
                int n2 = codeIterator.next();
                int n3 = codeIterator.byteAt(n2);
                if (n3 == 50) {
                    this.initFrames(ctClass, methodInfo);
                }
                if (n3 == 50 || n3 == 51 || n3 == 52 || n3 == 49 || n3 == 48 || n3 == 46 || n3 == 47 || n3 == 53) {
                    n2 = this.replace(constPool, codeIterator, n2, n3, this.getLoadReplacementSignature(n3));
                    continue;
                }
                if (n3 != 83 && n3 != 84 && n3 != 85 && n3 != 82 && n3 != 81 && n3 != 79 && n3 != 80 && n3 != 86) continue;
                n2 = this.replace(constPool, codeIterator, n2, n3, this.getStoreReplacementSignature(n3));
            }
            catch (Exception exception) {
                throw new CannotCompileException(exception);
            }
        }
    }

    public void clean() {
        this.frames = null;
        this.offset = -1;
    }

    public int transform(CtClass ctClass, int n2, CodeIterator codeIterator, ConstPool constPool) throws BadBytecode {
        return n2;
    }

    private Frame getFrame(int n2) throws BadBytecode {
        return this.frames[n2 - this.offset];
    }

    private void initFrames(CtClass ctClass, MethodInfo methodInfo) throws BadBytecode {
        if (this.frames == null) {
            this.frames = new Analyzer().analyze(ctClass, methodInfo);
            this.offset = 0;
        }
    }

    private int updatePos(int n2, int n3) {
        if (this.offset > -1) {
            this.offset += n3;
        }
        return n2 + n3;
    }

    private String getTopType(int n2) throws BadBytecode {
        Frame frame = this.getFrame(n2);
        if (frame == null) {
            return null;
        }
        CtClass ctClass = frame.peek().getCtClass();
        return ctClass != null ? Descriptor.toJvmName(ctClass) : null;
    }

    private int replace(ConstPool constPool, CodeIterator codeIterator, int n2, int n3, String string) throws BadBytecode {
        String string2 = null;
        String string3 = this.getMethodName(n3);
        if (string3 != null) {
            if (n3 == 50) {
                string2 = this.getTopType(codeIterator.lookAhead());
                if (string2 == null) {
                    return n2;
                }
                if ("java/lang/Object".equals(string2)) {
                    string2 = null;
                }
            }
            int n4 = codeIterator.insertGap(n2, string2 != null ? 5 : 2);
            int n5 = constPool.addClassInfo(this.methodClassname);
            int n6 = constPool.addMethodrefInfo(n5, string3, string);
            codeIterator.writeByte(184, n2);
            codeIterator.write16bit(n6, n2 + 1);
            if (string2 != null) {
                int n7 = constPool.addClassInfo(string2);
                codeIterator.writeByte(192, n2 + 3);
                codeIterator.write16bit(n7, n2 + 4);
            }
            n2 = this.updatePos(n2, n4);
        }
        return n2;
    }

    private String getMethodName(int n2) {
        String string = null;
        switch (n2) {
            case 50: {
                string = this.names.objectRead();
                break;
            }
            case 51: {
                string = this.names.byteOrBooleanRead();
                break;
            }
            case 52: {
                string = this.names.charRead();
                break;
            }
            case 49: {
                string = this.names.doubleRead();
                break;
            }
            case 48: {
                string = this.names.floatRead();
                break;
            }
            case 46: {
                string = this.names.intRead();
                break;
            }
            case 53: {
                string = this.names.shortRead();
                break;
            }
            case 47: {
                string = this.names.longRead();
                break;
            }
            case 83: {
                string = this.names.objectWrite();
                break;
            }
            case 84: {
                string = this.names.byteOrBooleanWrite();
                break;
            }
            case 85: {
                string = this.names.charWrite();
                break;
            }
            case 82: {
                string = this.names.doubleWrite();
                break;
            }
            case 81: {
                string = this.names.floatWrite();
                break;
            }
            case 79: {
                string = this.names.intWrite();
                break;
            }
            case 86: {
                string = this.names.shortWrite();
                break;
            }
            case 80: {
                string = this.names.longWrite();
            }
        }
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    private String getLoadReplacementSignature(int n2) throws BadBytecode {
        switch (n2) {
            case 50: {
                return "(Ljava/lang/Object;I)Ljava/lang/Object;";
            }
            case 51: {
                return "(Ljava/lang/Object;I)B";
            }
            case 52: {
                return "(Ljava/lang/Object;I)C";
            }
            case 49: {
                return "(Ljava/lang/Object;I)D";
            }
            case 48: {
                return "(Ljava/lang/Object;I)F";
            }
            case 46: {
                return "(Ljava/lang/Object;I)I";
            }
            case 53: {
                return "(Ljava/lang/Object;I)S";
            }
            case 47: {
                return "(Ljava/lang/Object;I)J";
            }
        }
        throw new BadBytecode(n2);
    }

    private String getStoreReplacementSignature(int n2) throws BadBytecode {
        switch (n2) {
            case 83: {
                return "(Ljava/lang/Object;ILjava/lang/Object;)V";
            }
            case 84: {
                return "(Ljava/lang/Object;IB)V";
            }
            case 85: {
                return "(Ljava/lang/Object;IC)V";
            }
            case 82: {
                return "(Ljava/lang/Object;ID)V";
            }
            case 81: {
                return "(Ljava/lang/Object;IF)V";
            }
            case 79: {
                return "(Ljava/lang/Object;II)V";
            }
            case 86: {
                return "(Ljava/lang/Object;IS)V";
            }
            case 80: {
                return "(Ljava/lang/Object;IJ)V";
            }
        }
        throw new BadBytecode(n2);
    }
}

