/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler.ast;

import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.IntConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Visitor;

public class DoubleConst
extends ASTree {
    protected double value;
    protected int type;

    public DoubleConst(double d2, int n2) {
        this.value = d2;
        this.type = n2;
    }

    public double get() {
        return this.value;
    }

    public void set(double d2) {
        this.value = d2;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public void accept(Visitor visitor) throws CompileError {
        visitor.atDoubleConst(this);
    }

    public ASTree compute(int n2, ASTree aSTree) {
        if (aSTree instanceof IntConst) {
            return this.compute0(n2, (IntConst)aSTree);
        }
        if (aSTree instanceof DoubleConst) {
            return this.compute0(n2, (DoubleConst)aSTree);
        }
        return null;
    }

    private DoubleConst compute0(int n2, DoubleConst doubleConst) {
        int n3 = this.type == 405 || doubleConst.type == 405 ? 405 : 404;
        return DoubleConst.compute(n2, this.value, doubleConst.value, n3);
    }

    private DoubleConst compute0(int n2, IntConst intConst) {
        return DoubleConst.compute(n2, this.value, intConst.value, this.type);
    }

    private static DoubleConst compute(int n2, double d2, double d3, int n3) {
        double d4;
        switch (n2) {
            case 43: {
                d4 = d2 + d3;
                break;
            }
            case 45: {
                d4 = d2 - d3;
                break;
            }
            case 42: {
                d4 = d2 * d3;
                break;
            }
            case 47: {
                d4 = d2 / d3;
                break;
            }
            case 37: {
                d4 = d2 % d3;
                break;
            }
            default: {
                return null;
            }
        }
        return new DoubleConst(d4, n3);
    }
}

