/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver$Method;
import org.zeroturnaround.bundled.javassist.compiler.NoFieldException;
import org.zeroturnaround.bundled.javassist.compiler.TokenId;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.ArrayInit;
import org.zeroturnaround.bundled.javassist.compiler.ast.AssignExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.BinExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CastExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CondExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.DoubleConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.InstanceOfExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.IntConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Keyword;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.NewExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.StringL;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;
import org.zeroturnaround.bundled.javassist.compiler.ast.Variable;
import org.zeroturnaround.bundled.javassist.compiler.ast.Visitor;

public class TypeChecker
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String jvmJavaLangString = "java/lang/String";
    static final String jvmJavaLangClass = "java/lang/Class";
    protected int exprType;
    protected int arrayDim;
    protected String className;
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;

    public TypeChecker(CtClass ctClass, ClassPool classPool) {
        this.resolver = new MemberResolver(classPool);
        this.thisClass = ctClass;
        this.thisMethod = null;
    }

    protected static String argTypesToString(int[] nArray, int[] nArray2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n2 = nArray.length;
        if (n2 > 0) {
            int n3 = 0;
            while (true) {
                TypeChecker.typeToString(stringBuffer, nArray[n3], nArray2[n3], stringArray[n3]);
                if (++n3 >= n2) break;
                stringBuffer.append(',');
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static StringBuffer typeToString(StringBuffer stringBuffer, int n2, int n3, String string) {
        String string2;
        if (n2 == 307) {
            string2 = MemberResolver.jvmToJavaName(string);
        } else if (n2 == 412) {
            string2 = "Object";
        } else {
            try {
                string2 = MemberResolver.getTypeName(n2);
            }
            catch (CompileError compileError) {
                string2 = "?";
            }
        }
        stringBuffer.append(string2);
        while (n3-- > 0) {
            stringBuffer.append("[]");
        }
        return stringBuffer;
    }

    public void setThisMethod(MethodInfo methodInfo) {
        this.thisMethod = methodInfo;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    protected String resolveClassName(ASTList aSTList) throws CompileError {
        return this.resolver.resolveClassName(aSTList);
    }

    protected String resolveClassName(String string) throws CompileError {
        return this.resolver.resolveJvmClassName(string);
    }

    public void atNewExpr(NewExpr newExpr) throws CompileError {
        if (newExpr.isArray()) {
            this.atNewArrayExpr(newExpr);
        } else {
            CtClass ctClass = this.resolver.lookupClassByName(newExpr.getClassName());
            String string = ctClass.getName();
            ASTList aSTList = newExpr.getArguments();
            this.atMethodCallCore(ctClass, "<init>", aSTList);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = MemberResolver.javaToJvmName(string);
        }
    }

    public void atNewArrayExpr(NewExpr newExpr) throws CompileError {
        int n2 = newExpr.getArrayType();
        ASTList aSTList = newExpr.getArraySize();
        ASTList aSTList2 = newExpr.getClassName();
        ArrayInit arrayInit = newExpr.getInitializer();
        if (arrayInit != null) {
            ((ASTree)arrayInit).accept(this);
        }
        if (aSTList.length() > 1) {
            this.atMultiNewArray(n2, aSTList2, aSTList);
        } else {
            ASTree aSTree = aSTList.head();
            if (aSTree != null) {
                aSTree.accept(this);
            }
            this.exprType = n2;
            this.arrayDim = 1;
            this.className = n2 == 307 ? this.resolveClassName(aSTList2) : null;
        }
    }

    public void atArrayInit(ArrayInit arrayInit) throws CompileError {
        for (ASTList aSTList = arrayInit; aSTList != null; aSTList = aSTList.tail()) {
            ASTree aSTree = aSTList.head();
            if (aSTree == null) continue;
            aSTree.accept(this);
        }
    }

    protected void atMultiNewArray(int n2, ASTList aSTList, ASTList aSTList2) throws CompileError {
        ASTree aSTree;
        int n3 = aSTList2.length();
        int n4 = 0;
        while (aSTList2 != null && (aSTree = aSTList2.head()) != null) {
            ++n4;
            aSTree.accept(this);
            aSTList2 = aSTList2.tail();
        }
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = n2 == 307 ? this.resolveClassName(aSTList) : null;
    }

    public void atAssignExpr(AssignExpr assignExpr) throws CompileError {
        int n2 = assignExpr.getOperator();
        ASTree aSTree = assignExpr.oprand1();
        ASTree aSTree2 = assignExpr.oprand2();
        if (aSTree instanceof Variable) {
            this.atVariableAssign(assignExpr, n2, (Variable)aSTree, ((Variable)aSTree).getDeclarator(), aSTree2);
        } else {
            Expr expr;
            if (aSTree instanceof Expr && (expr = (Expr)aSTree).getOperator() == 65) {
                this.atArrayAssign(assignExpr, n2, (Expr)aSTree, aSTree2);
                return;
            }
            this.atFieldAssign(assignExpr, n2, aSTree, aSTree2);
        }
    }

    private void atVariableAssign(Expr expr, int n2, Variable variable, Declarator declarator, ASTree aSTree) throws CompileError {
        int n3 = declarator.getType();
        int n4 = declarator.getArrayDim();
        String string = declarator.getClassName();
        if (n2 != 61) {
            this.atVariable(variable);
        }
        aSTree.accept(this);
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    private void atArrayAssign(Expr expr, int n2, Expr expr2, ASTree aSTree) throws CompileError {
        this.atArrayRead(expr2.oprand1(), expr2.oprand2());
        int n3 = this.exprType;
        int n4 = this.arrayDim;
        String string = this.className;
        aSTree.accept(this);
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    protected void atFieldAssign(Expr expr, int n2, ASTree aSTree, ASTree aSTree2) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree);
        this.atFieldRead(ctField);
        int n3 = this.exprType;
        int n4 = this.arrayDim;
        String string = this.className;
        aSTree2.accept(this);
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    public void atCondExpr(CondExpr condExpr) throws CompileError {
        this.booleanExpr(condExpr.condExpr());
        condExpr.thenExpr().accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        condExpr.elseExpr().accept(this);
        if (n3 == 0 && n3 == this.arrayDim) {
            if (CodeGen.rightIsStrong(n2, this.exprType)) {
                condExpr.setThen(new CastExpr(this.exprType, 0, condExpr.thenExpr()));
            } else if (CodeGen.rightIsStrong(this.exprType, n2)) {
                condExpr.setElse(new CastExpr(n2, 0, condExpr.elseExpr()));
                this.exprType = n2;
            }
        }
    }

    public void atBinExpr(BinExpr binExpr) throws CompileError {
        int n2 = binExpr.getOperator();
        int n3 = CodeGen.lookupBinOp(n2);
        if (n3 >= 0) {
            if (n2 == 43) {
                Expr expr = this.atPlusExpr(binExpr);
                if (expr != null) {
                    expr = CallExpr.makeCall(Expr.make(46, (ASTree)expr, (ASTree)new Member("toString")), null);
                    binExpr.setOprand1(expr);
                    binExpr.setOprand2(null);
                    this.className = jvmJavaLangString;
                }
            } else {
                ASTree aSTree = binExpr.oprand1();
                ASTree aSTree2 = binExpr.oprand2();
                aSTree.accept(this);
                int n4 = this.exprType;
                aSTree2.accept(this);
                if (!this.isConstant(binExpr, n2, aSTree, aSTree2)) {
                    this.computeBinExprType(binExpr, n2, n4);
                }
            }
        } else {
            this.booleanExpr(binExpr);
        }
    }

    private Expr atPlusExpr(BinExpr binExpr) throws CompileError {
        ASTree aSTree = binExpr.oprand1();
        ASTree aSTree2 = binExpr.oprand2();
        if (aSTree2 == null) {
            aSTree.accept(this);
            return null;
        }
        if (TypeChecker.isPlusExpr(aSTree)) {
            Expr expr = this.atPlusExpr((BinExpr)aSTree);
            if (expr != null) {
                aSTree2.accept(this);
                this.exprType = 307;
                this.arrayDim = 0;
                this.className = "java/lang/StringBuffer";
                return TypeChecker.makeAppendCall(expr, aSTree2);
            }
        } else {
            aSTree.accept(this);
        }
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        aSTree2.accept(this);
        if (this.isConstant(binExpr, 43, aSTree, aSTree2)) {
            return null;
        }
        if (n2 == 307 && n3 == 0 && jvmJavaLangString.equals(string) || this.exprType == 307 && this.arrayDim == 0 && jvmJavaLangString.equals(this.className)) {
            ASTList aSTList = ASTList.make(new Symbol("java"), new Symbol("lang"), new Symbol("StringBuffer"));
            NewExpr newExpr = new NewExpr(aSTList, null);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/StringBuffer";
            return TypeChecker.makeAppendCall(TypeChecker.makeAppendCall(newExpr, aSTree), aSTree2);
        }
        this.computeBinExprType(binExpr, 43, n2);
        return null;
    }

    private boolean isConstant(BinExpr binExpr, int n2, ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree = TypeChecker.stripPlusExpr(aSTree);
        aSTree2 = TypeChecker.stripPlusExpr(aSTree2);
        ASTree aSTree3 = null;
        if (aSTree instanceof StringL && aSTree2 instanceof StringL && n2 == 43) {
            aSTree3 = new StringL(((StringL)aSTree).get() + ((StringL)aSTree2).get());
        } else if (aSTree instanceof IntConst) {
            aSTree3 = ((IntConst)aSTree).compute(n2, aSTree2);
        } else if (aSTree instanceof DoubleConst) {
            aSTree3 = ((DoubleConst)aSTree).compute(n2, aSTree2);
        }
        if (aSTree3 == null) {
            return false;
        }
        binExpr.setOperator(43);
        binExpr.setOprand1(aSTree3);
        binExpr.setOprand2(null);
        aSTree3.accept(this);
        return true;
    }

    static ASTree stripPlusExpr(ASTree aSTree) {
        ASTree aSTree2;
        if (aSTree instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)aSTree;
            if (binExpr.getOperator() == 43 && binExpr.oprand2() == null) {
                return binExpr.getLeft();
            }
        } else if (aSTree instanceof Expr) {
            Expr expr = (Expr)aSTree;
            int n2 = expr.getOperator();
            if (n2 == 35) {
                ASTree aSTree3 = TypeChecker.getConstantFieldValue((Member)expr.oprand2());
                if (aSTree3 != null) {
                    return aSTree3;
                }
            } else if (n2 == 43 && expr.getRight() == null) {
                return expr.getLeft();
            }
        } else if (aSTree instanceof Member && (aSTree2 = TypeChecker.getConstantFieldValue((Member)aSTree)) != null) {
            return aSTree2;
        }
        return aSTree;
    }

    private static ASTree getConstantFieldValue(Member member) {
        return TypeChecker.getConstantFieldValue(member.getField());
    }

    public static ASTree getConstantFieldValue(CtField ctField) {
        if (ctField == null) {
            return null;
        }
        Object object = ctField.getConstantValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringL((String)object);
        }
        if (object instanceof Double || object instanceof Float) {
            int n2 = object instanceof Double ? 405 : 404;
            return new DoubleConst(((Number)object).doubleValue(), n2);
        }
        if (object instanceof Number) {
            int n3 = object instanceof Long ? 403 : 402;
            return new IntConst(((Number)object).longValue(), n3);
        }
        if (object instanceof Boolean) {
            return new Keyword((Boolean)object != false ? 410 : 411);
        }
        return null;
    }

    private static boolean isPlusExpr(ASTree aSTree) {
        if (aSTree instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)aSTree;
            int n2 = binExpr.getOperator();
            return n2 == 43;
        }
        return false;
    }

    private static Expr makeAppendCall(ASTree aSTree, ASTree aSTree2) {
        return CallExpr.makeCall(Expr.make(46, aSTree, (ASTree)new Member("append")), new ASTList(aSTree2));
    }

    private void computeBinExprType(BinExpr binExpr, int n2, int n3) throws CompileError {
        int n4 = this.exprType;
        if (n2 == 364 || n2 == 366 || n2 == 370) {
            this.exprType = n3;
        } else {
            this.insertCast(binExpr, n3, n4);
        }
        if (CodeGen.isP_INT(this.exprType)) {
            this.exprType = 324;
        }
    }

    private void booleanExpr(ASTree aSTree) throws CompileError {
        int n2 = CodeGen.getCompOperator(aSTree);
        if (n2 == 358) {
            BinExpr binExpr = (BinExpr)aSTree;
            binExpr.oprand1().accept(this);
            int n3 = this.exprType;
            int n4 = this.arrayDim;
            binExpr.oprand2().accept(this);
            if (n4 == 0 && this.arrayDim == 0) {
                this.insertCast(binExpr, n3, this.exprType);
            }
        } else if (n2 == 33) {
            ((Expr)aSTree).oprand1().accept(this);
        } else if (n2 == 369 || n2 == 368) {
            BinExpr binExpr = (BinExpr)aSTree;
            binExpr.oprand1().accept(this);
            binExpr.oprand2().accept(this);
        } else {
            aSTree.accept(this);
        }
        this.exprType = 301;
        this.arrayDim = 0;
    }

    private void insertCast(BinExpr binExpr, int n2, int n3) throws CompileError {
        if (CodeGen.rightIsStrong(n2, n3)) {
            binExpr.setLeft(new CastExpr(n3, 0, binExpr.oprand1()));
        } else {
            this.exprType = n2;
        }
    }

    public void atCastExpr(CastExpr castExpr) throws CompileError {
        String string = this.resolveClassName(castExpr.getClassName());
        castExpr.getOprand().accept(this);
        this.exprType = castExpr.getType();
        this.arrayDim = castExpr.getArrayDim();
        this.className = string;
    }

    public void atInstanceOfExpr(InstanceOfExpr instanceOfExpr) throws CompileError {
        instanceOfExpr.getOprand().accept(this);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    public void atExpr(Expr expr) throws CompileError {
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        if (n2 == 46) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("length")) {
                this.atArrayLength(expr);
            } else if (string.equals("class")) {
                this.atClassObject(expr);
            } else {
                this.atFieldRead(expr);
            }
        } else if (n2 == 35) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
            } else {
                this.atFieldRead(expr);
            }
        } else if (n2 == 65) {
            this.atArrayRead(aSTree, expr.oprand2());
        } else if (n2 == 362 || n2 == 363) {
            this.atPlusPlus(n2, aSTree, expr);
        } else if (n2 == 33) {
            this.booleanExpr(expr);
        } else if (n2 == 67) {
            TypeChecker.fatal();
        } else {
            aSTree.accept(this);
            if (!this.isConstant(expr, n2, aSTree) && (n2 == 45 || n2 == 126) && CodeGen.isP_INT(this.exprType)) {
                this.exprType = 324;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConstant(Expr expr, int n2, ASTree aSTree) {
        if ((aSTree = TypeChecker.stripPlusExpr(aSTree)) instanceof IntConst) {
            IntConst intConst = (IntConst)aSTree;
            long l2 = intConst.get();
            if (n2 == 45) {
                l2 = -l2;
            } else {
                if (n2 != 126) return false;
                l2 ^= 0xFFFFFFFFFFFFFFFFL;
            }
            intConst.set(l2);
        } else {
            if (!(aSTree instanceof DoubleConst)) return false;
            DoubleConst doubleConst = (DoubleConst)aSTree;
            if (n2 != 45) return false;
            doubleConst.set(-doubleConst.get());
        }
        expr.setOperator(43);
        return true;
    }

    public void atCallExpr(CallExpr callExpr) throws CompileError {
        Object object;
        String string = null;
        CtClass ctClass = null;
        ASTree aSTree = callExpr.oprand1();
        ASTList aSTList = (ASTList)callExpr.oprand2();
        if (aSTree instanceof Member) {
            string = ((Member)aSTree).get();
            ctClass = this.thisClass;
        } else if (aSTree instanceof Keyword) {
            string = "<init>";
            ctClass = ((Keyword)aSTree).get() == 336 ? MemberResolver.getSuperclass(this.thisClass) : this.thisClass;
        } else if (aSTree instanceof Expr) {
            object = (Expr)aSTree;
            string = ((Symbol)((Expr)object).oprand2()).get();
            int n2 = ((Expr)object).getOperator();
            if (n2 == 35) {
                ctClass = this.resolver.lookupClass(((Symbol)((Expr)object).oprand1()).get(), false);
            } else if (n2 == 46) {
                ASTree aSTree2 = ((Expr)object).oprand1();
                try {
                    aSTree2.accept(this);
                }
                catch (NoFieldException noFieldException) {
                    if (noFieldException.getExpr() != aSTree2) {
                        throw noFieldException;
                    }
                    this.exprType = 307;
                    this.arrayDim = 0;
                    this.className = noFieldException.getField();
                    ((Expr)object).setOperator(35);
                    ((Expr)object).setOprand1(new Symbol(MemberResolver.jvmToJavaName(this.className)));
                }
                if (this.arrayDim > 0) {
                    ctClass = this.resolver.lookupClass(javaLangObject, true);
                } else if (this.exprType == 307) {
                    ctClass = this.resolver.lookupClassByJvmName(this.className);
                } else {
                    TypeChecker.badMethod();
                }
            } else {
                TypeChecker.badMethod();
            }
        } else {
            TypeChecker.fatal();
        }
        object = this.atMethodCallCore(ctClass, string, aSTList);
        callExpr.setMethod((MemberResolver$Method)object);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    public MemberResolver$Method atMethodCallCore(CtClass ctClass, String string, ASTList aSTList) throws CompileError {
        int n2 = this.getMethodArgsLength(aSTList);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        this.atMethodArgs(aSTList, nArray, nArray2, stringArray);
        MemberResolver$Method memberResolver$Method = this.resolver.lookupMethod(ctClass, this.thisClass, this.thisMethod, string, nArray, nArray2, stringArray);
        if (memberResolver$Method == null) {
            String string2 = ctClass.getName();
            String string3 = TypeChecker.argTypesToString(nArray, nArray2, stringArray);
            String string4 = string.equals("<init>") ? "cannot find constructor " + string2 + string3 : string + string3 + " not found in " + string2;
            throw new CompileError(string4);
        }
        String string5 = memberResolver$Method.info.getDescriptor();
        this.setReturnType(string5);
        return memberResolver$Method;
    }

    public int getMethodArgsLength(ASTList aSTList) {
        return ASTList.length(aSTList);
    }

    public void atMethodArgs(ASTList aSTList, int[] nArray, int[] nArray2, String[] stringArray) throws CompileError {
        int n2 = 0;
        while (aSTList != null) {
            ASTree aSTree = aSTList.head();
            aSTree.accept(this);
            nArray[n2] = this.exprType;
            nArray2[n2] = this.arrayDim;
            stringArray[n2] = this.className;
            ++n2;
            aSTList = aSTList.tail();
        }
    }

    void setReturnType(String string) throws CompileError {
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            TypeChecker.badMethod();
        }
        char c2 = string.charAt(++n2);
        int n3 = 0;
        while (c2 == '[') {
            ++n3;
            c2 = string.charAt(++n2);
        }
        this.arrayDim = n3;
        if (c2 == 'L') {
            int n4 = string.indexOf(59, n2 + 1);
            if (n4 < 0) {
                TypeChecker.badMethod();
            }
            this.exprType = 307;
            this.className = string.substring(n2 + 1, n4);
        } else {
            this.exprType = MemberResolver.descToType(c2);
            this.className = null;
        }
    }

    private void atFieldRead(ASTree aSTree) throws CompileError {
        this.atFieldRead(this.fieldAccess(aSTree));
    }

    private void atFieldRead(CtField ctField) throws CompileError {
        FieldInfo fieldInfo = ctField.getFieldInfo2();
        String string = fieldInfo.getDescriptor();
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(n2);
        while (c2 == '[') {
            ++n3;
            c2 = string.charAt(++n2);
        }
        this.arrayDim = n3;
        this.exprType = MemberResolver.descToType(c2);
        this.className = c2 == 'L' ? string.substring(n2 + 1, string.indexOf(59, n2 + 1)) : null;
    }

    protected CtField fieldAccess(ASTree aSTree) throws CompileError {
        if (aSTree instanceof Member) {
            Member member = (Member)aSTree;
            String string = member.get();
            try {
                CtField ctField = this.thisClass.getField(string);
                if (Modifier.isStatic(ctField.getModifiers())) {
                    member.setField(ctField);
                }
                return ctField;
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(string, aSTree);
            }
        }
        if (aSTree instanceof Expr) {
            Expr expr = (Expr)aSTree;
            int n2 = expr.getOperator();
            if (n2 == 35) {
                Member member = (Member)expr.oprand2();
                CtField ctField = this.resolver.lookupField(((Symbol)expr.oprand1()).get(), member);
                member.setField(ctField);
                return ctField;
            }
            if (n2 == 46) {
                try {
                    expr.oprand1().accept(this);
                }
                catch (NoFieldException noFieldException) {
                    if (noFieldException.getExpr() != expr.oprand1()) {
                        throw noFieldException;
                    }
                    return this.fieldAccess2(expr, noFieldException.getField());
                }
                CompileError compileError = null;
                try {
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        return this.resolver.lookupFieldByJvmName(this.className, (Symbol)expr.oprand2());
                    }
                }
                catch (CompileError compileError2) {
                    compileError = compileError2;
                }
                ASTree aSTree2 = expr.oprand1();
                if (aSTree2 instanceof Symbol) {
                    return this.fieldAccess2(expr, ((Symbol)aSTree2).get());
                }
                if (compileError != null) {
                    throw compileError;
                }
            }
        }
        throw new CompileError("bad filed access");
    }

    private CtField fieldAccess2(Expr expr, String string) throws CompileError {
        Member member = (Member)expr.oprand2();
        CtField ctField = this.resolver.lookupFieldByJvmName2(string, member, expr);
        expr.setOperator(35);
        expr.setOprand1(new Symbol(MemberResolver.jvmToJavaName(string)));
        member.setField(ctField);
        return ctField;
    }

    public void atClassObject(Expr expr) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangClass;
    }

    public void atArrayLength(Expr expr) throws CompileError {
        expr.oprand1().accept(this);
        this.exprType = 324;
        this.arrayDim = 0;
    }

    public void atArrayRead(ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree.accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        aSTree2.accept(this);
        this.exprType = n2;
        this.arrayDim = n3 - 1;
        this.className = string;
    }

    private void atPlusPlus(int n2, ASTree aSTree, Expr expr) throws CompileError {
        boolean bl2;
        boolean bl3 = bl2 = aSTree == null;
        if (bl2) {
            aSTree = expr.oprand2();
        }
        if (aSTree instanceof Variable) {
            Declarator declarator = ((Variable)aSTree).getDeclarator();
            this.exprType = declarator.getType();
            this.arrayDim = declarator.getArrayDim();
        } else {
            Expr expr2;
            if (aSTree instanceof Expr && (expr2 = (Expr)aSTree).getOperator() == 65) {
                this.atArrayRead(expr2.oprand1(), expr2.oprand2());
                int n3 = this.exprType;
                if (n3 == 324 || n3 == 303 || n3 == 306 || n3 == 334) {
                    this.exprType = 324;
                }
                return;
            }
            this.atFieldPlusPlus(aSTree);
        }
    }

    protected void atFieldPlusPlus(ASTree aSTree) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree);
        this.atFieldRead(ctField);
        int n2 = this.exprType;
        if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
            this.exprType = 324;
        }
    }

    public void atMember(Member member) throws CompileError {
        this.atFieldRead(member);
    }

    public void atVariable(Variable variable) throws CompileError {
        Declarator declarator = variable.getDeclarator();
        this.exprType = declarator.getType();
        this.arrayDim = declarator.getArrayDim();
        this.className = declarator.getClassName();
    }

    public void atKeyword(Keyword keyword) throws CompileError {
        this.arrayDim = 0;
        int n2 = keyword.get();
        switch (n2) {
            case 410: 
            case 411: {
                this.exprType = 301;
                break;
            }
            case 412: {
                this.exprType = 412;
                break;
            }
            case 336: 
            case 339: {
                this.exprType = 307;
                if (n2 == 339) {
                    this.className = this.getThisName();
                    break;
                }
                this.className = this.getSuperName();
                break;
            }
            default: {
                TypeChecker.fatal();
            }
        }
    }

    public void atStringL(StringL stringL) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    public void atIntConst(IntConst intConst) throws CompileError {
        this.arrayDim = 0;
        int n2 = intConst.getType();
        this.exprType = n2 == 402 || n2 == 401 ? (n2 == 402 ? 324 : 306) : 326;
    }

    public void atDoubleConst(DoubleConst doubleConst) throws CompileError {
        this.arrayDim = 0;
        this.exprType = doubleConst.getType() == 405 ? 312 : 317;
    }
}

