/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen$1;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen$ReturnHook;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.TokenId;
import org.zeroturnaround.bundled.javassist.compiler.TypeChecker;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.ArrayInit;
import org.zeroturnaround.bundled.javassist.compiler.ast.AssignExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.BinExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CastExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CondExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.DoubleConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.FieldDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.InstanceOfExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.IntConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Keyword;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.MethodDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.NewExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Pair;
import org.zeroturnaround.bundled.javassist.compiler.ast.Stmnt;
import org.zeroturnaround.bundled.javassist.compiler.ast.StringL;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;
import org.zeroturnaround.bundled.javassist.compiler.ast.Variable;
import org.zeroturnaround.bundled.javassist.compiler.ast.Visitor;

public abstract class CodeGen
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String javaLangString = "java.lang.String";
    static final String jvmJavaLangString = "java/lang/String";
    protected Bytecode bytecode;
    private int tempVar;
    TypeChecker typeChecker;
    protected boolean hasReturned;
    public boolean inStaticMethod;
    protected ArrayList breakList;
    protected ArrayList continueList;
    protected CodeGen$ReturnHook returnHooks;
    protected int exprType;
    protected int arrayDim;
    protected String className;
    static final int[] binOp = new int[]{43, 99, 98, 97, 96, 45, 103, 102, 101, 100, 42, 107, 106, 105, 104, 47, 111, 110, 109, 108, 37, 115, 114, 113, 112, 124, 0, 0, 129, 128, 94, 0, 0, 131, 130, 38, 0, 0, 127, 126, 364, 0, 0, 121, 120, 366, 0, 0, 123, 122, 370, 0, 0, 125, 124};
    private static final int[] ifOp = new int[]{358, 159, 160, 350, 160, 159, 357, 164, 163, 359, 162, 161, 60, 161, 162, 62, 163, 164};
    private static final int[] ifOp2 = new int[]{358, 153, 154, 350, 154, 153, 357, 158, 157, 359, 156, 155, 60, 155, 156, 62, 157, 158};
    private static final int P_DOUBLE = 0;
    private static final int P_FLOAT = 1;
    private static final int P_LONG = 2;
    private static final int P_INT = 3;
    private static final int P_OTHER = -1;
    private static final int[] castOp = new int[]{0, 144, 143, 142, 141, 0, 140, 139, 138, 137, 0, 136, 135, 134, 133, 0};

    public CodeGen(Bytecode bytecode) {
        this.bytecode = bytecode;
        this.tempVar = -1;
        this.typeChecker = null;
        this.hasReturned = false;
        this.inStaticMethod = false;
        this.breakList = null;
        this.continueList = null;
        this.returnHooks = null;
    }

    public void setTypeChecker(TypeChecker typeChecker) {
        this.typeChecker = typeChecker;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    public static boolean is2word(int n2, int n3) {
        return n3 == 0 && (n2 == 312 || n2 == 326);
    }

    public int getMaxLocals() {
        return this.bytecode.getMaxLocals();
    }

    public void setMaxLocals(int n2) {
        this.bytecode.setMaxLocals(n2);
    }

    protected void incMaxLocals(int n2) {
        this.bytecode.incMaxLocals(n2);
    }

    protected int getTempVar() {
        if (this.tempVar < 0) {
            this.tempVar = this.getMaxLocals();
            this.incMaxLocals(2);
        }
        return this.tempVar;
    }

    protected int getLocalVar(Declarator declarator) {
        int n2 = declarator.getLocalVar();
        if (n2 < 0) {
            n2 = this.getMaxLocals();
            declarator.setLocalVar(n2);
            this.incMaxLocals(1);
        }
        return n2;
    }

    protected abstract String getThisName();

    protected abstract String getSuperName() throws CompileError;

    protected abstract String resolveClassName(ASTList var1) throws CompileError;

    protected abstract String resolveClassName(String var1) throws CompileError;

    protected static String toJvmArrayName(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        while (n3-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append('L');
        stringBuffer.append(string);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    protected static String toJvmTypeName(int n2, int n3) {
        char c2 = 'I';
        switch (n2) {
            case 301: {
                c2 = 'Z';
                break;
            }
            case 303: {
                c2 = 'B';
                break;
            }
            case 306: {
                c2 = 'C';
                break;
            }
            case 334: {
                c2 = 'S';
                break;
            }
            case 324: {
                c2 = 'I';
                break;
            }
            case 326: {
                c2 = 'J';
                break;
            }
            case 317: {
                c2 = 'F';
                break;
            }
            case 312: {
                c2 = 'D';
                break;
            }
            case 344: {
                c2 = 'V';
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n3-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append(c2);
        return stringBuffer.toString();
    }

    public void compileExpr(ASTree aSTree) throws CompileError {
        this.doTypeCheck(aSTree);
        aSTree.accept(this);
    }

    public boolean compileBooleanExpr(boolean bl2, ASTree aSTree) throws CompileError {
        this.doTypeCheck(aSTree);
        return this.booleanExpr(bl2, aSTree);
    }

    public void doTypeCheck(ASTree aSTree) throws CompileError {
        if (this.typeChecker != null) {
            aSTree.accept(this.typeChecker);
        }
    }

    public void atASTList(ASTList aSTList) throws CompileError {
        CodeGen.fatal();
    }

    public void atPair(Pair pair) throws CompileError {
        CodeGen.fatal();
    }

    public void atSymbol(Symbol symbol) throws CompileError {
        CodeGen.fatal();
    }

    public void atFieldDecl(FieldDecl fieldDecl) throws CompileError {
        fieldDecl.getInit().accept(this);
    }

    public void atMethodDecl(MethodDecl methodDecl) throws CompileError {
        ASTree aSTree;
        this.setMaxLocals(1);
        for (ASTList aSTList = methodDecl.getModifiers(); aSTList != null; aSTList = aSTList.tail()) {
            aSTree = (Keyword)aSTList.head();
            if (((Keyword)aSTree).get() != 335) continue;
            this.setMaxLocals(0);
            this.inStaticMethod = true;
        }
        for (aSTree = methodDecl.getParams(); aSTree != null; aSTree = ((ASTList)aSTree).tail()) {
            this.atDeclarator((Declarator)((ASTList)aSTree).head());
        }
        Stmnt stmnt = methodDecl.getBody();
        this.atMethodBody(stmnt, methodDecl.isConstructor(), methodDecl.getReturn().getType() == 344);
    }

    public void atMethodBody(Stmnt stmnt, boolean bl2, boolean bl3) throws CompileError {
        if (stmnt == null) {
            return;
        }
        if (bl2 && this.needsSuperCall(stmnt)) {
            this.insertDefaultSuperCall();
        }
        this.hasReturned = false;
        stmnt.accept(this);
        if (!this.hasReturned) {
            if (bl3) {
                this.bytecode.addOpcode(177);
                this.hasReturned = true;
            } else {
                throw new CompileError("no return statement");
            }
        }
    }

    private boolean needsSuperCall(Stmnt stmnt) throws CompileError {
        ASTree aSTree;
        ASTree aSTree2;
        if (stmnt.getOperator() == 66) {
            stmnt = (Stmnt)stmnt.head();
        }
        if (stmnt != null && stmnt.getOperator() == 69 && (aSTree2 = stmnt.head()) != null && aSTree2 instanceof Expr && ((Expr)aSTree2).getOperator() == 67 && (aSTree = ((Expr)aSTree2).head()) instanceof Keyword) {
            int n2 = ((Keyword)aSTree).get();
            return n2 != 339 && n2 != 336;
        }
        return true;
    }

    protected abstract void insertDefaultSuperCall() throws CompileError;

    public void atStmnt(Stmnt stmnt) throws CompileError {
        if (stmnt == null) {
            return;
        }
        int n2 = stmnt.getOperator();
        if (n2 == 69) {
            ASTree aSTree = stmnt.getLeft();
            this.doTypeCheck(aSTree);
            if (aSTree instanceof AssignExpr) {
                this.atAssignExpr((AssignExpr)aSTree, false);
            } else if (CodeGen.isPlusPlusExpr(aSTree)) {
                Expr expr = (Expr)aSTree;
                this.atPlusPlus(expr.getOperator(), expr.oprand1(), expr, false);
            } else {
                aSTree.accept(this);
                if (CodeGen.is2word(this.exprType, this.arrayDim)) {
                    this.bytecode.addOpcode(88);
                } else if (this.exprType != 344) {
                    this.bytecode.addOpcode(87);
                }
            }
        } else if (n2 == 68 || n2 == 66) {
            for (ASTList aSTList = stmnt; aSTList != null; aSTList = aSTList.tail()) {
                ASTree aSTree = aSTList.head();
                if (aSTree == null) continue;
                aSTree.accept(this);
            }
        } else if (n2 == 320) {
            this.atIfStmnt(stmnt);
        } else if (n2 == 346 || n2 == 311) {
            this.atWhileStmnt(stmnt, n2 == 346);
        } else if (n2 == 318) {
            this.atForStmnt(stmnt);
        } else if (n2 == 302 || n2 == 309) {
            this.atBreakStmnt(stmnt, n2 == 302);
        } else if (n2 == 333) {
            this.atReturnStmnt(stmnt);
        } else if (n2 == 340) {
            this.atThrowStmnt(stmnt);
        } else if (n2 == 343) {
            this.atTryStmnt(stmnt);
        } else if (n2 == 337) {
            this.atSwitchStmnt(stmnt);
        } else if (n2 == 338) {
            this.atSyncStmnt(stmnt);
        } else {
            this.hasReturned = false;
            throw new CompileError("sorry, not supported statement: TokenId " + n2);
        }
    }

    private void atIfStmnt(Stmnt stmnt) throws CompileError {
        ASTree aSTree = stmnt.head();
        Stmnt stmnt2 = (Stmnt)stmnt.tail().head();
        Stmnt stmnt3 = (Stmnt)stmnt.tail().tail().head();
        this.compileBooleanExpr(false, aSTree);
        int n2 = this.bytecode.currentPc();
        int n3 = 0;
        this.bytecode.addIndex(0);
        this.hasReturned = false;
        if (stmnt2 != null) {
            stmnt2.accept(this);
        }
        boolean bl2 = this.hasReturned;
        this.hasReturned = false;
        if (stmnt3 != null && !bl2) {
            this.bytecode.addOpcode(167);
            n3 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        this.bytecode.write16bit(n2, this.bytecode.currentPc() - n2 + 1);
        if (stmnt3 != null) {
            stmnt3.accept(this);
            if (!bl2) {
                this.bytecode.write16bit(n3, this.bytecode.currentPc() - n3 + 1);
            }
            this.hasReturned = bl2 && this.hasReturned;
        }
    }

    private void atWhileStmnt(Stmnt stmnt, boolean bl2) throws CompileError {
        ArrayList arrayList = this.breakList;
        ArrayList arrayList2 = this.continueList;
        this.breakList = new ArrayList();
        this.continueList = new ArrayList();
        ASTree aSTree = stmnt.head();
        Stmnt stmnt2 = (Stmnt)stmnt.tail();
        int n2 = 0;
        if (bl2) {
            this.bytecode.addOpcode(167);
            n2 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        int n3 = this.bytecode.currentPc();
        if (stmnt2 != null) {
            stmnt2.accept(this);
        }
        int n4 = this.bytecode.currentPc();
        if (bl2) {
            this.bytecode.write16bit(n2, n4 - n2 + 1);
        }
        boolean bl3 = this.compileBooleanExpr(true, aSTree);
        this.bytecode.addIndex(n3 - this.bytecode.currentPc() + 1);
        this.patchGoto(this.breakList, this.bytecode.currentPc());
        this.patchGoto(this.continueList, n4);
        this.continueList = arrayList2;
        this.breakList = arrayList;
        this.hasReturned = bl3;
    }

    protected void patchGoto(ArrayList arrayList, int n2) {
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = (Integer)arrayList.get(i2);
            this.bytecode.write16bit(n4, n2 - n4 + 1);
        }
    }

    private void atForStmnt(Stmnt stmnt) throws CompileError {
        ArrayList arrayList = this.breakList;
        ArrayList arrayList2 = this.continueList;
        this.breakList = new ArrayList();
        this.continueList = new ArrayList();
        Stmnt stmnt2 = (Stmnt)stmnt.head();
        ASTList aSTList = stmnt.tail();
        ASTree aSTree = aSTList.head();
        aSTList = aSTList.tail();
        Stmnt stmnt3 = (Stmnt)aSTList.head();
        Stmnt stmnt4 = (Stmnt)aSTList.tail();
        if (stmnt2 != null) {
            stmnt2.accept(this);
        }
        int n2 = this.bytecode.currentPc();
        int n3 = 0;
        if (aSTree != null) {
            this.compileBooleanExpr(false, aSTree);
            n3 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        if (stmnt4 != null) {
            stmnt4.accept(this);
        }
        int n4 = this.bytecode.currentPc();
        if (stmnt3 != null) {
            stmnt3.accept(this);
        }
        this.bytecode.addOpcode(167);
        this.bytecode.addIndex(n2 - this.bytecode.currentPc() + 1);
        int n5 = this.bytecode.currentPc();
        if (aSTree != null) {
            this.bytecode.write16bit(n3, n5 - n3 + 1);
        }
        this.patchGoto(this.breakList, n5);
        this.patchGoto(this.continueList, n4);
        this.continueList = arrayList2;
        this.breakList = arrayList;
        this.hasReturned = false;
    }

    private void atSwitchStmnt(Stmnt stmnt) throws CompileError {
        int n2;
        this.compileExpr(stmnt.head());
        ArrayList arrayList = this.breakList;
        this.breakList = new ArrayList();
        int n3 = this.bytecode.currentPc();
        this.bytecode.addOpcode(171);
        int n4 = 3 - (n3 & 3);
        while (n4-- > 0) {
            this.bytecode.add(0);
        }
        Stmnt stmnt2 = (Stmnt)stmnt.tail();
        int n5 = 0;
        for (ASTList aSTList = stmnt2; aSTList != null; aSTList = aSTList.tail()) {
            if (((Stmnt)aSTList.head()).getOperator() != 304) continue;
            ++n5;
        }
        int n6 = this.bytecode.currentPc();
        this.bytecode.addGap(4);
        this.bytecode.add32bit(n5);
        this.bytecode.addGap(n5 * 8);
        long[] lArray = new long[n5];
        int n7 = 0;
        int n8 = -1;
        for (ASTList aSTList = stmnt2; aSTList != null; aSTList = aSTList.tail()) {
            Stmnt stmnt3 = (Stmnt)aSTList.head();
            int n9 = stmnt3.getOperator();
            if (n9 == 310) {
                n8 = this.bytecode.currentPc();
            } else if (n9 != 304) {
                CodeGen.fatal();
            } else {
                lArray[n7++] = ((long)this.computeLabel(stmnt3.head()) << 32) + ((long)(this.bytecode.currentPc() - n3) & 0xFFFFFFFFFFFFFFFFL);
            }
            this.hasReturned = false;
            ((Stmnt)stmnt3.tail()).accept(this);
        }
        Arrays.sort(lArray);
        int n10 = n6 + 8;
        for (n2 = 0; n2 < n5; ++n2) {
            this.bytecode.write32bit(n10, (int)(lArray[n2] >>> 32));
            this.bytecode.write32bit(n10 + 4, (int)lArray[n2]);
            n10 += 8;
        }
        if (n8 < 0 || this.breakList.size() > 0) {
            this.hasReturned = false;
        }
        n2 = this.bytecode.currentPc();
        if (n8 < 0) {
            n8 = n2;
        }
        this.bytecode.write32bit(n6, n8 - n3);
        this.patchGoto(this.breakList, n2);
        this.breakList = arrayList;
    }

    private int computeLabel(ASTree aSTree) throws CompileError {
        this.doTypeCheck(aSTree);
        aSTree = TypeChecker.stripPlusExpr(aSTree);
        if (aSTree instanceof IntConst) {
            return (int)((IntConst)aSTree).get();
        }
        throw new CompileError("bad case label");
    }

    private void atBreakStmnt(Stmnt stmnt, boolean bl2) throws CompileError {
        if (stmnt.head() != null) {
            throw new CompileError("sorry, not support labeled break or continue");
        }
        this.bytecode.addOpcode(167);
        Integer n2 = new Integer(this.bytecode.currentPc());
        this.bytecode.addIndex(0);
        if (bl2) {
            this.breakList.add(n2);
        } else {
            this.continueList.add(n2);
        }
    }

    protected void atReturnStmnt(Stmnt stmnt) throws CompileError {
        this.atReturnStmnt2(stmnt.getLeft());
    }

    protected final void atReturnStmnt2(ASTree aSTree) throws CompileError {
        int n2;
        if (aSTree == null) {
            n2 = 177;
        } else {
            int n3;
            this.compileExpr(aSTree);
            n2 = this.arrayDim > 0 ? 176 : ((n3 = this.exprType) == 312 ? 175 : (n3 == 317 ? 174 : (n3 == 326 ? 173 : (CodeGen.isRefType(n3) ? 176 : 172))));
        }
        CodeGen$ReturnHook codeGen$ReturnHook = this.returnHooks;
        while (codeGen$ReturnHook != null) {
            if (codeGen$ReturnHook.doit(this.bytecode, n2)) {
                this.hasReturned = true;
                return;
            }
            codeGen$ReturnHook = codeGen$ReturnHook.next;
        }
        this.bytecode.addOpcode(n2);
        this.hasReturned = true;
    }

    private void atThrowStmnt(Stmnt stmnt) throws CompileError {
        ASTree aSTree = stmnt.getLeft();
        this.compileExpr(aSTree);
        if (this.exprType != 307 || this.arrayDim > 0) {
            throw new CompileError("bad throw statement");
        }
        this.bytecode.addOpcode(191);
        this.hasReturned = true;
    }

    protected void atTryStmnt(Stmnt stmnt) throws CompileError {
        this.hasReturned = false;
    }

    private void atSyncStmnt(Stmnt stmnt) throws CompileError {
        int n2 = CodeGen.getListSize(this.breakList);
        int n3 = CodeGen.getListSize(this.continueList);
        this.compileExpr(stmnt.head());
        if (this.exprType != 307 && this.arrayDim == 0) {
            throw new CompileError("bad type expr for synchronized block");
        }
        Bytecode bytecode = this.bytecode;
        int n4 = bytecode.getMaxLocals();
        bytecode.incMaxLocals(1);
        bytecode.addOpcode(89);
        bytecode.addAstore(n4);
        bytecode.addOpcode(194);
        CodeGen$1 codeGen$1 = new CodeGen$1(this, this, n4);
        int n5 = bytecode.currentPc();
        Stmnt stmnt2 = (Stmnt)stmnt.tail();
        if (stmnt2 != null) {
            stmnt2.accept(this);
        }
        int n6 = bytecode.currentPc();
        int n7 = 0;
        if (!this.hasReturned) {
            ((CodeGen$ReturnHook)codeGen$1).doit(bytecode, 0);
            bytecode.addOpcode(167);
            n7 = bytecode.currentPc();
            bytecode.addIndex(0);
        }
        if (n5 < n6) {
            int n8 = bytecode.currentPc();
            ((CodeGen$ReturnHook)codeGen$1).doit(bytecode, 0);
            bytecode.addOpcode(191);
            bytecode.addExceptionHandler(n5, n6, n8, 0);
        }
        if (!this.hasReturned) {
            bytecode.write16bit(n7, bytecode.currentPc() - n7 + 1);
        }
        codeGen$1.remove(this);
        if (CodeGen.getListSize(this.breakList) != n2 || CodeGen.getListSize(this.continueList) != n3) {
            throw new CompileError("sorry, cannot break/continue in synchronized block");
        }
    }

    private static int getListSize(ArrayList arrayList) {
        return arrayList == null ? 0 : arrayList.size();
    }

    private static boolean isPlusPlusExpr(ASTree aSTree) {
        if (aSTree instanceof Expr) {
            int n2 = ((Expr)aSTree).getOperator();
            return n2 == 362 || n2 == 363;
        }
        return false;
    }

    public void atDeclarator(Declarator declarator) throws CompileError {
        declarator.setLocalVar(this.getMaxLocals());
        declarator.setClassName(this.resolveClassName(declarator.getClassName()));
        int n2 = CodeGen.is2word(declarator.getType(), declarator.getArrayDim()) ? 2 : 1;
        this.incMaxLocals(n2);
        ASTree aSTree = declarator.getInitializer();
        if (aSTree != null) {
            this.doTypeCheck(aSTree);
            this.atVariableAssign(null, 61, null, declarator, aSTree, false);
        }
    }

    public abstract void atNewExpr(NewExpr var1) throws CompileError;

    public abstract void atArrayInit(ArrayInit var1) throws CompileError;

    public void atAssignExpr(AssignExpr assignExpr) throws CompileError {
        this.atAssignExpr(assignExpr, true);
    }

    protected void atAssignExpr(AssignExpr assignExpr, boolean bl2) throws CompileError {
        int n2 = assignExpr.getOperator();
        ASTree aSTree = assignExpr.oprand1();
        ASTree aSTree2 = assignExpr.oprand2();
        if (aSTree instanceof Variable) {
            this.atVariableAssign(assignExpr, n2, (Variable)aSTree, ((Variable)aSTree).getDeclarator(), aSTree2, bl2);
        } else {
            Expr expr;
            if (aSTree instanceof Expr && (expr = (Expr)aSTree).getOperator() == 65) {
                this.atArrayAssign(assignExpr, n2, (Expr)aSTree, aSTree2, bl2);
                return;
            }
            this.atFieldAssign(assignExpr, n2, aSTree, aSTree2, bl2);
        }
    }

    protected static void badAssign(Expr expr) throws CompileError {
        String string = expr == null ? "incompatible type for assignment" : "incompatible type for " + expr.getName();
        throw new CompileError(string);
    }

    private void atVariableAssign(Expr expr, int n2, Variable variable, Declarator declarator, ASTree aSTree, boolean bl2) throws CompileError {
        int n3 = declarator.getType();
        int n4 = declarator.getArrayDim();
        String string = declarator.getClassName();
        int n5 = this.getLocalVar(declarator);
        if (n2 != 61) {
            this.atVariable(variable);
        }
        if (expr == null && aSTree instanceof ArrayInit) {
            this.atArrayVariableAssign((ArrayInit)aSTree, n3, n4, string);
        } else {
            this.atAssignCore(expr, n2, aSTree, n3, n4, string);
        }
        if (bl2) {
            if (CodeGen.is2word(n3, n4)) {
                this.bytecode.addOpcode(92);
            } else {
                this.bytecode.addOpcode(89);
            }
        }
        if (n4 > 0) {
            this.bytecode.addAstore(n5);
        } else if (n3 == 312) {
            this.bytecode.addDstore(n5);
        } else if (n3 == 317) {
            this.bytecode.addFstore(n5);
        } else if (n3 == 326) {
            this.bytecode.addLstore(n5);
        } else if (CodeGen.isRefType(n3)) {
            this.bytecode.addAstore(n5);
        } else {
            this.bytecode.addIstore(n5);
        }
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    protected abstract void atArrayVariableAssign(ArrayInit var1, int var2, int var3, String var4) throws CompileError;

    private void atArrayAssign(Expr expr, int n2, Expr expr2, ASTree aSTree, boolean bl2) throws CompileError {
        this.arrayAccess(expr2.oprand1(), expr2.oprand2());
        if (n2 != 61) {
            this.bytecode.addOpcode(92);
            this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
        }
        int n3 = this.exprType;
        int n4 = this.arrayDim;
        String string = this.className;
        this.atAssignCore(expr, n2, aSTree, n3, n4, string);
        if (bl2) {
            if (CodeGen.is2word(n3, n4)) {
                this.bytecode.addOpcode(94);
            } else {
                this.bytecode.addOpcode(91);
            }
        }
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(n3, n4));
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    protected abstract void atFieldAssign(Expr var1, int var2, ASTree var3, ASTree var4, boolean var5) throws CompileError;

    protected void atAssignCore(Expr expr, int n2, ASTree aSTree, int n3, int n4, String string) throws CompileError {
        if (n2 == 354 && n4 == 0 && n3 == 307) {
            this.atStringPlusEq(expr, n3, n4, string, aSTree);
        } else {
            aSTree.accept(this);
            if (this.invalidDim(this.exprType, this.arrayDim, this.className, n3, n4, string, false) || n2 != 61 && n4 > 0) {
                CodeGen.badAssign(expr);
            }
            if (n2 != 61) {
                int n5 = TokenId.assignOps[n2 - 351];
                int n6 = CodeGen.lookupBinOp(n5);
                if (n6 < 0) {
                    CodeGen.fatal();
                }
                this.atArithBinExpr(expr, n5, n6, n3);
            }
        }
        if (n2 != 61 || n4 == 0 && !CodeGen.isRefType(n3)) {
            this.atNumCastExpr(this.exprType, n3);
        }
    }

    private void atStringPlusEq(Expr expr, int n2, int n3, String string, ASTree aSTree) throws CompileError {
        if (!jvmJavaLangString.equals(string)) {
            CodeGen.badAssign(expr);
        }
        this.convToString(n2, n3);
        aSTree.accept(this);
        this.convToString(this.exprType, this.arrayDim);
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    private boolean invalidDim(int n2, int n3, String string, int n4, int n5, String string2, boolean bl2) {
        if (n3 != n5) {
            if (n2 == 412) {
                return false;
            }
            if (n5 == 0 && n4 == 307 && jvmJavaLangObject.equals(string2)) {
                return false;
            }
            return !bl2 || n3 != 0 || n2 != 307 || !jvmJavaLangObject.equals(string);
        }
        return false;
    }

    public void atCondExpr(CondExpr condExpr) throws CompileError {
        this.booleanExpr(false, condExpr.condExpr());
        int n2 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        condExpr.thenExpr().accept(this);
        int n3 = this.arrayDim;
        this.bytecode.addOpcode(167);
        int n4 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        this.bytecode.write16bit(n2, this.bytecode.currentPc() - n2 + 1);
        condExpr.elseExpr().accept(this);
        if (n3 != this.arrayDim) {
            throw new CompileError("type mismatch in ?:");
        }
        this.bytecode.write16bit(n4, this.bytecode.currentPc() - n4 + 1);
    }

    static int lookupBinOp(int n2) {
        int[] nArray = binOp;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; i2 += 5) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public void atBinExpr(BinExpr binExpr) throws CompileError {
        int n2 = binExpr.getOperator();
        int n3 = CodeGen.lookupBinOp(n2);
        if (n3 >= 0) {
            binExpr.oprand1().accept(this);
            ASTree aSTree = binExpr.oprand2();
            if (aSTree == null) {
                return;
            }
            int n4 = this.exprType;
            int n5 = this.arrayDim;
            String string = this.className;
            aSTree.accept(this);
            if (n5 != this.arrayDim) {
                throw new CompileError("incompatible array types");
            }
            if (n2 == 43 && n5 == 0 && (n4 == 307 || this.exprType == 307)) {
                this.atStringConcatExpr(binExpr, n4, n5, string);
            } else {
                this.atArithBinExpr(binExpr, n2, n3, n4);
            }
        } else {
            this.booleanExpr(true, binExpr);
            this.bytecode.addIndex(7);
            this.bytecode.addIconst(0);
            this.bytecode.addOpcode(167);
            this.bytecode.addIndex(4);
            this.bytecode.addIconst(1);
        }
    }

    private void atArithBinExpr(Expr expr, int n2, int n3, int n4) throws CompileError {
        int n5;
        if (this.arrayDim != 0) {
            CodeGen.badTypes(expr);
        }
        int n6 = this.exprType;
        if (n2 == 364 || n2 == 366 || n2 == 370) {
            if (n6 == 324 || n6 == 334 || n6 == 306 || n6 == 303) {
                this.exprType = n4;
            } else {
                CodeGen.badTypes(expr);
            }
        } else {
            this.convertOprandTypes(n4, n6, expr);
        }
        int n7 = CodeGen.typePrecedence(this.exprType);
        if (n7 >= 0 && (n5 = binOp[n3 + n7 + 1]) != 0) {
            if (n7 == 3 && this.exprType != 301) {
                this.exprType = 324;
            }
            this.bytecode.addOpcode(n5);
            return;
        }
        CodeGen.badTypes(expr);
    }

    private void atStringConcatExpr(Expr expr, int n2, int n3, String string) throws CompileError {
        boolean bl2;
        int n4 = this.exprType;
        int n5 = this.arrayDim;
        boolean bl3 = CodeGen.is2word(n4, n5);
        boolean bl4 = bl2 = n4 == 307 && jvmJavaLangString.equals(this.className);
        if (bl3) {
            this.convToString(n4, n5);
        }
        if (CodeGen.is2word(n2, n3)) {
            this.bytecode.addOpcode(91);
            this.bytecode.addOpcode(87);
        } else {
            this.bytecode.addOpcode(95);
        }
        this.convToString(n2, n3);
        this.bytecode.addOpcode(95);
        if (!bl3 && !bl2) {
            this.convToString(n4, n5);
        }
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    private void convToString(int n2, int n3) throws CompileError {
        String string = "valueOf";
        if (CodeGen.isRefType(n2) || n3 > 0) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
        } else if (n2 == 312) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(D)Ljava/lang/String;");
        } else if (n2 == 317) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(F)Ljava/lang/String;");
        } else if (n2 == 326) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(J)Ljava/lang/String;");
        } else if (n2 == 301) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Z)Ljava/lang/String;");
        } else if (n2 == 306) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(C)Ljava/lang/String;");
        } else {
            if (n2 == 344) {
                throw new CompileError("void type expression");
            }
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(I)Ljava/lang/String;");
        }
    }

    private boolean booleanExpr(boolean bl2, ASTree aSTree) throws CompileError {
        int n2 = CodeGen.getCompOperator(aSTree);
        if (n2 == 358) {
            BinExpr binExpr = (BinExpr)aSTree;
            int n3 = this.compileOprands(binExpr);
            this.compareExpr(bl2, binExpr.getOperator(), n3, binExpr);
        } else if (n2 == 33) {
            this.booleanExpr(!bl2, ((Expr)aSTree).oprand1());
        } else {
            boolean bl3 = n2 == 369;
            if (bl3 || n2 == 368) {
                BinExpr binExpr = (BinExpr)aSTree;
                this.booleanExpr(!bl3, binExpr.oprand1());
                int n4 = this.bytecode.currentPc();
                this.bytecode.addIndex(0);
                this.booleanExpr(bl3, binExpr.oprand2());
                this.bytecode.write16bit(n4, this.bytecode.currentPc() - n4 + 3);
                if (bl2 != bl3) {
                    this.bytecode.addIndex(6);
                    this.bytecode.addOpcode(167);
                }
            } else {
                if (CodeGen.isAlwaysBranch(aSTree, bl2)) {
                    this.bytecode.addOpcode(167);
                    return true;
                }
                aSTree.accept(this);
                if (this.exprType != 301 || this.arrayDim != 0) {
                    throw new CompileError("boolean expr is required");
                }
                this.bytecode.addOpcode(bl2 ? 154 : 153);
            }
        }
        this.exprType = 301;
        this.arrayDim = 0;
        return false;
    }

    private static boolean isAlwaysBranch(ASTree aSTree, boolean bl2) {
        if (aSTree instanceof Keyword) {
            int n2 = ((Keyword)aSTree).get();
            return bl2 ? n2 == 410 : n2 == 411;
        }
        return false;
    }

    static int getCompOperator(ASTree aSTree) throws CompileError {
        if (aSTree instanceof Expr) {
            Expr expr = (Expr)aSTree;
            int n2 = expr.getOperator();
            if (n2 == 33) {
                return 33;
            }
            if (expr instanceof BinExpr && n2 != 368 && n2 != 369 && n2 != 38 && n2 != 124) {
                return 358;
            }
            return n2;
        }
        return 32;
    }

    private int compileOprands(BinExpr binExpr) throws CompileError {
        binExpr.oprand1().accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        binExpr.oprand2().accept(this);
        if (n3 != this.arrayDim) {
            if (n2 != 412 && this.exprType != 412) {
                throw new CompileError("incompatible array types");
            }
            if (this.exprType == 412) {
                this.arrayDim = n3;
            }
        }
        if (n2 == 412) {
            return this.exprType;
        }
        return n2;
    }

    private void compareExpr(boolean bl2, int n2, int n3, BinExpr binExpr) throws CompileError {
        int n4;
        if (this.arrayDim == 0) {
            this.convertOprandTypes(n3, this.exprType, binExpr);
        }
        if ((n4 = CodeGen.typePrecedence(this.exprType)) == -1 || this.arrayDim > 0) {
            if (n2 == 358) {
                this.bytecode.addOpcode(bl2 ? 165 : 166);
            } else if (n2 == 350) {
                this.bytecode.addOpcode(bl2 ? 166 : 165);
            } else {
                CodeGen.badTypes(binExpr);
            }
        } else if (n4 == 3) {
            int[] nArray = ifOp;
            for (int i2 = 0; i2 < nArray.length; i2 += 3) {
                if (nArray[i2] != n2) continue;
                this.bytecode.addOpcode(nArray[i2 + (bl2 ? 1 : 2)]);
                return;
            }
            CodeGen.badTypes(binExpr);
        } else {
            if (n4 == 0) {
                if (n2 == 60 || n2 == 357) {
                    this.bytecode.addOpcode(152);
                } else {
                    this.bytecode.addOpcode(151);
                }
            } else if (n4 == 1) {
                if (n2 == 60 || n2 == 357) {
                    this.bytecode.addOpcode(150);
                } else {
                    this.bytecode.addOpcode(149);
                }
            } else if (n4 == 2) {
                this.bytecode.addOpcode(148);
            } else {
                CodeGen.fatal();
            }
            int[] nArray = ifOp2;
            for (int i3 = 0; i3 < nArray.length; i3 += 3) {
                if (nArray[i3] != n2) continue;
                this.bytecode.addOpcode(nArray[i3 + (bl2 ? 1 : 2)]);
                return;
            }
            CodeGen.badTypes(binExpr);
        }
    }

    protected static void badTypes(Expr expr) throws CompileError {
        throw new CompileError("invalid types for " + expr.getName());
    }

    protected static boolean isRefType(int n2) {
        return n2 == 307 || n2 == 412;
    }

    private static int typePrecedence(int n2) {
        if (n2 == 312) {
            return 0;
        }
        if (n2 == 317) {
            return 1;
        }
        if (n2 == 326) {
            return 2;
        }
        if (CodeGen.isRefType(n2)) {
            return -1;
        }
        if (n2 == 344) {
            return -1;
        }
        return 3;
    }

    static boolean isP_INT(int n2) {
        return CodeGen.typePrecedence(n2) == 3;
    }

    static boolean rightIsStrong(int n2, int n3) {
        int n4 = CodeGen.typePrecedence(n2);
        int n5 = CodeGen.typePrecedence(n3);
        return n4 >= 0 && n5 >= 0 && n4 > n5;
    }

    private void convertOprandTypes(int n2, int n3, Expr expr) throws CompileError {
        int n4;
        int n5;
        boolean bl2;
        int n6 = CodeGen.typePrecedence(n2);
        int n7 = CodeGen.typePrecedence(n3);
        if (n7 < 0 && n6 < 0) {
            return;
        }
        if (n7 < 0 || n6 < 0) {
            CodeGen.badTypes(expr);
        }
        if (n6 <= n7) {
            bl2 = false;
            this.exprType = n2;
            n5 = castOp[n7 * 4 + n6];
            n4 = n6;
        } else {
            bl2 = true;
            n5 = castOp[n6 * 4 + n7];
            n4 = n7;
        }
        if (bl2) {
            if (n4 == 0 || n4 == 2) {
                if (n6 == 0 || n6 == 2) {
                    this.bytecode.addOpcode(94);
                } else {
                    this.bytecode.addOpcode(93);
                }
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(n5);
                this.bytecode.addOpcode(94);
                this.bytecode.addOpcode(88);
            } else if (n4 == 1) {
                if (n6 == 2) {
                    this.bytecode.addOpcode(91);
                    this.bytecode.addOpcode(87);
                } else {
                    this.bytecode.addOpcode(95);
                }
                this.bytecode.addOpcode(n5);
                this.bytecode.addOpcode(95);
            } else {
                CodeGen.fatal();
            }
        } else if (n5 != 0) {
            this.bytecode.addOpcode(n5);
        }
    }

    public void atCastExpr(CastExpr castExpr) throws CompileError {
        String string = this.resolveClassName(castExpr.getClassName());
        String string2 = this.checkCastExpr(castExpr, string);
        int n2 = this.exprType;
        this.exprType = castExpr.getType();
        this.arrayDim = castExpr.getArrayDim();
        this.className = string;
        if (string2 == null) {
            this.atNumCastExpr(n2, this.exprType);
        } else {
            this.bytecode.addCheckcast(string2);
        }
    }

    public void atInstanceOfExpr(InstanceOfExpr instanceOfExpr) throws CompileError {
        String string = this.resolveClassName(instanceOfExpr.getClassName());
        String string2 = this.checkCastExpr(instanceOfExpr, string);
        this.bytecode.addInstanceof(string2);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    private String checkCastExpr(CastExpr castExpr, String string) throws CompileError {
        String string2 = "invalid cast";
        ASTree aSTree = castExpr.getOprand();
        int n2 = castExpr.getArrayDim();
        int n3 = castExpr.getType();
        aSTree.accept(this);
        int n4 = this.exprType;
        if (this.invalidDim(n4, this.arrayDim, this.className, n3, n2, string, true) || n4 == 344 || n3 == 344) {
            throw new CompileError("invalid cast");
        }
        if (n3 == 307) {
            if (!CodeGen.isRefType(n4)) {
                throw new CompileError("invalid cast");
            }
            return CodeGen.toJvmArrayName(string, n2);
        }
        if (n2 > 0) {
            return CodeGen.toJvmTypeName(n3, n2);
        }
        return null;
    }

    void atNumCastExpr(int n2, int n3) throws CompileError {
        if (n2 == n3) {
            return;
        }
        int n4 = CodeGen.typePrecedence(n2);
        int n5 = CodeGen.typePrecedence(n3);
        int n6 = 0 <= n4 && n4 < 3 ? castOp[n4 * 4 + n5] : 0;
        int n7 = n3 == 312 ? 135 : (n3 == 317 ? 134 : (n3 == 326 ? 133 : (n3 == 334 ? 147 : (n3 == 306 ? 146 : (n3 == 303 ? 145 : 0)))));
        if (n6 != 0) {
            this.bytecode.addOpcode(n6);
        }
        if ((n6 == 0 || n6 == 136 || n6 == 139 || n6 == 142) && n7 != 0) {
            this.bytecode.addOpcode(n7);
        }
    }

    public void atExpr(Expr expr) throws CompileError {
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        if (n2 == 46) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
            } else {
                this.atFieldRead(expr);
            }
        } else if (n2 == 35) {
            this.atFieldRead(expr);
        } else if (n2 == 65) {
            this.atArrayRead(aSTree, expr.oprand2());
        } else if (n2 == 362 || n2 == 363) {
            this.atPlusPlus(n2, aSTree, expr, true);
        } else if (n2 == 33) {
            this.booleanExpr(false, expr);
            this.bytecode.addIndex(7);
            this.bytecode.addIconst(1);
            this.bytecode.addOpcode(167);
            this.bytecode.addIndex(4);
            this.bytecode.addIconst(0);
        } else if (n2 == 67) {
            CodeGen.fatal();
        } else {
            expr.oprand1().accept(this);
            int n3 = CodeGen.typePrecedence(this.exprType);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (n2 == 45) {
                if (n3 == 0) {
                    this.bytecode.addOpcode(119);
                } else if (n3 == 1) {
                    this.bytecode.addOpcode(118);
                } else if (n3 == 2) {
                    this.bytecode.addOpcode(117);
                } else if (n3 == 3) {
                    this.bytecode.addOpcode(116);
                    this.exprType = 324;
                } else {
                    CodeGen.badType(expr);
                }
            } else if (n2 == 126) {
                if (n3 == 3) {
                    this.bytecode.addIconst(-1);
                    this.bytecode.addOpcode(130);
                    this.exprType = 324;
                } else if (n3 == 2) {
                    this.bytecode.addLconst(-1L);
                    this.bytecode.addOpcode(131);
                } else {
                    CodeGen.badType(expr);
                }
            } else if (n2 == 43) {
                if (n3 == -1) {
                    CodeGen.badType(expr);
                }
            } else {
                CodeGen.fatal();
            }
        }
    }

    protected static void badType(Expr expr) throws CompileError {
        throw new CompileError("invalid type for " + expr.getName());
    }

    public abstract void atCallExpr(CallExpr var1) throws CompileError;

    protected abstract void atFieldRead(ASTree var1) throws CompileError;

    public void atClassObject(Expr expr) throws CompileError {
        ASTree aSTree = expr.oprand1();
        if (!(aSTree instanceof Symbol)) {
            throw new CompileError("fatal error: badly parsed .class expr");
        }
        String string = ((Symbol)aSTree).get();
        if (string.startsWith("[")) {
            String string2;
            String string3;
            int n2 = string.indexOf("[L");
            if (n2 >= 0 && !(string3 = string.substring(n2 + 2, string.length() - 1)).equals(string2 = this.resolveClassName(string3))) {
                string2 = MemberResolver.jvmToJavaName(string2);
                StringBuffer stringBuffer = new StringBuffer();
                while (n2-- >= 0) {
                    stringBuffer.append('[');
                }
                stringBuffer.append('L').append(string2).append(';');
                string = stringBuffer.toString();
            }
        } else {
            string = this.resolveClassName(MemberResolver.javaToJvmName(string));
            string = MemberResolver.jvmToJavaName(string);
        }
        this.atClassObject2(string);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/Class";
    }

    protected void atClassObject2(String string) throws CompileError {
        int n2 = this.bytecode.currentPc();
        this.bytecode.addLdc(string);
        this.bytecode.addInvokestatic("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        int n3 = this.bytecode.currentPc();
        this.bytecode.addOpcode(167);
        int n4 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        this.bytecode.addExceptionHandler(n2, n3, this.bytecode.currentPc(), "java.lang.ClassNotFoundException");
        this.bytecode.growStack(1);
        this.bytecode.addInvokestatic("org.zeroturnaround.bundled.javassist.runtime.DotClass", "fail", "(Ljava/lang/ClassNotFoundException;)Ljava/lang/NoClassDefFoundError;");
        this.bytecode.addOpcode(191);
        this.bytecode.write16bit(n4, this.bytecode.currentPc() - n4 + 1);
    }

    public void atArrayRead(ASTree aSTree, ASTree aSTree2) throws CompileError {
        this.arrayAccess(aSTree, aSTree2);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
    }

    protected void arrayAccess(ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree.accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        if (n3 == 0) {
            throw new CompileError("bad array access");
        }
        String string = this.className;
        aSTree2.accept(this);
        if (CodeGen.typePrecedence(this.exprType) != 3 || this.arrayDim > 0) {
            throw new CompileError("bad array index");
        }
        this.exprType = n2;
        this.arrayDim = n3 - 1;
        this.className = string;
    }

    protected static int getArrayReadOp(int n2, int n3) {
        if (n3 > 0) {
            return 50;
        }
        switch (n2) {
            case 312: {
                return 49;
            }
            case 317: {
                return 48;
            }
            case 326: {
                return 47;
            }
            case 324: {
                return 46;
            }
            case 334: {
                return 53;
            }
            case 306: {
                return 52;
            }
            case 301: 
            case 303: {
                return 51;
            }
        }
        return 50;
    }

    protected static int getArrayWriteOp(int n2, int n3) {
        if (n3 > 0) {
            return 83;
        }
        switch (n2) {
            case 312: {
                return 82;
            }
            case 317: {
                return 81;
            }
            case 326: {
                return 80;
            }
            case 324: {
                return 79;
            }
            case 334: {
                return 86;
            }
            case 306: {
                return 85;
            }
            case 301: 
            case 303: {
                return 84;
            }
        }
        return 83;
    }

    private void atPlusPlus(int n2, ASTree aSTree, Expr expr, boolean bl2) throws CompileError {
        boolean bl3;
        boolean bl4 = bl3 = aSTree == null;
        if (bl3) {
            aSTree = expr.oprand2();
        }
        if (aSTree instanceof Variable) {
            Declarator declarator = ((Variable)aSTree).getDeclarator();
            int n3 = this.exprType = declarator.getType();
            this.arrayDim = declarator.getArrayDim();
            int n4 = this.getLocalVar(declarator);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (n3 == 312) {
                this.bytecode.addDload(n4);
                if (bl2 && bl3) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDconst(1.0);
                this.bytecode.addOpcode(n2 == 362 ? 99 : 103);
                if (bl2 && !bl3) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDstore(n4);
            } else if (n3 == 326) {
                this.bytecode.addLload(n4);
                if (bl2 && bl3) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLconst(1L);
                this.bytecode.addOpcode(n2 == 362 ? 97 : 101);
                if (bl2 && !bl3) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLstore(n4);
            } else if (n3 == 317) {
                this.bytecode.addFload(n4);
                if (bl2 && bl3) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFconst(1.0f);
                this.bytecode.addOpcode(n2 == 362 ? 98 : 102);
                if (bl2 && !bl3) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFstore(n4);
            } else if (n3 == 303 || n3 == 306 || n3 == 334 || n3 == 324) {
                if (bl2 && bl3) {
                    this.bytecode.addIload(n4);
                }
                this.bytecode.addOpcode(132);
                this.bytecode.add(n4);
                this.bytecode.add(n2 == 362 ? 1 : -1);
                if (bl2 && !bl3) {
                    this.bytecode.addIload(n4);
                }
            } else {
                CodeGen.badType(expr);
            }
        } else {
            Expr expr2;
            if (aSTree instanceof Expr && (expr2 = (Expr)aSTree).getOperator() == 65) {
                this.atArrayPlusPlus(n2, bl3, expr2, bl2);
                return;
            }
            this.atFieldPlusPlus(n2, bl3, aSTree, expr, bl2);
        }
    }

    public void atArrayPlusPlus(int n2, boolean bl2, Expr expr, boolean bl3) throws CompileError {
        this.arrayAccess(expr.oprand1(), expr.oprand2());
        int n3 = this.exprType;
        int n4 = this.arrayDim;
        if (n4 > 0) {
            CodeGen.badType(expr);
        }
        this.bytecode.addOpcode(92);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(n3, this.arrayDim));
        int n5 = CodeGen.is2word(n3, n4) ? 94 : 91;
        this.atPlusPlusCore(n5, bl3, n2, bl2, expr);
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(n3, n4));
    }

    protected void atPlusPlusCore(int n2, boolean bl2, int n3, boolean bl3, Expr expr) throws CompileError {
        int n4 = this.exprType;
        if (bl2 && bl3) {
            this.bytecode.addOpcode(n2);
        }
        if (n4 == 324 || n4 == 303 || n4 == 306 || n4 == 334) {
            this.bytecode.addIconst(1);
            this.bytecode.addOpcode(n3 == 362 ? 96 : 100);
            this.exprType = 324;
        } else if (n4 == 326) {
            this.bytecode.addLconst(1L);
            this.bytecode.addOpcode(n3 == 362 ? 97 : 101);
        } else if (n4 == 317) {
            this.bytecode.addFconst(1.0f);
            this.bytecode.addOpcode(n3 == 362 ? 98 : 102);
        } else if (n4 == 312) {
            this.bytecode.addDconst(1.0);
            this.bytecode.addOpcode(n3 == 362 ? 99 : 103);
        } else {
            CodeGen.badType(expr);
        }
        if (bl2 && !bl3) {
            this.bytecode.addOpcode(n2);
        }
    }

    protected abstract void atFieldPlusPlus(int var1, boolean var2, ASTree var3, Expr var4, boolean var5) throws CompileError;

    public abstract void atMember(Member var1) throws CompileError;

    public void atVariable(Variable variable) throws CompileError {
        Declarator declarator = variable.getDeclarator();
        this.exprType = declarator.getType();
        this.arrayDim = declarator.getArrayDim();
        this.className = declarator.getClassName();
        int n2 = this.getLocalVar(declarator);
        if (this.arrayDim > 0) {
            this.bytecode.addAload(n2);
        } else {
            switch (this.exprType) {
                case 307: {
                    this.bytecode.addAload(n2);
                    break;
                }
                case 326: {
                    this.bytecode.addLload(n2);
                    break;
                }
                case 317: {
                    this.bytecode.addFload(n2);
                    break;
                }
                case 312: {
                    this.bytecode.addDload(n2);
                    break;
                }
                default: {
                    this.bytecode.addIload(n2);
                }
            }
        }
    }

    public void atKeyword(Keyword keyword) throws CompileError {
        this.arrayDim = 0;
        int n2 = keyword.get();
        switch (n2) {
            case 410: {
                this.bytecode.addIconst(1);
                this.exprType = 301;
                break;
            }
            case 411: {
                this.bytecode.addIconst(0);
                this.exprType = 301;
                break;
            }
            case 412: {
                this.bytecode.addOpcode(1);
                this.exprType = 412;
                break;
            }
            case 336: 
            case 339: {
                if (this.inStaticMethod) {
                    throw new CompileError("not-available: " + (n2 == 339 ? "this" : "super"));
                }
                this.bytecode.addAload(0);
                this.exprType = 307;
                if (n2 == 339) {
                    this.className = this.getThisName();
                    break;
                }
                this.className = this.getSuperName();
                break;
            }
            default: {
                CodeGen.fatal();
            }
        }
    }

    public void atStringL(StringL stringL) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
        this.bytecode.addLdc(stringL.get());
    }

    public void atIntConst(IntConst intConst) throws CompileError {
        this.arrayDim = 0;
        long l2 = intConst.get();
        int n2 = intConst.getType();
        if (n2 == 402 || n2 == 401) {
            this.exprType = n2 == 402 ? 324 : 306;
            this.bytecode.addIconst((int)l2);
        } else {
            this.exprType = 326;
            this.bytecode.addLconst(l2);
        }
    }

    public void atDoubleConst(DoubleConst doubleConst) throws CompileError {
        this.arrayDim = 0;
        if (doubleConst.getType() == 405) {
            this.exprType = 312;
            this.bytecode.addDconst(doubleConst.get());
        } else {
            this.exprType = 317;
            this.bytecode.addFconst((float)doubleConst.get());
        }
    }
}

