/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Writer;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Catch;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.Tracer;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$ClassName;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeTag;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypedBlock;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classPool, MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        TypedBlock[] typedBlockArray = TypedBlock.makeBlocks(methodInfo, codeAttribute, true);
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classPool, methodInfo, codeAttribute);
        mapMaker.make(typedBlockArray, codeAttribute.getCode());
        return mapMaker.toStackMap(typedBlockArray);
    }

    public MapMaker(ClassPool classPool, MethodInfo methodInfo, CodeAttribute codeAttribute) {
        super(classPool, methodInfo.getConstPool(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals(), TypedBlock.getRetType(methodInfo.getDescriptor()));
    }

    protected MapMaker(MapMaker mapMaker, boolean bl2) {
        super(mapMaker, bl2);
    }

    void make(TypedBlock[] typedBlockArray, byte[] byArray) throws BadBytecode {
        TypedBlock typedBlock = typedBlockArray[0];
        this.fixParamTypes(typedBlock);
        TypeData[] typeDataArray = typedBlock.localsTypes;
        MapMaker.copyFrom(typeDataArray.length, typeDataArray, this.localsTypes);
        this.make(byArray, typedBlock);
        int n2 = typedBlockArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.evalExpected(typedBlockArray[i2]);
        }
    }

    private void fixParamTypes(TypedBlock typedBlock) throws BadBytecode {
        TypeData[] typeDataArray = typedBlock.localsTypes;
        int n2 = typeDataArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[i2];
            if (!(typeData instanceof TypeData$ClassName)) continue;
            TypeData.setType(typeData, typeData.getName(), this.classPool);
        }
    }

    private void make(byte[] byArray, TypedBlock typedBlock) throws BadBytecode {
        int n2;
        BasicBlock$Catch basicBlock$Catch = typedBlock.toCatch;
        while (basicBlock$Catch != null) {
            this.traceException(byArray, basicBlock$Catch);
            basicBlock$Catch = basicBlock$Catch.next;
        }
        int n3 = n2 + typedBlock.length;
        for (n2 = typedBlock.position; n2 < n3; n2 += this.doOpcode(n2, byArray)) {
        }
        if (typedBlock.exit != null) {
            for (int i2 = 0; i2 < typedBlock.exit.length; ++i2) {
                TypedBlock typedBlock2 = (TypedBlock)typedBlock.exit[i2];
                if (typedBlock2.alreadySet()) {
                    this.mergeMap(typedBlock2, true);
                    continue;
                }
                this.recordStackMap(typedBlock2);
                MapMaker mapMaker = new MapMaker(this, true);
                mapMaker.make(byArray, typedBlock2);
            }
        }
    }

    private void traceException(byte[] byArray, BasicBlock$Catch basicBlock$Catch) throws BadBytecode {
        TypedBlock typedBlock = (TypedBlock)basicBlock$Catch.body;
        if (typedBlock.alreadySet()) {
            this.mergeMap(typedBlock, false);
        } else {
            this.recordStackMap(typedBlock, basicBlock$Catch.typeIndex);
            MapMaker mapMaker = new MapMaker(this, false);
            mapMaker.stackTypes[0] = typedBlock.stackTypes[0].getSelf();
            mapMaker.stackTop = 1;
            mapMaker.make(byArray, typedBlock);
        }
    }

    private void mergeMap(TypedBlock typedBlock, boolean bl2) {
        int n2;
        boolean[] blArray = typedBlock.inputs;
        int n3 = blArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            this.merge(this.localsTypes[n2], typedBlock.localsTypes[n2]);
        }
        if (bl2) {
            n3 = this.stackTop;
            for (n2 = 0; n2 < n3; ++n2) {
                this.merge(this.stackTypes[n2], typedBlock.stackTypes[n2]);
            }
        }
    }

    private void merge(TypeData typeData, TypeData typeData2) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (typeData != TypeTag.TOP && typeData.isObjectType()) {
            bl2 = true;
        }
        if (typeData2 != TypeTag.TOP && typeData2.isObjectType()) {
            bl3 = true;
        }
        if (bl2 && bl3) {
            typeData2.merge(typeData);
        }
    }

    private void recordStackMap(TypedBlock typedBlock) throws BadBytecode {
        TypeData[] typeDataArray = new TypeData[this.stackTypes.length];
        int n2 = this.stackTop;
        MapMaker.copyFrom(n2, this.stackTypes, typeDataArray);
        this.recordStackMap0(typedBlock, n2, typeDataArray);
    }

    private void recordStackMap(TypedBlock typedBlock, int n2) throws BadBytecode {
        String string = n2 == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(n2);
        TypeData[] typeDataArray = new TypeData[this.stackTypes.length];
        typeDataArray[0] = new TypeData$ClassName(string);
        this.recordStackMap0(typedBlock, 1, typeDataArray);
    }

    private void recordStackMap0(TypedBlock typedBlock, int n2, TypeData[] typeDataArray) throws BadBytecode {
        int n3 = this.localsTypes.length;
        TypeData[] typeDataArray2 = new TypeData[n3];
        int n4 = MapMaker.copyFrom(n3, this.localsTypes, typeDataArray2);
        boolean[] blArray = typedBlock.inputs;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (blArray[i2]) continue;
            typeDataArray2[i2] = TypeTag.TOP;
        }
        typedBlock.setStackMap(n2, typeDataArray, n4, typeDataArray2);
    }

    void evalExpected(TypedBlock typedBlock) throws BadBytecode {
        ClassPool classPool = this.classPool;
        MapMaker.evalExpected(classPool, typedBlock.stackTop, typedBlock.stackTypes);
        TypeData[] typeDataArray = typedBlock.localsTypes;
        if (typeDataArray != null) {
            MapMaker.evalExpected(classPool, typeDataArray.length, typeDataArray);
        }
    }

    private static void evalExpected(ClassPool classPool, int n2, TypeData[] typeDataArray) throws BadBytecode {
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[i2];
            if (typeData == null) continue;
            typeData.evalExpectedType(classPool);
        }
    }

    public StackMapTable toStackMap(TypedBlock[] typedBlockArray) {
        StackMapTable$Writer stackMapTable$Writer = new StackMapTable$Writer(32);
        int n2 = typedBlockArray.length;
        TypedBlock typedBlock = typedBlockArray[0];
        int n3 = typedBlock.length;
        if (typedBlock.incoming > 0) {
            stackMapTable$Writer.sameFrame(0);
            --n3;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            TypedBlock typedBlock2 = typedBlockArray[i2];
            if (this.isTarget(typedBlock2, typedBlockArray[i2 - 1])) {
                typedBlock2.resetNumLocals();
                int n4 = MapMaker.stackMapDiff(typedBlock.numLocals, typedBlock.localsTypes, typedBlock2.numLocals, typedBlock2.localsTypes);
                this.toStackMapBody(stackMapTable$Writer, typedBlock2, n4, n3, typedBlock);
                n3 = typedBlock2.length - 1;
                typedBlock = typedBlock2;
                continue;
            }
            n3 += typedBlock2.length;
        }
        return stackMapTable$Writer.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock typedBlock, TypedBlock typedBlock2) {
        int n2 = typedBlock.incoming;
        if (n2 > 1) {
            return true;
        }
        if (n2 < 1) {
            return false;
        }
        return typedBlock2.stop;
    }

    private void toStackMapBody(StackMapTable$Writer stackMapTable$Writer, TypedBlock typedBlock, int n2, int n3, TypedBlock typedBlock2) {
        Object object;
        int n4 = typedBlock.stackTop;
        if (n4 == 0) {
            if (n2 == 0) {
                stackMapTable$Writer.sameFrame(n3);
                return;
            }
            if (0 > n2 && n2 >= -3) {
                stackMapTable$Writer.chopFrame(n3, -n2);
                return;
            }
            if (0 < n2 && n2 <= 3) {
                int[] nArray = new int[n2];
                int[] nArray2 = this.fillStackMap(typedBlock.numLocals - typedBlock2.numLocals, typedBlock2.numLocals, nArray, typedBlock.localsTypes);
                stackMapTable$Writer.appendFrame(n3, nArray2, nArray);
                return;
            }
        } else {
            if (n4 == 1 && n2 == 0) {
                TypeData typeData = typedBlock.stackTypes[0];
                if (typeData == TypeTag.TOP) {
                    stackMapTable$Writer.sameLocals(n3, 0, 0);
                } else {
                    stackMapTable$Writer.sameLocals(n3, typeData.getTypeTag(), typeData.getTypeData(this.cpool));
                }
                return;
            }
            if (n4 == 2 && n2 == 0 && (object = (Object)typedBlock.stackTypes[0]) != TypeTag.TOP && ((TypeData)object).is2WordType()) {
                stackMapTable$Writer.sameLocals(n3, ((TypeData)object).getTypeTag(), ((TypeData)object).getTypeData(this.cpool));
                return;
            }
        }
        object = new int[n4];
        int[] nArray = this.fillStackMap(n4, 0, (int[])object, typedBlock.stackTypes);
        int[] nArray3 = new int[typedBlock.numLocals];
        int[] nArray4 = this.fillStackMap(typedBlock.numLocals, 0, nArray3, typedBlock.localsTypes);
        stackMapTable$Writer.fullFrame(n3, nArray4, nArray3, nArray, (int[])object);
    }

    private int[] fillStackMap(int n2, int n3, int[] nArray, TypeData[] typeDataArray) {
        int n4 = MapMaker.diffSize(typeDataArray, n3, n3 + n2);
        ConstPool constPool = this.cpool;
        int[] nArray2 = new int[n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[n3 + i2];
            if (typeData == TypeTag.TOP) {
                nArray2[n5] = 0;
                nArray[n5] = 0;
            } else {
                nArray2[n5] = typeData.getTypeTag();
                nArray[n5] = typeData.getTypeData(constPool);
                if (typeData.is2WordType()) {
                    ++i2;
                }
            }
            ++n5;
        }
        return nArray2;
    }

    private static int stackMapDiff(int n2, TypeData[] typeDataArray, int n3, TypeData[] typeDataArray2) {
        int n4 = n3 - n2;
        int n5 = n4 > 0 ? n2 : n3;
        if (MapMaker.stackMapEq(typeDataArray, typeDataArray2, n5)) {
            if (n4 > 0) {
                return MapMaker.diffSize(typeDataArray2, n5, n3);
            }
            return -MapMaker.diffSize(typeDataArray, n5, n2);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] typeDataArray, TypeData[] typeDataArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[i2];
            if (!(typeData == TypeTag.TOP ? typeDataArray2[i2] != TypeTag.TOP : !typeDataArray[i2].equals(typeDataArray2[i2]))) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] typeDataArray, int n2, int n3) {
        int n4 = 0;
        while (n2 < n3) {
            TypeData typeData = typeDataArray[n2++];
            ++n4;
            if (typeData == TypeTag.TOP || !typeData.is2WordType()) continue;
            ++n2;
        }
        return n4;
    }
}

