/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Catch;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeTag;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypedBlock;

public class Liveness {
    protected static final byte UNKNOWN = 0;
    protected static final byte READ = 1;
    protected static final byte UPDATED = 2;
    protected byte[] localsUsage;
    public static boolean useArgs = true;
    static final int NOT_YET = 0;
    static final int CHANGED_LAST = 1;
    static final int DONE = 2;
    static final int CHANGED_NOW = 3;

    public void compute(CodeIterator codeIterator, TypedBlock[] typedBlockArray, int n2, TypeData[] typeDataArray) throws BadBytecode {
        this.computeUsage(codeIterator, typedBlockArray, n2);
        if (useArgs) {
            this.useAllArgs(typedBlockArray, typeDataArray);
        }
        this.computeLiveness1(typedBlockArray[0]);
        while (this.hasChanged(typedBlockArray)) {
            this.computeLiveness2(typedBlockArray[0]);
        }
    }

    private void useAllArgs(TypedBlock[] typedBlockArray, TypeData[] typeDataArray) {
        for (int i2 = 0; i2 < typedBlockArray.length; ++i2) {
            byte[] byArray = typedBlockArray[i2].localsUsage;
            for (int i3 = 0; i3 < typeDataArray.length; ++i3) {
                if (typeDataArray[i3] == TypeTag.TOP) continue;
                byArray[i3] = 1;
            }
        }
    }

    private void computeLiveness1(TypedBlock typedBlock) {
        if (typedBlock.updating) {
            this.computeLiveness1u(typedBlock);
            return;
        }
        if (typedBlock.inputs != null) {
            return;
        }
        typedBlock.updating = true;
        byte[] byArray = typedBlock.localsUsage;
        int n2 = byArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = byArray[i2] == 1;
        }
        BasicBlock$Catch basicBlock$Catch = typedBlock.toCatch;
        while (basicBlock$Catch != null) {
            TypedBlock typedBlock2 = (TypedBlock)basicBlock$Catch.body;
            this.computeLiveness1(typedBlock2);
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!typedBlock2.inputs[i3]) continue;
                blArray[i3] = true;
            }
            basicBlock$Catch = basicBlock$Catch.next;
        }
        if (typedBlock.exit != null) {
            for (int i4 = 0; i4 < typedBlock.exit.length; ++i4) {
                TypedBlock typedBlock3 = (TypedBlock)typedBlock.exit[i4];
                this.computeLiveness1(typedBlock3);
                for (int i5 = 0; i5 < n2; ++i5) {
                    if (blArray[i5]) continue;
                    blArray[i5] = byArray[i5] == 0 && typedBlock3.inputs[i5];
                }
            }
        }
        typedBlock.updating = false;
        if (typedBlock.inputs == null) {
            typedBlock.inputs = blArray;
            typedBlock.status = 2;
        } else {
            for (int i6 = 0; i6 < n2; ++i6) {
                if (!blArray[i6] || typedBlock.inputs[i6]) continue;
                typedBlock.inputs[i6] = true;
                typedBlock.status = 3;
            }
        }
    }

    private void computeLiveness1u(TypedBlock typedBlock) {
        if (typedBlock.inputs == null) {
            byte[] byArray = typedBlock.localsUsage;
            int n2 = byArray.length;
            boolean[] blArray = new boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                blArray[i2] = byArray[i2] == 1;
            }
            typedBlock.inputs = blArray;
            typedBlock.status = 2;
        }
    }

    private void computeLiveness2(TypedBlock typedBlock) {
        if (typedBlock.updating || typedBlock.status >= 2) {
            return;
        }
        typedBlock.updating = true;
        if (typedBlock.exit == null) {
            typedBlock.status = 2;
        } else {
            boolean bl2 = false;
            for (int i2 = 0; i2 < typedBlock.exit.length; ++i2) {
                TypedBlock typedBlock2 = (TypedBlock)typedBlock.exit[i2];
                this.computeLiveness2(typedBlock2);
                if (typedBlock2.status == 2) continue;
                bl2 = true;
            }
            if (bl2) {
                bl2 = false;
                byte[] byArray = typedBlock.localsUsage;
                int n2 = byArray.length;
                for (int i3 = 0; i3 < typedBlock.exit.length; ++i3) {
                    TypedBlock typedBlock3 = (TypedBlock)typedBlock.exit[i3];
                    if (typedBlock3.status == 2) continue;
                    for (int i4 = 0; i4 < n2; ++i4) {
                        if (typedBlock.inputs[i4] || byArray[i4] != 0 || !typedBlock3.inputs[i4]) continue;
                        typedBlock.inputs[i4] = true;
                        bl2 = true;
                    }
                }
                typedBlock.status = bl2 ? 3 : 2;
            } else {
                typedBlock.status = 2;
            }
        }
        if (this.computeLiveness2except(typedBlock)) {
            typedBlock.status = 3;
        }
        typedBlock.updating = false;
    }

    private boolean computeLiveness2except(TypedBlock typedBlock) {
        BasicBlock$Catch basicBlock$Catch = typedBlock.toCatch;
        boolean bl2 = false;
        while (basicBlock$Catch != null) {
            TypedBlock typedBlock2 = (TypedBlock)basicBlock$Catch.body;
            this.computeLiveness2(typedBlock2);
            if (typedBlock2.status != 2) {
                boolean[] blArray = typedBlock.inputs;
                int n2 = blArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (blArray[i2] || !typedBlock2.inputs[i2]) continue;
                    blArray[i2] = true;
                    bl2 = true;
                }
            }
            basicBlock$Catch = basicBlock$Catch.next;
        }
        return bl2;
    }

    private boolean hasChanged(TypedBlock[] typedBlockArray) {
        int n2 = typedBlockArray.length;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypedBlock typedBlock = typedBlockArray[i2];
            if (typedBlock.status == 3) {
                typedBlock.status = 1;
                bl2 = true;
                continue;
            }
            typedBlock.status = 0;
        }
        return bl2;
    }

    private void computeUsage(CodeIterator codeIterator, TypedBlock[] typedBlockArray, int n2) throws BadBytecode {
        int n3 = typedBlockArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            TypedBlock typedBlock = typedBlockArray[i2];
            typedBlock.localsUsage = new byte[n2];
            this.localsUsage = typedBlock.localsUsage;
            int n4 = typedBlock.position;
            this.analyze(codeIterator, n4, n4 + typedBlock.length);
            this.localsUsage = null;
        }
    }

    protected final void readLocal(int n2) {
        if (this.localsUsage[n2] == 0) {
            this.localsUsage[n2] = 1;
        }
    }

    protected final void writeLocal(int n2) {
        if (this.localsUsage[n2] == 0) {
            this.localsUsage[n2] = 2;
        }
    }

    protected void analyze(CodeIterator codeIterator, int n2, int n3) throws BadBytecode {
        int n4;
        codeIterator.begin();
        codeIterator.move(n2);
        while (codeIterator.hasNext() && (n4 = codeIterator.next()) < n3) {
            int n5 = codeIterator.byteAt(n4);
            if (n5 < 96) {
                if (n5 < 54) {
                    this.doOpcode0_53(codeIterator, n4, n5);
                    continue;
                }
                this.doOpcode54_95(codeIterator, n4, n5);
                continue;
            }
            if (n5 == 132) {
                this.readLocal(codeIterator.byteAt(n4 + 1));
                continue;
            }
            if (n5 != 196) continue;
            this.doWIDE(codeIterator, n4);
        }
    }

    private void doOpcode0_53(CodeIterator codeIterator, int n2, int n3) {
        switch (n3) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.readLocal(codeIterator.byteAt(n2 + 1));
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.readLocal(n3 - 26);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.readLocal(n3 - 30);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.readLocal(n3 - 34);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.readLocal(n3 - 38);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.readLocal(n3 - 42);
            }
        }
    }

    private void doOpcode54_95(CodeIterator codeIterator, int n2, int n3) {
        switch (n3) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.writeLocal(codeIterator.byteAt(n2 + 1));
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.writeLocal(n3 - 59);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.writeLocal(n3 - 63);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.writeLocal(n3 - 67);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.writeLocal(n3 - 71);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.writeLocal(n3 - 75);
            }
        }
    }

    private void doWIDE(CodeIterator codeIterator, int n2) throws BadBytecode {
        int n3 = codeIterator.byteAt(n2 + 1);
        int n4 = codeIterator.u16bitAt(n2 + 2);
        switch (n3) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.readLocal(n4);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.writeLocal(n4);
                break;
            }
            case 132: {
                this.readLocal(n4);
            }
        }
    }
}

