/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Catch;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Mark;

public class BasicBlock$Maker {
    protected BasicBlock makeBlock(int n2) {
        return new BasicBlock(n2);
    }

    protected BasicBlock[] makeArray(int n2) {
        return new BasicBlock[n2];
    }

    private BasicBlock[] makeArray(BasicBlock basicBlock) {
        BasicBlock[] basicBlockArray = this.makeArray(1);
        basicBlockArray[0] = basicBlock;
        return basicBlockArray;
    }

    private BasicBlock[] makeArray(BasicBlock basicBlock, BasicBlock basicBlock2) {
        BasicBlock[] basicBlockArray = this.makeArray(2);
        basicBlockArray[0] = basicBlock;
        basicBlockArray[1] = basicBlock2;
        return basicBlockArray;
    }

    public BasicBlock[] make(MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        return this.make(codeIterator, 0, codeIterator.getCodeLength(), codeAttribute.getExceptionTable());
    }

    public BasicBlock[] make(CodeIterator codeIterator, int n2, int n3, ExceptionTable exceptionTable) throws BadBytecode {
        HashMap hashMap = this.makeMarks(codeIterator, n2, n3, exceptionTable);
        BasicBlock[] basicBlockArray = this.makeBlocks(hashMap);
        this.addCatchers(basicBlockArray, exceptionTable);
        return basicBlockArray;
    }

    private BasicBlock$Mark makeMark(HashMap hashMap, int n2) {
        return this.makeMark0(hashMap, n2, true, true);
    }

    private BasicBlock$Mark makeMark(HashMap hashMap, int n2, BasicBlock[] basicBlockArray, int n3, boolean bl2) {
        BasicBlock$Mark basicBlock$Mark = this.makeMark0(hashMap, n2, false, false);
        basicBlock$Mark.setJump(basicBlockArray, n3, bl2);
        return basicBlock$Mark;
    }

    private BasicBlock$Mark makeMark0(HashMap hashMap, int n2, boolean bl2, boolean bl3) {
        Integer n3 = new Integer(n2);
        BasicBlock$Mark basicBlock$Mark = (BasicBlock$Mark)hashMap.get(n3);
        if (basicBlock$Mark == null) {
            basicBlock$Mark = new BasicBlock$Mark(n2);
            hashMap.put(n3, basicBlock$Mark);
        }
        if (bl2) {
            if (basicBlock$Mark.block == null) {
                basicBlock$Mark.block = this.makeBlock(n2);
            }
            if (bl3) {
                ++basicBlock$Mark.block.incoming;
            }
        }
        return basicBlock$Mark;
    }

    private HashMap makeMarks(CodeIterator codeIterator, int n2, int n3, ExceptionTable exceptionTable) throws BadBytecode {
        int n4;
        codeIterator.begin();
        codeIterator.move(n2);
        HashMap hashMap = new HashMap();
        while (codeIterator.hasNext() && (n4 = codeIterator.next()) < n3) {
            int n5 = codeIterator.byteAt(n4);
            if (153 <= n5 && n5 <= 166 || n5 == 198 || n5 == 199) {
                BasicBlock$Mark basicBlock$Mark = this.makeMark(hashMap, n4 + codeIterator.s16bitAt(n4 + 1));
                BasicBlock$Mark basicBlock$Mark2 = this.makeMark(hashMap, n4 + 3);
                this.makeMark(hashMap, n4, this.makeArray(basicBlock$Mark.block, basicBlock$Mark2.block), 3, false);
                continue;
            }
            if (167 <= n5 && n5 <= 171) {
                switch (n5) {
                    case 167: 
                    case 168: {
                        this.makeGotoJsr(hashMap, n4, n4 + codeIterator.s16bitAt(n4 + 1), n5 == 167, 3);
                        break;
                    }
                    case 169: {
                        this.makeMark(hashMap, n4, null, 1, true);
                        break;
                    }
                    case 170: {
                        int n6;
                        int n7 = (n4 & 0xFFFFFFFC) + 4;
                        int n8 = codeIterator.s32bitAt(n7 + 4);
                        int n9 = codeIterator.s32bitAt(n7 + 8);
                        int n10 = n9 - n8 + 1;
                        BasicBlock[] basicBlockArray = this.makeArray(n10 + 1);
                        basicBlockArray[0] = this.makeMark(hashMap, (int)(n4 + codeIterator.s32bitAt((int)n7))).block;
                        int n11 = n6 + n10 * 4;
                        int n12 = 1;
                        for (n6 = n7 + 12; n6 < n11; n6 += 4) {
                            basicBlockArray[n12++] = this.makeMark(hashMap, (int)(n4 + codeIterator.s32bitAt((int)n6))).block;
                        }
                        this.makeMark(hashMap, n4, basicBlockArray, n11 - n4, true);
                        break;
                    }
                    case 171: {
                        int n10;
                        int n13 = (n4 & 0xFFFFFFFC) + 4;
                        int n14 = codeIterator.s32bitAt(n13 + 4);
                        BasicBlock[] basicBlockArray = this.makeArray(n14 + 1);
                        basicBlockArray[0] = this.makeMark(hashMap, (int)(n4 + codeIterator.s32bitAt((int)n13))).block;
                        int n15 = n10 + n14 * 8 - 4;
                        int n6 = 1;
                        for (n10 = n13 + 8 + 4; n10 < n15; n10 += 8) {
                            basicBlockArray[n6++] = this.makeMark(hashMap, (int)(n4 + codeIterator.s32bitAt((int)n10))).block;
                        }
                        this.makeMark(hashMap, n4, basicBlockArray, n15 - n4, true);
                        break;
                    }
                }
                continue;
            }
            if (172 <= n5 && n5 <= 177 || n5 == 191) {
                this.makeMark(hashMap, n4, null, 1, true);
                continue;
            }
            if (n5 == 200 || n5 == 201) {
                this.makeGotoJsr(hashMap, n4, n4 + codeIterator.s32bitAt(n4 + 1), n5 == 200, 5);
                continue;
            }
            if (n5 != 196 || codeIterator.byteAt(n4 + 1) != 169) continue;
            this.makeMark(hashMap, n4, null, 1, true);
        }
        if (exceptionTable != null) {
            n4 = exceptionTable.size();
            while (--n4 >= 0) {
                this.makeMark0(hashMap, exceptionTable.startPc(n4), true, false);
                this.makeMark(hashMap, exceptionTable.handlerPc(n4));
            }
        }
        return hashMap;
    }

    private void makeGotoJsr(HashMap hashMap, int n2, int n3, boolean bl2, int n4) {
        BasicBlock[] basicBlockArray;
        BasicBlock$Mark basicBlock$Mark = this.makeMark(hashMap, n3);
        if (bl2) {
            basicBlockArray = this.makeArray(basicBlock$Mark.block);
        } else {
            BasicBlock$Mark basicBlock$Mark2 = this.makeMark(hashMap, n2 + n4);
            basicBlockArray = this.makeArray(basicBlock$Mark.block, basicBlock$Mark2.block);
        }
        this.makeMark(hashMap, n2, basicBlockArray, n4, bl2);
    }

    private BasicBlock[] makeBlocks(HashMap hashMap) {
        Object[] objectArray = hashMap.values().toArray(new BasicBlock$Mark[hashMap.size()]);
        Arrays.sort(objectArray);
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        int n2 = 0;
        BasicBlock basicBlock = objectArray.length > 0 && ((BasicBlock$Mark)objectArray[0]).position == 0 && ((BasicBlock$Mark)objectArray[0]).block != null ? BasicBlock$Maker.getBBlock((BasicBlock$Mark)objectArray[n2++]) : this.makeBlock(0);
        arrayList.add(basicBlock);
        while (n2 < objectArray.length) {
            Object object;
            BasicBlock basicBlock2;
            if ((basicBlock2 = BasicBlock$Maker.getBBlock((BasicBlock$Mark)(object = objectArray[n2++]))) == null) {
                if (basicBlock.length > 0) {
                    basicBlock = this.makeBlock(basicBlock.position + basicBlock.length);
                    arrayList.add(basicBlock);
                }
                basicBlock.length = ((BasicBlock$Mark)object).position + ((BasicBlock$Mark)object).size - basicBlock.position;
                basicBlock.exit = ((BasicBlock$Mark)object).jump;
                basicBlock.stop = ((BasicBlock$Mark)object).alwaysJmp;
                continue;
            }
            if (basicBlock.length == 0) {
                basicBlock.length = ((BasicBlock$Mark)object).position - basicBlock.position;
                ++basicBlock2.incoming;
                basicBlock.exit = this.makeArray(basicBlock2);
            } else {
                int n3 = basicBlock.position;
                if (n3 + basicBlock.length < ((BasicBlock$Mark)object).position) {
                    basicBlock = this.makeBlock(n3 + basicBlock.length);
                    basicBlock.length = ((BasicBlock$Mark)object).position - n3;
                    basicBlock.exit = this.makeArray(basicBlock2);
                }
            }
            arrayList.add(basicBlock2);
            basicBlock = basicBlock2;
        }
        return arrayList.toArray(this.makeArray(arrayList.size()));
    }

    private static BasicBlock getBBlock(BasicBlock$Mark basicBlock$Mark) {
        BasicBlock basicBlock = basicBlock$Mark.block;
        if (basicBlock != null && basicBlock$Mark.size > 0) {
            basicBlock.exit = basicBlock$Mark.jump;
            basicBlock.length = basicBlock$Mark.size;
            basicBlock.stop = basicBlock$Mark.alwaysJmp;
        }
        return basicBlock;
    }

    private void addCatchers(BasicBlock[] basicBlockArray, ExceptionTable exceptionTable) throws BadBytecode {
        if (exceptionTable == null) {
            return;
        }
        int n2 = exceptionTable.size();
        while (--n2 >= 0) {
            BasicBlock basicBlock = BasicBlock.find(basicBlockArray, exceptionTable.handlerPc(n2));
            int n3 = exceptionTable.startPc(n2);
            int n4 = exceptionTable.endPc(n2);
            int n5 = exceptionTable.catchType(n2);
            --basicBlock.incoming;
            for (int i2 = 0; i2 < basicBlockArray.length; ++i2) {
                BasicBlock basicBlock2 = basicBlockArray[i2];
                int n6 = basicBlock2.position;
                if (n3 > n6 || n6 >= n4) continue;
                basicBlock2.toCatch = new BasicBlock$Catch(basicBlock, n5, basicBlock2.toCatch);
                ++basicBlock.incoming;
            }
        }
    }
}

