/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class DoubleMemberValue
extends MemberValue {
    int valueIndex;

    public DoubleMemberValue(int n2, ConstPool constPool) {
        super('D', constPool);
        this.valueIndex = n2;
    }

    public DoubleMemberValue(double d2, ConstPool constPool) {
        super('D', constPool);
        this.setValue(d2);
    }

    public DoubleMemberValue(ConstPool constPool) {
        super('D', constPool);
        this.setValue(0.0);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Double(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Double.TYPE;
    }

    public double getValue() {
        return this.cp.getDoubleInfo(this.valueIndex);
    }

    public void setValue(double d2) {
        this.valueIndex = this.cp.addDoubleInfo(d2);
    }

    public String toString() {
        return Double.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitDoubleMemberValue(this);
    }
}

