/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class ByteMemberValue
extends MemberValue {
    int valueIndex;

    public ByteMemberValue(int n2, ConstPool constPool) {
        super('B', constPool);
        this.valueIndex = n2;
    }

    public ByteMemberValue(byte by2, ConstPool constPool) {
        super('B', constPool);
        this.setValue(by2);
    }

    public ByteMemberValue(ConstPool constPool) {
        super('B', constPool);
        this.setValue((byte)0);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Byte(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Byte.TYPE;
    }

    public byte getValue() {
        return (byte)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(byte by2) {
        this.valueIndex = this.cp.addIntegerInfo(by2);
    }

    public String toString() {
        return Byte.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitByteMemberValue(this);
    }
}

