/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class ArrayMemberValue
extends MemberValue {
    MemberValue type;
    MemberValue[] values;

    public ArrayMemberValue(ConstPool constPool) {
        super('[', constPool);
        this.type = null;
        this.values = null;
    }

    public ArrayMemberValue(MemberValue memberValue, ConstPool constPool) {
        super('[', constPool);
        this.type = memberValue;
        this.values = null;
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) throws ClassNotFoundException {
        Class clazz;
        if (this.values == null) {
            throw new ClassNotFoundException("no array elements found: " + method.getName());
        }
        int n2 = this.values.length;
        if (this.type == null) {
            clazz = method.getReturnType().getComponentType();
            if (clazz == null || n2 > 0) {
                throw new ClassNotFoundException("broken array type: " + method.getName());
            }
        } else {
            clazz = this.type.getType(classLoader);
        }
        Object object = Array.newInstance(clazz, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Array.set(object, i2, this.values[i2].getValue(classLoader, classPool, method));
        }
        return object;
    }

    Class getType(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.type == null) {
            throw new ClassNotFoundException("no array type specified");
        }
        Object object = Array.newInstance(this.type.getType(classLoader), 0);
        return object.getClass();
    }

    public MemberValue getType() {
        return this.type;
    }

    public MemberValue[] getValue() {
        return this.values;
    }

    public void setValue(MemberValue[] memberValueArray) {
        this.values = memberValueArray;
        if (memberValueArray != null && memberValueArray.length > 0) {
            this.type = memberValueArray[0];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                stringBuffer.append(this.values[i2].toString());
                if (i2 + 1 >= this.values.length) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        int n2 = this.values.length;
        annotationsWriter.arrayValue(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2].write(annotationsWriter);
        }
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitArrayMemberValue(this);
    }
}

