/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationDefaultAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.Annotation;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;

public class AnnotationImpl
implements InvocationHandler {
    private static final String JDK_ANNOTATION_CLASS_NAME = "java.lang.annotation.Annotation";
    private static Method JDK_ANNOTATION_TYPE_METHOD = null;
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;
    private transient Class annotationType;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object make(ClassLoader classLoader, Class clazz, ClassPool classPool, Annotation annotation) {
        AnnotationImpl annotationImpl = new AnnotationImpl(annotation, classPool, classLoader);
        return Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)annotationImpl);
    }

    private AnnotationImpl(Annotation annotation, ClassPool classPool, ClassLoader classLoader) {
        this.annotation = annotation;
        this.pool = classPool;
        this.classLoader = classLoader;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    private Class getAnnotationType() {
        if (this.annotationType == null) {
            String string = this.annotation.getTypeName();
            try {
                this.annotationType = this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError("Error loading annotation class: " + string);
                noClassDefFoundError.setStackTrace(classNotFoundException.getStackTrace());
                throw noClassDefFoundError;
            }
        }
        return this.annotationType;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        MemberValue memberValue;
        String string = method.getName();
        if ((class$java$lang$Object == null ? (class$java$lang$Object = AnnotationImpl.class$("java.lang.Object")) : class$java$lang$Object) == method.getDeclaringClass()) {
            if ("equals".equals(string)) {
                Object object2 = objectArray[0];
                return new Boolean(this.checkEquals(object2));
            }
            if ("toString".equals(string)) {
                return this.annotation.toString();
            }
            if ("hashCode".equals(string)) {
                return new Integer(this.hashCode());
            }
        } else if ("annotationType".equals(string) && method.getParameterTypes().length == 0) {
            return this.getAnnotationType();
        }
        if ((memberValue = this.annotation.getMemberValue(string)) == null) {
            return this.getDefault(string, method);
        }
        return memberValue.getValue(this.classLoader, this.pool, method);
    }

    private Object getDefault(String string, Method method) throws ClassNotFoundException, RuntimeException {
        String string2 = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute annotationDefaultAttribute;
                CtClass ctClass = this.pool.get(string2);
                ClassFile classFile = ctClass.getClassFile2();
                MethodInfo methodInfo = classFile.getMethod(string);
                if (methodInfo != null && (annotationDefaultAttribute = (AnnotationDefaultAttribute)methodInfo.getAttribute("AnnotationDefault")) != null) {
                    MemberValue memberValue = annotationDefaultAttribute.getDefaultValue();
                    return memberValue.getValue(this.classLoader, this.pool, method);
                }
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException("cannot find a class file: " + string2);
            }
        }
        throw new RuntimeException("no default value: " + string2 + "." + string + "()");
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            int n2 = 0;
            this.getAnnotationType();
            Method[] methodArray = this.annotationType.getDeclaredMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                String string = methodArray[i2].getName();
                int n3 = 0;
                MemberValue memberValue = this.annotation.getMemberValue(string);
                Object object = null;
                try {
                    if (memberValue != null) {
                        object = memberValue.getValue(this.classLoader, this.pool, methodArray[i2]);
                    }
                    if (object == null) {
                        object = this.getDefault(string, methodArray[i2]);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error retrieving value " + string + " for annotation " + this.annotation.getTypeName(), exception);
                }
                if (object != null) {
                    n3 = object.getClass().isArray() ? AnnotationImpl.arrayHashCode(object) : object.hashCode();
                }
                n2 += 127 * string.hashCode() ^ n3;
            }
            this.cachedHashCode = n2;
        }
        return this.cachedHashCode;
    }

    private boolean checkEquals(Object object) throws Exception {
        Object object2;
        if (object == null) {
            return false;
        }
        if (object instanceof Proxy && (object2 = Proxy.getInvocationHandler(object)) instanceof AnnotationImpl) {
            AnnotationImpl annotationImpl = (AnnotationImpl)object2;
            return this.annotation.equals(annotationImpl.annotation);
        }
        object2 = (Class)JDK_ANNOTATION_TYPE_METHOD.invoke(object, (Object[])null);
        if (!this.getAnnotationType().equals(object2)) {
            return false;
        }
        Method[] methodArray = this.annotationType.getDeclaredMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            String string = methodArray[i2].getName();
            MemberValue memberValue = this.annotation.getMemberValue(string);
            Object object3 = null;
            Object object4 = null;
            try {
                if (memberValue != null) {
                    object3 = memberValue.getValue(this.classLoader, this.pool, methodArray[i2]);
                }
                if (object3 == null) {
                    object3 = this.getDefault(string, methodArray[i2]);
                }
                object4 = methodArray[i2].invoke(object, (Object[])null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error retrieving value " + string + " for annotation " + this.annotation.getTypeName(), exception);
            }
            if (object3 == null && object4 != null) {
                return false;
            }
            if (object3 == null || object3.equals(object4)) continue;
            return false;
        }
        return true;
    }

    private static int arrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = 1;
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n3 = 0;
            if (objectArray[i2] != null) {
                n3 = objectArray[i2].hashCode();
            }
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName(JDK_ANNOTATION_CLASS_NAME);
            JDK_ANNOTATION_TYPE_METHOD = clazz.getMethod("annotationType", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

