/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Subroutine;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Util;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map subTable = new HashMap();
    Set done = new HashSet();

    public Subroutine[] scan(MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        this.subroutines = new Subroutine[codeAttribute.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, codeIterator, null);
        ExceptionTable exceptionTable = codeAttribute.getExceptionTable();
        for (int i2 = 0; i2 < exceptionTable.size(); ++i2) {
            int n2 = exceptionTable.handlerPc(i2);
            this.scan(n2, codeIterator, this.subroutines[exceptionTable.startPc(i2)]);
        }
        return this.subroutines;
    }

    private void scan(int n2, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        boolean bl2;
        if (this.done.contains(new Integer(n2))) {
            return;
        }
        this.done.add(new Integer(n2));
        int n3 = codeIterator.lookAhead();
        codeIterator.move(n2);
        while (bl2 = this.scanOp(n2 = codeIterator.next(), codeIterator, subroutine) && codeIterator.hasNext()) {
        }
        codeIterator.move(n3);
    }

    private boolean scanOp(int n2, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        this.subroutines[n2] = subroutine;
        int n3 = codeIterator.byteAt(n2);
        if (n3 == 170) {
            this.scanTableSwitch(n2, codeIterator, subroutine);
            return false;
        }
        if (n3 == 171) {
            this.scanLookupSwitch(n2, codeIterator, subroutine);
            return false;
        }
        if (Util.isReturn(n3) || n3 == 169 || n3 == 191) {
            return false;
        }
        if (Util.isJumpInstruction(n3)) {
            int n4 = Util.getJumpTarget(n2, codeIterator);
            if (n3 == 168 || n3 == 201) {
                Subroutine subroutine2 = (Subroutine)this.subTable.get(new Integer(n4));
                if (subroutine2 == null) {
                    subroutine2 = new Subroutine(n4, n2);
                    this.subTable.put(new Integer(n4), subroutine2);
                    this.scan(n4, codeIterator, subroutine2);
                } else {
                    subroutine2.addCaller(n2);
                }
            } else {
                this.scan(n4, codeIterator, subroutine);
                if (Util.isGoto(n3)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int n2, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        this.scan(n2 + codeIterator.s32bitAt(n3), codeIterator, subroutine);
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = n4 * 8 + (n3 += 4);
        n3 += 4;
        while (n3 < n5) {
            int n6 = codeIterator.s32bitAt(n3) + n2;
            this.scan(n6, codeIterator, subroutine);
            n3 += 8;
        }
    }

    private void scanTableSwitch(int n2, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        this.scan(n2 + codeIterator.s32bitAt(n3), codeIterator, subroutine);
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = codeIterator.s32bitAt(n3 += 4);
        int n6 = (n5 - n4 + 1) * 4 + (n3 += 4);
        while (n3 < n6) {
            int n7 = codeIterator.s32bitAt(n3) + n2;
            this.scan(n7, codeIterator, subroutine);
            n3 += 4;
        }
    }
}

