/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$ArrayType;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$BaseType;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$ClassSignature;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$ClassType;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$Cursor;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$MethodSignature;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$ObjectType;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$Type;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$TypeArgument;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$TypeParameter;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute$TypeVariable;

public class SignatureAttribute
extends AttributeInfo {
    public static final String tag = "Signature";

    SignatureAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    public SignatureAttribute(ConstPool constPool, String string) {
        super(constPool, tag);
        int n2 = constPool.addUtf8Info(string);
        byte[] byArray = new byte[]{(byte)(n2 >>> 8), (byte)n2};
        this.set(byArray);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        return new SignatureAttribute(constPool, this.getSignature());
    }

    public static SignatureAttribute$ClassSignature toClassSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static SignatureAttribute$MethodSignature toMethodSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseMethodSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static SignatureAttribute$ObjectType toFieldSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseObjectType(string, new SignatureAttribute$Cursor(null), false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    private static SignatureAttribute$ClassSignature parseSig(String string) throws BadBytecode, IndexOutOfBoundsException {
        SignatureAttribute$Cursor signatureAttribute$Cursor = new SignatureAttribute$Cursor(null);
        SignatureAttribute$TypeParameter[] signatureAttribute$TypeParameterArray = SignatureAttribute.parseTypeParams(string, signatureAttribute$Cursor);
        SignatureAttribute$ClassType signatureAttribute$ClassType = SignatureAttribute.parseClassType(string, signatureAttribute$Cursor);
        int n2 = string.length();
        ArrayList<SignatureAttribute$ClassType> arrayList = new ArrayList<SignatureAttribute$ClassType>();
        while (signatureAttribute$Cursor.position < n2 && string.charAt(signatureAttribute$Cursor.position) == 'L') {
            arrayList.add(SignatureAttribute.parseClassType(string, signatureAttribute$Cursor));
        }
        SignatureAttribute$ClassType[] signatureAttribute$ClassTypeArray = arrayList.toArray(new SignatureAttribute$ClassType[arrayList.size()]);
        return new SignatureAttribute$ClassSignature(signatureAttribute$TypeParameterArray, signatureAttribute$ClassType, signatureAttribute$ClassTypeArray);
    }

    private static SignatureAttribute$MethodSignature parseMethodSig(String string) throws BadBytecode {
        Object object;
        SignatureAttribute$Type signatureAttribute$Type;
        SignatureAttribute$Cursor signatureAttribute$Cursor = new SignatureAttribute$Cursor(null);
        SignatureAttribute$TypeParameter[] signatureAttribute$TypeParameterArray = SignatureAttribute.parseTypeParams(string, signatureAttribute$Cursor);
        if (string.charAt(signatureAttribute$Cursor.position++) != '(') {
            throw SignatureAttribute.error(string);
        }
        ArrayList<SignatureAttribute$Type> arrayList = new ArrayList<SignatureAttribute$Type>();
        while (string.charAt(signatureAttribute$Cursor.position) != ')') {
            signatureAttribute$Type = SignatureAttribute.parseType(string, signatureAttribute$Cursor);
            arrayList.add(signatureAttribute$Type);
        }
        ++signatureAttribute$Cursor.position;
        signatureAttribute$Type = SignatureAttribute.parseType(string, signatureAttribute$Cursor);
        int n2 = string.length();
        ArrayList<SignatureAttribute$Type[]> arrayList2 = new ArrayList<SignatureAttribute$Type[]>();
        while (signatureAttribute$Cursor.position < n2 && string.charAt(signatureAttribute$Cursor.position) == '^') {
            ++signatureAttribute$Cursor.position;
            object = SignatureAttribute.parseObjectType(string, signatureAttribute$Cursor, false);
            if (object instanceof SignatureAttribute$ArrayType) {
                throw SignatureAttribute.error(string);
            }
            arrayList2.add((SignatureAttribute$Type[])object);
        }
        object = arrayList.toArray(new SignatureAttribute$Type[arrayList.size()]);
        SignatureAttribute$ObjectType[] signatureAttribute$ObjectTypeArray = arrayList2.toArray(new SignatureAttribute$ObjectType[arrayList2.size()]);
        return new SignatureAttribute$MethodSignature(signatureAttribute$TypeParameterArray, (SignatureAttribute$Type[])object, signatureAttribute$Type, signatureAttribute$ObjectTypeArray);
    }

    private static SignatureAttribute$TypeParameter[] parseTypeParams(String string, SignatureAttribute$Cursor signatureAttribute$Cursor) throws BadBytecode {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.charAt(signatureAttribute$Cursor.position) == '<') {
            ++signatureAttribute$Cursor.position;
            while (string.charAt(signatureAttribute$Cursor.position) != '>') {
                Object object;
                int n2 = signatureAttribute$Cursor.position;
                int n3 = signatureAttribute$Cursor.indexOf(string, 58);
                SignatureAttribute$ObjectType signatureAttribute$ObjectType = SignatureAttribute.parseObjectType(string, signatureAttribute$Cursor, true);
                ArrayList<SignatureAttribute$ObjectType> arrayList2 = new ArrayList<SignatureAttribute$ObjectType>();
                while (string.charAt(signatureAttribute$Cursor.position) == ':') {
                    ++signatureAttribute$Cursor.position;
                    object = SignatureAttribute.parseObjectType(string, signatureAttribute$Cursor, false);
                    arrayList2.add((SignatureAttribute$ObjectType)object);
                }
                object = new SignatureAttribute$TypeParameter(string, n2, n3, signatureAttribute$ObjectType, arrayList2.toArray(new SignatureAttribute$ObjectType[arrayList2.size()]));
                arrayList.add(object);
            }
            ++signatureAttribute$Cursor.position;
        }
        return arrayList.toArray(new SignatureAttribute$TypeParameter[arrayList.size()]);
    }

    private static SignatureAttribute$ObjectType parseObjectType(String string, SignatureAttribute$Cursor signatureAttribute$Cursor, boolean bl2) throws BadBytecode {
        int n2 = signatureAttribute$Cursor.position;
        switch (string.charAt(n2)) {
            case 'L': {
                return SignatureAttribute.parseClassType2(string, signatureAttribute$Cursor, null);
            }
            case 'T': {
                int n3 = signatureAttribute$Cursor.indexOf(string, 59);
                return new SignatureAttribute$TypeVariable(string, n2 + 1, n3);
            }
            case '[': {
                return SignatureAttribute.parseArray(string, signatureAttribute$Cursor);
            }
        }
        if (bl2) {
            return null;
        }
        throw SignatureAttribute.error(string);
    }

    private static SignatureAttribute$ClassType parseClassType(String string, SignatureAttribute$Cursor signatureAttribute$Cursor) throws BadBytecode {
        if (string.charAt(signatureAttribute$Cursor.position) == 'L') {
            return SignatureAttribute.parseClassType2(string, signatureAttribute$Cursor, null);
        }
        throw SignatureAttribute.error(string);
    }

    private static SignatureAttribute$ClassType parseClassType2(String string, SignatureAttribute$Cursor signatureAttribute$Cursor, SignatureAttribute$ClassType signatureAttribute$ClassType) throws BadBytecode {
        SignatureAttribute$TypeArgument[] signatureAttribute$TypeArgumentArray;
        char c2;
        int n2 = ++signatureAttribute$Cursor.position;
        while ((c2 = string.charAt(signatureAttribute$Cursor.position++)) != '$' && c2 != '<' && c2 != ';') {
        }
        int n3 = signatureAttribute$Cursor.position - 1;
        if (c2 == '<') {
            signatureAttribute$TypeArgumentArray = SignatureAttribute.parseTypeArgs(string, signatureAttribute$Cursor);
            c2 = string.charAt(signatureAttribute$Cursor.position++);
        } else {
            signatureAttribute$TypeArgumentArray = null;
        }
        SignatureAttribute$ClassType signatureAttribute$ClassType2 = SignatureAttribute$ClassType.make(string, n2, n3, signatureAttribute$TypeArgumentArray, signatureAttribute$ClassType);
        if (c2 == '$') {
            --signatureAttribute$Cursor.position;
            return SignatureAttribute.parseClassType2(string, signatureAttribute$Cursor, signatureAttribute$ClassType2);
        }
        return signatureAttribute$ClassType2;
    }

    private static SignatureAttribute$TypeArgument[] parseTypeArgs(String string, SignatureAttribute$Cursor signatureAttribute$Cursor) throws BadBytecode {
        char c2;
        ArrayList<SignatureAttribute$TypeArgument> arrayList = new ArrayList<SignatureAttribute$TypeArgument>();
        while ((c2 = string.charAt(signatureAttribute$Cursor.position++)) != '>') {
            SignatureAttribute$TypeArgument signatureAttribute$TypeArgument;
            if (c2 == '*') {
                signatureAttribute$TypeArgument = new SignatureAttribute$TypeArgument(null, '*');
            } else {
                if (c2 != '+' && c2 != '-') {
                    c2 = ' ';
                    --signatureAttribute$Cursor.position;
                }
                signatureAttribute$TypeArgument = new SignatureAttribute$TypeArgument(SignatureAttribute.parseObjectType(string, signatureAttribute$Cursor, false), c2);
            }
            arrayList.add(signatureAttribute$TypeArgument);
        }
        return arrayList.toArray(new SignatureAttribute$TypeArgument[arrayList.size()]);
    }

    private static SignatureAttribute$ObjectType parseArray(String string, SignatureAttribute$Cursor signatureAttribute$Cursor) throws BadBytecode {
        int n2 = 1;
        while (string.charAt(++signatureAttribute$Cursor.position) == '[') {
            ++n2;
        }
        return new SignatureAttribute$ArrayType(n2, SignatureAttribute.parseType(string, signatureAttribute$Cursor));
    }

    private static SignatureAttribute$Type parseType(String string, SignatureAttribute$Cursor signatureAttribute$Cursor) throws BadBytecode {
        SignatureAttribute$Type signatureAttribute$Type = SignatureAttribute.parseObjectType(string, signatureAttribute$Cursor, true);
        if (signatureAttribute$Type == null) {
            signatureAttribute$Type = new SignatureAttribute$BaseType(string.charAt(signatureAttribute$Cursor.position++));
        }
        return signatureAttribute$Type;
    }

    private static BadBytecode error(String string) {
        return new BadBytecode("bad signature: " + string);
    }

    static /* synthetic */ BadBytecode access$000(String string) {
        return SignatureAttribute.error(string);
    }
}

