/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;

public class LocalVariableAttribute
extends AttributeInfo {
    public static final String tag = "LocalVariableTable";
    public static final String typeTag = "LocalVariableTypeTable";

    public LocalVariableAttribute(ConstPool constPool) {
        this(constPool, tag);
    }

    public LocalVariableAttribute(ConstPool constPool, String string) {
        super(constPool, string, new byte[2]);
        ByteArray.write16bit(0, this.info, 0);
    }

    LocalVariableAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    private LocalVariableAttribute(ConstPool constPool, String string, byte[] byArray) {
        super(constPool, string, byArray);
    }

    public void addEntry(int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.info.length;
        byte[] byArray = new byte[n7 + 10];
        ByteArray.write16bit(this.tableLength() + 1, byArray, 0);
        for (int i2 = 2; i2 < n7; ++i2) {
            byArray[i2] = this.info[i2];
        }
        ByteArray.write16bit(n2, byArray, n7);
        ByteArray.write16bit(n3, byArray, n7 + 2);
        ByteArray.write16bit(n4, byArray, n7 + 4);
        ByteArray.write16bit(n5, byArray, n7 + 6);
        ByteArray.write16bit(n6, byArray, n7 + 8);
        this.info = byArray;
    }

    public void shiftIndex(int n2, int n3) {
        int n4 = this.info.length;
        for (int i2 = 2; i2 < n4; i2 += 10) {
            int n5 = ByteArray.readU16bit(this.info, i2 + 8);
            if (n5 < n2) continue;
            ByteArray.write16bit(n5 + n3, this.info, i2 + 8);
        }
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public int startPc(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 10 + 2);
    }

    public int codeLength(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 10 + 4);
    }

    void shiftPc(int n2, int n3, boolean bl2) {
        int n4 = this.tableLength();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * 10 + 2;
            int n6 = ByteArray.readU16bit(this.info, n5);
            int n7 = ByteArray.readU16bit(this.info, n5 + 2);
            if (n6 > n2 || bl2 && n6 == n2 && n6 != 0) {
                ByteArray.write16bit(n6 + n3, this.info, n5);
                continue;
            }
            if (n6 + n7 <= n2) continue;
            ByteArray.write16bit(n7 + n3, this.info, n5 + 2);
        }
    }

    public int nameIndex(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 10 + 6);
    }

    public String variableName(int n2) {
        return this.getConstPool().getUtf8Info(this.nameIndex(n2));
    }

    public int descriptorIndex(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 10 + 8);
    }

    public int signatureIndex(int n2) {
        return this.descriptorIndex(n2);
    }

    public String descriptor(int n2) {
        return this.getConstPool().getUtf8Info(this.descriptorIndex(n2));
    }

    public String signature(int n2) {
        return this.descriptor(n2);
    }

    public int index(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 10 + 10);
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        byte[] byArray = this.get();
        byte[] byArray2 = new byte[byArray.length];
        ConstPool constPool2 = this.getConstPool();
        LocalVariableAttribute localVariableAttribute = new LocalVariableAttribute(constPool, this.getName(), byArray2);
        int n2 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n2, byArray2, 0);
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = ByteArray.readU16bit(byArray, n3);
            int n5 = ByteArray.readU16bit(byArray, n3 + 2);
            int n6 = ByteArray.readU16bit(byArray, n3 + 4);
            int n7 = ByteArray.readU16bit(byArray, n3 + 6);
            int n8 = ByteArray.readU16bit(byArray, n3 + 8);
            ByteArray.write16bit(n4, byArray2, n3);
            ByteArray.write16bit(n5, byArray2, n3 + 2);
            if (n6 != 0) {
                n6 = constPool2.copy(n6, constPool, null);
            }
            ByteArray.write16bit(n6, byArray2, n3 + 4);
            if (n7 != 0) {
                String string = constPool2.getUtf8Info(n7);
                string = Descriptor.rename(string, map);
                n7 = constPool.addUtf8Info(string);
            }
            ByteArray.write16bit(n7, byArray2, n3 + 6);
            ByteArray.write16bit(n8, byArray2, n3 + 8);
            n3 += 10;
        }
        return localVariableAttribute;
    }
}

