/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.PrintStream;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Mnemonic;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;

public class InstructionPrinter
implements Opcode {
    private static final String[] opcodes = Mnemonic.OPCODE;
    private final PrintStream stream;

    public InstructionPrinter(PrintStream printStream) {
        this.stream = printStream;
    }

    public static void print(CtMethod ctMethod, PrintStream printStream) {
        new InstructionPrinter(printStream).print(ctMethod);
    }

    public void print(CtMethod ctMethod) {
        MethodInfo methodInfo = ctMethod.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return;
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int n2;
            try {
                n2 = codeIterator.next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.stream.println(n2 + ": " + InstructionPrinter.instructionString(codeIterator, n2, constPool));
        }
    }

    public static String instructionString(CodeIterator codeIterator, int n2, ConstPool constPool) {
        int n3 = codeIterator.byteAt(n2);
        if (n3 > opcodes.length || n3 < 0) {
            throw new IllegalArgumentException("Invalid opcode, opcode: " + n3 + " pos: " + n2);
        }
        String string = opcodes[n3];
        switch (n3) {
            case 16: {
                return string + " " + codeIterator.byteAt(n2 + 1);
            }
            case 17: {
                return string + " " + codeIterator.s16bitAt(n2 + 1);
            }
            case 18: {
                return string + " " + InstructionPrinter.ldc(constPool, codeIterator.byteAt(n2 + 1));
            }
            case 19: 
            case 20: {
                return string + " " + InstructionPrinter.ldc(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return string + " " + codeIterator.byteAt(n2 + 1);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return string + " " + (codeIterator.s16bitAt(n2 + 1) + n2);
            }
            case 132: {
                return string + " " + codeIterator.byteAt(n2 + 1);
            }
            case 167: 
            case 168: {
                return string + " " + (codeIterator.s16bitAt(n2 + 1) + n2);
            }
            case 169: {
                return string + " " + codeIterator.byteAt(n2 + 1);
            }
            case 170: {
                return InstructionPrinter.tableSwitch(codeIterator, n2);
            }
            case 171: {
                return InstructionPrinter.lookupSwitch(codeIterator, n2);
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return string + " " + InstructionPrinter.fieldInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 182: 
            case 183: 
            case 184: {
                return string + " " + InstructionPrinter.methodInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 185: {
                return string + " " + InstructionPrinter.interfaceMethodInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 186: {
                throw new RuntimeException("Bad opcode 186");
            }
            case 187: {
                return string + " " + InstructionPrinter.classInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 188: {
                return string + " " + InstructionPrinter.arrayInfo(codeIterator.byteAt(n2 + 1));
            }
            case 189: {
                return string + " " + InstructionPrinter.classInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 196: {
                return InstructionPrinter.wide(codeIterator, n2);
            }
            case 197: {
                return string + " " + InstructionPrinter.classInfo(constPool, codeIterator.u16bitAt(n2 + 1));
            }
            case 200: 
            case 201: {
                return string + " " + (codeIterator.s32bitAt(n2 + 1) + n2);
            }
        }
        return string;
    }

    private static String wide(CodeIterator codeIterator, int n2) {
        int n3 = codeIterator.byteAt(n2 + 1);
        int n4 = codeIterator.u16bitAt(n2 + 2);
        switch (n3) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                return opcodes[n3] + " " + n4;
            }
        }
        throw new RuntimeException("Invalid WIDE operand");
    }

    private static String arrayInfo(int n2) {
        switch (n2) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        throw new RuntimeException("Invalid array type");
    }

    private static String classInfo(ConstPool constPool, int n2) {
        return "#" + n2 + " = Class " + constPool.getClassInfo(n2);
    }

    private static String interfaceMethodInfo(ConstPool constPool, int n2) {
        return "#" + n2 + " = Method " + constPool.getInterfaceMethodrefClassName(n2) + "." + constPool.getInterfaceMethodrefName(n2) + "(" + constPool.getInterfaceMethodrefType(n2) + ")";
    }

    private static String methodInfo(ConstPool constPool, int n2) {
        return "#" + n2 + " = Method " + constPool.getMethodrefClassName(n2) + "." + constPool.getMethodrefName(n2) + "(" + constPool.getMethodrefType(n2) + ")";
    }

    private static String fieldInfo(ConstPool constPool, int n2) {
        return "#" + n2 + " = Field " + constPool.getFieldrefClassName(n2) + "." + constPool.getFieldrefName(n2) + "(" + constPool.getFieldrefType(n2) + ")";
    }

    private static String lookupSwitch(CodeIterator codeIterator, int n2) {
        StringBuffer stringBuffer = new StringBuffer("lookupswitch {\n");
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        stringBuffer.append("\t\tdefault: ").append(n2 + codeIterator.s32bitAt(n3)).append("\n");
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = n4 * 8 + (n3 += 4);
        while (n3 < n5) {
            int n6 = codeIterator.s32bitAt(n3);
            int n7 = codeIterator.s32bitAt(n3 + 4) + n2;
            stringBuffer.append("\t\t").append(n6).append(": ").append(n7).append("\n");
            n3 += 8;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    private static String tableSwitch(CodeIterator codeIterator, int n2) {
        StringBuffer stringBuffer = new StringBuffer("tableswitch {\n");
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        stringBuffer.append("\t\tdefault: ").append(n2 + codeIterator.s32bitAt(n3)).append("\n");
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = codeIterator.s32bitAt(n3 += 4);
        int n6 = (n5 - n4 + 1) * 4 + (n3 += 4);
        int n7 = n4;
        while (n3 < n6) {
            int n8 = codeIterator.s32bitAt(n3) + n2;
            stringBuffer.append("\t\t").append(n7).append(": ").append(n8).append("\n");
            n3 += 4;
            ++n7;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    private static String ldc(ConstPool constPool, int n2) {
        int n3 = constPool.getTag(n2);
        switch (n3) {
            case 8: {
                return "#" + n2 + " = \"" + constPool.getStringInfo(n2) + "\"";
            }
            case 3: {
                return "#" + n2 + " = int " + constPool.getIntegerInfo(n2);
            }
            case 4: {
                return "#" + n2 + " = float " + constPool.getFloatInfo(n2);
            }
            case 5: {
                return "#" + n2 + " = long " + constPool.getLongInfo(n2);
            }
            case 6: {
                return "#" + n2 + " = int " + constPool.getDoubleInfo(n2);
            }
            case 7: {
                return InstructionPrinter.classInfo(constPool, n2);
            }
        }
        throw new RuntimeException("bad LDC: " + n3);
    }
}

